/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import java.util.Vector;

public class CodeList
extends CodeBlock {
    Vector<CodeBlock> blocks = new Vector();

    public CodeList() {
        this(null);
    }

    public CodeList(CodeList codeList) {
        super(codeList);
    }

    public void remove(CodeBlock codeBlock) {
        this.blocks.remove(codeBlock);
        codeBlock.setParent(null);
    }

    public void add(CodeBlock codeBlock) {
        this.add(codeBlock, 0);
    }

    public void add(CodeBlock codeBlock, int n) {
        if (codeBlock == null) {
            return;
        }
        codeBlock.additionalIndent = n;
        if (codeBlock.getParent() != null) {
            codeBlock.getParent().remove(codeBlock);
        }
        this.blocks.add(codeBlock);
        codeBlock.setParent(this);
    }

    public void add(int n, CodeBlock codeBlock, int n2) {
        if (codeBlock == null) {
            return;
        }
        codeBlock.additionalIndent = n2;
        if (codeBlock.getParent() != null) {
            codeBlock.getParent().remove(codeBlock);
        }
        this.blocks.add(n, codeBlock);
        codeBlock.setParent(this);
    }

    public void addNoIndent(CodeBlock codeBlock) {
        if (codeBlock != null) {
            this.add(codeBlock);
            codeBlock.additionalIndent = -1;
        }
    }

    @Override
    public String getCode(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (CodeBlock codeBlock : this.blocks) {
            stringBuilder.append(codeBlock.getCode(codeBlock.additionalIndent + n + 1));
        }
        return stringBuilder.toString();
    }

    @Override
    public void clear() {
        this.blocks.clear();
    }

    @Override
    public int size() {
        int n = 0;
        for (CodeBlock codeBlock : this.blocks) {
            n += codeBlock.size();
        }
        return n;
    }
}

