/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.impl.GraphClassImpl;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class AttributedElementCodeGenerator<SC extends AttributedElementClass<SC, IC>, IC extends AttributedElement<SC, IC>>
extends CodeGenerator {
    protected SortedSet<String> interfaces;
    protected SC aec;

    protected AttributedElementCodeGenerator(SC SC, String string, CodeGeneratorConfiguration codeGeneratorConfiguration) {
        super(string, SC.getPackageName(), codeGeneratorConfiguration);
        this.aec = SC;
        this.rootBlock.setVariable("schemaTypeName", this.getSchemaTypeName());
        this.rootBlock.setVariable("qualifiedClassName", this.aec.getQualifiedName());
        this.rootBlock.setVariable("schemaName", this.aec.getSchema().getName());
        this.rootBlock.setVariable("javaClassName", string + "." + this.aec.getQualifiedName());
        this.rootBlock.setVariable("qualifiedImplClassName", string + ".impl.std" + this.aec.getQualifiedName() + "Impl");
        this.rootBlock.setVariable("simpleClassName", this.aec.getSimpleName());
        this.rootBlock.setVariable("simpleImplClassName", this.aec.getSimpleName() + "Impl");
        this.rootBlock.setVariable("uniqueClassName", this.aec.getUniqueName());
        this.rootBlock.setVariable("schemaPackageName", string);
        this.rootBlock.setVariable("theGraph", "graph");
        this.interfaces = new TreeSet<String>();
        this.interfaces.add(this.aec.getQualifiedName());
        this.rootBlock.setVariable("isAbstractClass", this.aec.isAbstract() ? "true" : "false");
    }

    protected abstract String getSchemaTypeName();

    protected String absoluteName(AttributedElementClass<?, ?> attributedElementClass) {
        return this.schemaRootPackageName + "." + attributedElementClass.getQualifiedName();
    }

    @Override
    protected CodeBlock createBody() {
        CodeList codeList = new CodeList();
        if (this.currentCycle.isStdImpl()) {
            codeList.add(this.createFields(this.aec.getAttributeList()));
            codeList.add(this.createConstructor());
            codeList.add(this.createGetAttributedElementClassMethod());
            codeList.add(this.createGetSchemaClassMethod());
            codeList.add(this.createGenericGetter(this.aec.getAttributeList()));
            codeList.add(this.createGenericSetter(this.aec.getAttributeList()));
            codeList.add(this.createGettersAndSetters(this.aec.getAttributeList()));
            codeList.add(this.createReadAttributesMethod(this.aec.getAttributeList()));
            codeList.add(this.createReadAttributesFromStringMethod(this.aec.getAttributeList()));
            codeList.add(this.createWriteAttributesMethod(this.aec.getAttributeList()));
            codeList.add(this.createWriteAttributeToStringMethod(this.aec.getAttributeList()));
        }
        if (this.currentCycle.isAbstract()) {
            codeList.add(this.createAttributedElementClassConstant());
            codeList.add(this.createGettersAndSetters(this.aec.getOwnAttributeList()));
        }
        return codeList;
    }

    protected abstract CodeBlock createAttributedElementClassConstant();

    @Override
    protected CodeBlock createHeader() {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        codeSnippet.setVariable("classOrInterface", this.currentCycle.isStdImpl() ? " class" : " interface");
        codeSnippet.setVariable("abstract", this.currentCycle.isStdImpl() && this.aec.isAbstract() ? " abstract" : "");
        codeSnippet.setVariable("impl", this.currentCycle.isStdImpl() && !this.aec.isAbstract() ? "Impl" : "");
        codeSnippet.add("public#abstract##classOrInterface# #simpleClassName##impl##extends##implements# {");
        codeSnippet.setVariable("extends", this.currentCycle.isStdImpl() ? " extends #baseClassName#" : "");
        StringBuilder stringBuilder = new StringBuilder();
        if (this.interfaces.size() > 0) {
            String string = this.currentCycle.isStdImpl() ? " implements " : " extends ";
            for (String string2 : this.interfaces) {
                if (!this.currentCycle.isStdImpl() && string2.equals(this.aec.getQualifiedName())) continue;
                if (string2.equals("Vertex") || string2.equals("Edge") || string2.equals("Graph")) {
                    stringBuilder.append(string);
                    stringBuilder.append("#jgPackage#." + string2);
                    string = ", ";
                    continue;
                }
                stringBuilder.append(string);
                stringBuilder.append(this.schemaRootPackageName + "." + string2);
                string = ", ";
            }
        }
        codeSnippet.setVariable("implements", stringBuilder.toString());
        return codeSnippet;
    }

    protected CodeBlock createStaticImplementationClassField() {
        return new CodeSnippet(true, "/**", " * refers to the default implementation class of this interface", " */", "public static final java.lang.Class<#qualifiedImplClassName#> IMPLEMENTATION_CLASS = #qualifiedImplClassName#.class;");
    }

    protected CodeBlock createSpecialConstructorCode() {
        return null;
    }

    protected CodeBlock createConstructor() {
        CodeList codeList = new CodeList();
        codeList.addNoIndent(new CodeSnippet(true, "public #simpleClassName#Impl(int id, #jgPackage#.Graph g) {", "\tsuper(id, g);"));
        if (this.hasDefaultAttributeValues()) {
            codeList.addNoIndent(new CodeSnippet("\tinitializeAttributesWithDefaultValues();"));
        }
        codeList.add(this.createSpecialConstructorCode());
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    protected boolean hasDefaultAttributeValues() {
        for (Attribute attribute : this.aec.getAttributeList()) {
            if (attribute.getDefaultValueAsString() == null) continue;
            return true;
        }
        return false;
    }

    protected abstract CodeBlock createGetAttributedElementClassMethod();

    protected CodeBlock createGetSchemaClassMethod() {
        return new CodeSnippet(true, "@Override", "public final java.lang.Class<? extends #jgPackage#.#graphElementClass#> getSchemaClass() {", "\treturn #javaClassName#.class;", "}");
    }

    protected CodeBlock createGenericGetter(List<Attribute> list) {
        CodeList codeList = new CodeList();
        this.addImports("#jgPackage#.exception.NoSuchAttributeException");
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        codeList.addNoIndent(codeSnippet);
        if (!list.isEmpty()) {
            codeSnippet.add("@SuppressWarnings(\"unchecked\")");
        }
        codeSnippet.add("public <T> T getAttribute(String attributeName) {");
        for (Attribute attribute : list) {
            CodeSnippet codeSnippet2 = new CodeSnippet();
            if (attribute.getDomain().isPrimitive()) {
                codeSnippet2.setVariable("attributeClassName", " (" + attribute.getDomain().getJavaClassName(this.schemaRootPackageName) + ")");
            } else {
                codeSnippet2.setVariable("attributeClassName", "");
            }
            codeSnippet2.setVariable("name", attribute.getName());
            codeSnippet2.setVariable("isOrGet", attribute.getDomain().isBoolean() ? "is" : "get");
            codeSnippet2.setVariable("cName", attribute.getName());
            codeSnippet2.add("if (attributeName.equals(\"#name#\")) return (T)#attributeClassName# #isOrGet#_#cName#();");
            codeList.add(codeSnippet2);
        }
        codeList.add(new CodeSnippet("throw new NoSuchAttributeException(\"#qualifiedClassName# doesn't contain an attribute \" + attributeName);"));
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    protected CodeBlock createGenericSetter(List<Attribute> list) {
        CodeList codeList = new CodeList();
        this.addImports("#jgPackage#.exception.NoSuchAttributeException");
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        boolean bl = false;
        for (Attribute attribute : list) {
            if (!attribute.getDomain().isComposite() || attribute.getDomain() instanceof RecordDomain) continue;
            bl = true;
            break;
        }
        if (bl) {
            codeSnippet.add("@SuppressWarnings(\"unchecked\")");
        }
        codeSnippet.add("public <T> void setAttribute(String attributeName, T data) {");
        codeList.addNoIndent(codeSnippet);
        for (Attribute attribute : list) {
            CodeSnippet codeSnippet2 = new CodeSnippet();
            codeSnippet2.setVariable("name", attribute.getName());
            if (attribute.getDomain().isComposite()) {
                codeSnippet2.setVariable("attributeClassName", attribute.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
            } else {
                codeSnippet2.setVariable("attributeClassName", attribute.getDomain().getJavaClassName(this.schemaRootPackageName));
            }
            boolean bl2 = false;
            if (attribute.getDomain() instanceof EnumDomain) {
                bl2 = true;
            }
            if (bl2) {
                codeSnippet2.add("if (attributeName.equals(\"#name#\")) {");
                codeSnippet2.add("\tif (data instanceof String) {");
                codeSnippet2.add("\t\tset_#name#(#attributeClassName#.valueOfPermitNull((String) data));");
                codeSnippet2.add("\t} else {");
                codeSnippet2.add("\t\tset_#name#((#attributeClassName#) data);");
                codeSnippet2.add("\t}");
                codeSnippet2.add("\treturn;");
                codeSnippet2.add("}");
            } else {
                codeSnippet2.add("if (attributeName.equals(\"#name#\")) {");
                codeSnippet2.add("\tset_#name#((#attributeClassName#) data);");
                codeSnippet2.add("\treturn;");
                codeSnippet2.add("}");
            }
            codeList.add(codeSnippet2);
        }
        codeList.add(new CodeSnippet("throw new NoSuchAttributeException(\"#qualifiedClassName# doesn't contain an attribute \" + attributeName);"));
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    protected CodeBlock createFields(List<Attribute> list) {
        CodeList codeList = new CodeList();
        for (Attribute attribute : list) {
            codeList.addNoIndent(this.createField(attribute));
        }
        return codeList;
    }

    protected CodeBlock createGettersAndSetters(List<Attribute> list) {
        CodeList codeList = new CodeList();
        for (Attribute attribute : list) {
            codeList.addNoIndent(this.createGetter(attribute));
            codeList.addNoIndent(this.createSetter(attribute));
        }
        return codeList;
    }

    protected CodeBlock createGetter(Attribute attribute) {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        codeSnippet.setVariable("name", attribute.getName());
        codeSnippet.setVariable("type", attribute.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
        codeSnippet.setVariable("isOrGet", attribute.getDomain().isBoolean() ? "is" : "get");
        switch (this.currentCycle) {
            case ABSTRACT: {
                codeSnippet.add("public #type# #isOrGet#_#name#();");
                break;
            }
            case STDIMPL: {
                codeSnippet.add("public #type# #isOrGet#_#name#() {", "\treturn _#name#;", "}");
                break;
            }
        }
        return codeSnippet;
    }

    protected void addCheckValidityCode(CodeSnippet codeSnippet) {
        codeSnippet.add("\tif (!isValid())", "\t\tthrow new #jgPackage#.exception.GraphException(\"Cannot access attribute '#name#', because \" + this + \" isn't valid in current transaction.\");");
    }

    protected CodeBlock createSetter(Attribute attribute) {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        codeSnippet.setVariable("name", attribute.getName());
        codeSnippet.setVariable("type", attribute.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
        codeSnippet.setVariable("dname", attribute.getDomain().getSimpleName());
        codeSnippet.setVariable("graphRef", this.aec.getClass() == GraphClassImpl.class ? "" : "graph.");
        switch (this.currentCycle) {
            case ABSTRACT: {
                codeSnippet.add("public void set_#name#(#type# _#name#);");
                break;
            }
            case STDIMPL: {
                codeSnippet.add("public void set_#name#(#type# _#name#) {", "\t#graphRef#fireBeforeChangeAttribute(this, \"#name#\", this._#name#, _#name#);", "\tObject oldValue = this._#name#;", "\tthis._#name# = _#name#;", "\tgraphModified();", "\t#graphRef#fireAfterChangeAttribute(this, \"#name#\", oldValue, _#name#);", "}");
                break;
            }
        }
        return codeSnippet;
    }

    protected CodeBlock createField(Attribute attribute) {
        CodeSnippet codeSnippet = new CodeSnippet(true, "protected #type# _#name#;");
        codeSnippet.setVariable("name", attribute.getName());
        if (this.currentCycle.isStdImpl()) {
            codeSnippet.setVariable("type", attribute.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
        }
        return codeSnippet;
    }

    protected CodeBlock createReadAttributesFromStringMethod(List<Attribute> list) {
        CodeList codeList = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException", "#jgPackage#.exception.NoSuchAttributeException");
        codeList.addNoIndent(new CodeSnippet(true, "public void readAttributeValueFromString(String attributeName, String value) throws GraphIOException {"));
        if (list != null) {
            for (Attribute attribute : list) {
                CodeList codeList2 = new CodeList();
                codeList2.setVariable("variableName", attribute.getName());
                codeList2.setVariable("setterName", "set_" + attribute.getName());
                codeList2.addNoIndent(new CodeSnippet("if (attributeName.equals(\"#variableName#\")) {", "\tGraphIO io = GraphIO.createStringReader(value, getSchema());"));
                if (this.currentCycle.isStdImpl()) {
                    codeList2.add(attribute.getDomain().getReadMethod(this.schemaRootPackageName, "_" + attribute.getName(), "io"));
                    codeList2.addNoIndent(new CodeSnippet("\t#setterName#(_#variableName#);", "\treturn;", "}"));
                }
                codeList.add(codeList2);
            }
        }
        codeList.add(new CodeSnippet("throw new NoSuchAttributeException(\"#qualifiedClassName# doesn't contain an attribute \" + attributeName);"));
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    protected CodeBlock createWriteAttributeToStringMethod(List<Attribute> list) {
        CodeList codeList = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException", "#jgPackage#.exception.NoSuchAttributeException");
        codeList.addNoIndent(new CodeSnippet(true, "public String writeAttributeValueToString(String attributeName) throws IOException, GraphIOException {"));
        if (list != null) {
            for (Attribute attribute : list) {
                CodeList codeList2 = new CodeList();
                codeList2.setVariable("variableName", attribute.getName());
                codeList2.setVariable("setterName", "set_" + attribute.getName());
                codeList2.addNoIndent(new CodeSnippet("if (attributeName.equals(\"#variableName#\")) {", "\tGraphIO io = GraphIO.createStringWriter(getSchema());"));
                if (this.currentCycle.isStdImpl()) {
                    codeList2.add(attribute.getDomain().getWriteMethod(this.schemaRootPackageName, "_" + attribute.getName(), "io"));
                }
                codeList2.addNoIndent(new CodeSnippet("\treturn io.getStringWriterResult();", "}"));
                codeList.add(codeList2);
            }
        }
        codeList.add(new CodeSnippet("throw new NoSuchAttributeException(\"#qualifiedClassName# doesn't contain an attribute \" + attributeName);"));
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    protected CodeBlock createReadAttributesMethod(List<Attribute> list) {
        CodeList codeList = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException");
        codeList.addNoIndent(new CodeSnippet(true, "public void readAttributeValues(GraphIO io) throws GraphIOException {"));
        if (list != null) {
            for (Attribute attribute : list) {
                CodeSnippet codeSnippet = new CodeSnippet();
                codeSnippet.setVariable("setterName", "set_" + attribute.getName());
                codeSnippet.setVariable("variableName", attribute.getName());
                if (this.currentCycle.isStdImpl()) {
                    codeList.add(attribute.getDomain().getReadMethod(this.schemaRootPackageName, "_" + attribute.getName(), "io"));
                }
                codeSnippet.add("#setterName#(_#variableName#);");
                codeList.add(codeSnippet);
            }
        }
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    protected CodeBlock createWriteAttributesMethod(List<Attribute> list) {
        CodeList codeList = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException", "java.io.IOException");
        codeList.addNoIndent(new CodeSnippet(true, "public void writeAttributeValues(GraphIO io) throws GraphIOException, IOException {"));
        if (list != null && !list.isEmpty()) {
            codeList.add(new CodeSnippet("io.space();"));
            for (Attribute attribute : list) {
                if (!this.currentCycle.isStdImpl()) continue;
                codeList.add(attribute.getDomain().getWriteMethod(this.schemaRootPackageName, "_" + attribute.getName(), "io"));
            }
        }
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }
}

