/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl.parser;

import de.uni_koblenz.jgralab.gretl.CreateSubgraph;
import de.uni_koblenz.jgralab.gretl.MatchReplace;
import de.uni_koblenz.jgralab.gretl.parser.Token;
import de.uni_koblenz.jgralab.gretl.parser.TokenTypes;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GReTLLexer {
    private String transformText = null;
    private int position = 0;
    private List<Token> tokens = null;
    private static Set<String> transformsWithCustomDSL = new HashSet<String>();
    protected static Map<TokenTypes, String> fixedTokens;
    private static final String[] semanticExpSeparators;

    private GReTLLexer(String string) {
        this.transformText = string;
        this.position = 0;
        this.tokens = new ArrayList<Token>();
        if (this.transformText == null) {
            throw new NullPointerException("Cannot parse nullpointer as GReTL transformation.");
        }
    }

    private static final boolean isSeparator(int n) {
        return n == 59 || n == 40 || n == 41 || n == 123 || n == 125 || n == 58 || n == 44 || Character.isWhitespace(n) || n == 45;
    }

    private static final boolean isStringQuote(int n) {
        return n == 34 || n == 39;
    }

    private Token nextIdentifier() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.position;
        while (!GReTLLexer.isSeparator(this.transformText.charAt(this.position))) {
            stringBuilder.append(this.transformText.charAt(this.position++));
            this.checkPosition("reading identifier");
        }
        String string = stringBuilder.toString();
        return new Token(TokenTypes.IDENT, string, n, this.position);
    }

    private int skipString() {
        char c = this.transformText.charAt(this.position);
        if (!GReTLLexer.isStringQuote(c)) {
            throw new RuntimeException();
        }
        int n = this.position;
        do {
            ++this.position;
            if (this.transformText.charAt(this.position - 2) != '\\' && this.transformText.charAt(this.position - 1) == '\\') {
                ++this.position;
            }
            this.checkPosition("skipping string");
        } while (this.transformText.charAt(this.position) != c);
        if (this.transformText.charAt(this.position) != c) {
            throw new RuntimeException();
        }
        ++this.position;
        this.checkPosition("skipping string");
        return n;
    }

    private void checkPosition(String string) {
        if (this.position >= this.transformText.length()) {
            throw new RuntimeException("EOF while " + string + " (position " + this.position + ")");
        }
    }

    private final boolean skipWhitespacesAndComments() {
        boolean bl = false;
        boolean bl2 = false;
        do {
            bl = false;
            while (this.position < this.transformText.length() && Character.isWhitespace(this.transformText.charAt(this.position))) {
                ++this.position;
                bl = true;
                bl2 = true;
            }
            if (this.position == this.transformText.length()) {
                return bl2;
            }
            if (!this.transformText.substring(this.position, this.position + 2).equals("//")) continue;
            bl = true;
            this.position += 2;
            while (this.transformText.charAt(this.position) != '\n') {
                ++this.position;
            }
            ++this.position;
            bl2 = true;
        } while (bl);
        return bl2;
    }

    public static List<Token> scan(String string) {
        GReTLLexer gReTLLexer = new GReTLLexer(string);
        List<Token> list = gReTLLexer.scan();
        return list;
    }

    public List<Token> scan() {
        boolean bl = false;
        boolean bl2 = false;
        block0: do {
            Object object;
            int n;
            this.skipWhitespacesAndComments();
            if (this.position == this.transformText.length()) {
                this.tokens.add(new Token(TokenTypes.EOF, "", this.position, this.position));
                continue;
            }
            if (bl) {
                n = this.skipToSemicolonOrArrow();
                bl = false;
                object = new Token(TokenTypes.GREQL, this.transformText.substring(n, this.position).trim(), n, this.position);
                this.tokens.add((Token)object);
                continue;
            }
            if (bl2) {
                n = this.skipToArrow();
                bl2 = false;
                object = new Token(TokenTypes.DOMAIN_SPECIFIC, this.transformText.substring(n, this.position).trim(), n, this.position);
                this.tokens.add((Token)object);
                continue;
            }
            if (GReTLLexer.isStringQuote(this.transformText.charAt(this.position))) {
                n = this.skipString();
                object = new Token(TokenTypes.STRING, this.transformText.substring(n + 1, this.position - 1), n, this.position);
                this.tokens.add((Token)object);
                continue;
            }
            n = this.position;
            for (Map.Entry entry : fixedTokens.entrySet()) {
                if (!this.transformText.regionMatches(n, (String)entry.getValue(), 0, ((String)entry.getValue()).length())) continue;
                char c = this.transformText.charAt(this.position + ((String)entry.getValue()).length());
                if (((String)entry.getValue()).matches("\\p{Alnum}+") && !GReTLLexer.isSeparator(c)) continue;
                this.position = n + ((String)entry.getValue()).length();
                Token token = new Token((TokenTypes)((Object)entry.getKey()), (String)entry.getValue(), n, this.position);
                this.tokens.add(token);
                if (entry.getKey() != TokenTypes.TRANSFORM_ARROW && entry.getKey() != TokenTypes.DEFINES) continue block0;
                bl = true;
                continue block0;
            }
            object = this.nextIdentifier();
            this.tokens.add((Token)object);
            if (!transformsWithCustomDSL.contains(((Token)object).value)) continue;
            bl2 = true;
        } while (this.position < this.transformText.length());
        return this.tokens;
    }

    private int skipToArrow() {
        int n = this.position;
        while (!this.transformText.regionMatches(this.position, fixedTokens.get((Object)TokenTypes.TRANSFORM_ARROW), 0, 3)) {
            ++this.position;
        }
        return n;
    }

    private int skipToSemicolonOrArrow() {
        this.skipWhitespacesAndComments();
        int n = this.position;
        char c = this.transformText.charAt(this.position);
        while (c != ';' && !this.transformText.substring(this.position, this.position + 3).equals(fixedTokens.get((Object)TokenTypes.TRANSFORM_ARROW))) {
            if (!this.skipWhitespacesAndComments()) {
                ++this.position;
            }
            c = this.transformText.charAt(this.position);
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(new File("/home/horn/Repos/uni/jgralab/testit/de/uni_koblenz/jgralabtest/gretl/transforms/AddressBookRefactoring.gretl")));
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        bufferedReader.close();
        List<Token> list = GReTLLexer.scan("makeAddressBook ::= CreateVertexClass AddressBook <== set(1);\nCall makeAddressBook;\n");
        for (Token token : list) {
            System.out.println(token);
        }
    }

    static {
        transformsWithCustomDSL.add(CreateSubgraph.class.getSimpleName());
        transformsWithCustomDSL.add(MatchReplace.class.getSimpleName());
        fixedTokens = new LinkedHashMap<TokenTypes, String>();
        fixedTokens.put(TokenTypes.TRANSFORMATION, "transformation");
        fixedTokens.put(TokenTypes.AGGREGATION, "aggregation");
        fixedTokens.put(TokenTypes.FROM, "from");
        fixedTokens.put(TokenTypes.ROLE, "role");
        fixedTokens.put(TokenTypes.TO, "to");
        fixedTokens.put(TokenTypes.TRANSFORM_ARROW, "<==");
        fixedTokens.put(TokenTypes.DEFINES, ":=");
        fixedTokens.put(TokenTypes.DEFINES_TRANSFORMATION, "::=");
        fixedTokens.put(TokenTypes.PAREN_OPEN, "(");
        fixedTokens.put(TokenTypes.PAREN_CLOSE, ")");
        fixedTokens.put(TokenTypes.COLON, ":");
        fixedTokens.put(TokenTypes.ASSIGN, "=");
        fixedTokens.put(TokenTypes.SEMICOLON, ";");
        fixedTokens.put(TokenTypes.COMMA, ",");
        fixedTokens.put(TokenTypes.GREQL_IMPORT, "import");
        semanticExpSeparators = new String[]{fixedTokens.get((Object)TokenTypes.DEFINES), fixedTokens.get((Object)TokenTypes.TRANSFORM_ARROW)};
        Arrays.sort(semanticExpSeparators, new StringLengthComparator());
    }

    private static final class StringLengthComparator
    implements Comparator<String> {
        private StringLengthComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            int n;
            int n2 = string.length();
            int n3 = n2 - (n = string.length());
            if (n3 != 0) {
                return n3;
            }
            return string.compareTo(string2);
        }
    }
}

