/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CountingTransformation;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.parser.TokenTypes;
import de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizOutputFormat;
import java.io.File;
import java.io.IOException;

public class PrintGraph
extends CountingTransformation {
    private File file;
    private Graph graph;

    protected PrintGraph(Context context, Graph graph, File file) {
        super(context);
        this.file = file;
        this.graph = graph;
    }

    public static PrintGraph parseAndCreate(ExecuteTransformation executeTransformation) {
        String string = "default";
        if (executeTransformation.tryMatchGraphAlias()) {
            string = executeTransformation.matchGraphAlias();
        }
        Graph graph = null;
        graph = string.equals("target") ? executeTransformation.context.getTargetGraph() : executeTransformation.context.getSourceGraph(string);
        File file = new File(executeTransformation.match((TokenTypes)TokenTypes.STRING).value);
        return new PrintGraph(executeTransformation.context, graph, file);
    }

    @Override
    protected Integer transform() {
        try {
            Tg2Dot.convertGraph(this.graph, this.file.getAbsolutePath(), GraphVizOutputFormat.PDF);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return 0;
    }
}

