/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import org.pcollections.Empty;
import org.pcollections.PSet;

public class CreateEdges
extends Transformation<PSet<? extends Edge>> {
    private PSet<Tuple> archetypes = null;
    private String semanticExpression = null;
    private EdgeClass edgeClass = null;

    public CreateEdges(Context context, EdgeClass edgeClass, String string) {
        super(context);
        this.semanticExpression = string;
        this.edgeClass = edgeClass;
    }

    public CreateEdges(Context context, EdgeClass edgeClass, PSet<Tuple> pSet) {
        super(context);
        this.archetypes = pSet;
        this.edgeClass = edgeClass;
    }

    public static CreateEdges parseAndCreate(ExecuteTransformation executeTransformation) {
        EdgeClass edgeClass = executeTransformation.matchEdgeClass();
        executeTransformation.matchTransformationArrow();
        String string = executeTransformation.matchSemanticExpression();
        return new CreateEdges(executeTransformation.context, edgeClass, string);
    }

    @Override
    protected PSet<? extends Edge> transform() {
        if (this.context.phase != Context.TransformationPhase.GRAPH) {
            return null;
        }
        if (this.archetypes == null) {
            this.archetypes = (PSet)this.context.evaluateGReQLQuery(this.semanticExpression);
        }
        PSet pSet = Empty.set();
        for (Tuple tuple : this.archetypes) {
            Object object = tuple.get(0);
            Object object2 = tuple.get(1);
            VertexClass vertexClass = this.edgeClass.getFrom().getVertexClass();
            Vertex vertex = (Vertex)this.context.getImg(vertexClass).get(object2);
            if (vertex == null) {
                this.context.printImgMappings();
                throw new GReTLException(this.context, "No startVertex for a new '" + this.edgeClass.getQualifiedName() + "' instance! Couldn't fetch image of '" + object2 + "' in " + Context.toGReTLVarNotation(vertexClass.getQualifiedName(), Context.GReTLVariableType.IMG) + ".");
            }
            Object object3 = tuple.get(2);
            VertexClass vertexClass2 = this.edgeClass.getTo().getVertexClass();
            Vertex vertex2 = (Vertex)this.context.getImg(vertexClass2).get(object3);
            if (vertex2 == null) {
                this.context.printImgMappings();
                throw new GReTLException(this.context, "No endVertex for a new '" + this.edgeClass.getQualifiedName() + "' instance! Couldn't fetch image of '" + object3 + "' in " + Context.toGReTLVarNotation(vertexClass2.getQualifiedName(), Context.GReTLVariableType.IMG) + ".");
            }
            Object t = this.context.targetGraph.createEdge(this.edgeClass, vertex, vertex2);
            pSet = pSet.plus(t);
            this.context.addMapping(this.edgeClass, object, (AttributedElement<?, ?>)t);
        }
        return pSet;
    }
}

