/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.greql.types.Tuple;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CreateEdges;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.IncidenceClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import org.pcollections.PSet;

public class CreateEdgeClass
extends Transformation<EdgeClass> {
    protected String qualifiedName;
    private IncidenceClassSpec from;
    private IncidenceClassSpec to;
    private PSet<Tuple> archetypes;
    private String semanticExpression;

    protected CreateEdgeClass(Context context, String string, IncidenceClassSpec incidenceClassSpec, IncidenceClassSpec incidenceClassSpec2) {
        super(context);
        this.qualifiedName = string;
        this.from = incidenceClassSpec;
        this.to = incidenceClassSpec2;
    }

    public CreateEdgeClass(Context context, String string, IncidenceClassSpec incidenceClassSpec, IncidenceClassSpec incidenceClassSpec2, PSet<Tuple> pSet) {
        this(context, string, incidenceClassSpec, incidenceClassSpec2);
        this.archetypes = pSet;
    }

    public CreateEdgeClass(Context context, String string, IncidenceClassSpec incidenceClassSpec, IncidenceClassSpec incidenceClassSpec2, String string2) {
        this(context, string, incidenceClassSpec, incidenceClassSpec2);
        this.semanticExpression = string2;
    }

    public static CreateEdgeClass parseAndCreate(ExecuteTransformation executeTransformation) {
        String string = executeTransformation.matchQualifiedName();
        IncidenceClassSpec incidenceClassSpec = executeTransformation.matchIncidenceClassSpec();
        IncidenceClassSpec incidenceClassSpec2 = executeTransformation.matchIncidenceClassSpec();
        executeTransformation.matchTransformationArrow();
        String string2 = executeTransformation.matchSemanticExpression();
        return new CreateEdgeClass(executeTransformation.context, string, incidenceClassSpec, incidenceClassSpec2, string2);
    }

    @Override
    protected EdgeClass transform() {
        switch (this.context.phase) {
            case SCHEMA: {
                if (this.from.aggregationKind != AggregationKind.NONE && this.to.aggregationKind != AggregationKind.NONE) {
                    throw new GReTLException(this.context, "Only one IncidenceClass of " + this.qualifiedName + " map be SHARED or COMPOSITE.");
                }
                this.setDefaultMultiplicities(this.from, this.to);
                this.setDefaultMultiplicities(this.to, this.from);
                EdgeClass edgeClass = this.context.targetSchema.getGraphClass().createEdgeClass(this.qualifiedName, this.from.connectedVertexClass, this.from.minMultiplicity, this.from.maxMultiplicity, this.from.roleName, this.from.aggregationKind, this.to.connectedVertexClass, this.to.minMultiplicity, this.to.maxMultiplicity, this.to.roleName, this.to.aggregationKind);
                this.context.ensureMappings(edgeClass);
                return edgeClass;
            }
            case GRAPH: {
                EdgeClass edgeClass = this.context.targetGraph.getGraphClass().getEdgeClass(this.qualifiedName);
                if (this.archetypes != null) {
                    new CreateEdges(this.context, edgeClass, this.archetypes).execute();
                } else {
                    new CreateEdges(this.context, edgeClass, this.semanticExpression).execute();
                }
                return edgeClass;
            }
        }
        throw new GReTLException(this.context, "Unknown TransformationPhase " + (Object)((Object)this.context.phase) + "!");
    }

    private void setDefaultMultiplicities(IncidenceClassSpec incidenceClassSpec, IncidenceClassSpec incidenceClassSpec2) {
        if (incidenceClassSpec.defaultMultis) {
            if (incidenceClassSpec2.aggregationKind == AggregationKind.COMPOSITE) {
                incidenceClassSpec.minMultiplicity = 1;
                incidenceClassSpec.maxMultiplicity = 1;
            } else {
                incidenceClassSpec.minMultiplicity = 0;
                incidenceClassSpec.maxMultiplicity = Integer.MAX_VALUE;
            }
        }
        incidenceClassSpec.defaultMultis = false;
    }

    public static final class IncidenceClassSpec {
        private boolean defaultMultis = false;
        protected VertexClass connectedVertexClass = null;
        protected int minMultiplicity = 0;
        protected int maxMultiplicity = Integer.MAX_VALUE;
        protected String roleName = null;
        protected AggregationKind aggregationKind = AggregationKind.NONE;

        public IncidenceClassSpec(VertexClass vertexClass, int n, int n2, String string, AggregationKind aggregationKind) {
            this.connectedVertexClass = vertexClass;
            this.minMultiplicity = n;
            this.maxMultiplicity = n2;
            this.aggregationKind = aggregationKind;
            this.roleName = string;
            if (n == -1 || n2 == -1) {
                this.defaultMultis = true;
            }
        }

        public IncidenceClassSpec(VertexClass vertexClass, int n, int n2, String string) {
            this(vertexClass, n, n2, string, AggregationKind.NONE);
        }

        public IncidenceClassSpec(VertexClass vertexClass, int n, int n2) {
            this(vertexClass, n, n2, "", AggregationKind.NONE);
        }

        public IncidenceClassSpec(VertexClass vertexClass, AggregationKind aggregationKind, String string) {
            this(vertexClass, -1, -1, string, aggregationKind);
        }

        public IncidenceClassSpec(VertexClass vertexClass, AggregationKind aggregationKind) {
            this(vertexClass, aggregationKind, "");
        }

        public IncidenceClassSpec(VertexClass vertexClass, String string) {
            this(vertexClass, -1, -1, string);
        }

        public IncidenceClassSpec(VertexClass vertexClass) {
            this(vertexClass, "");
        }

        public IncidenceClassSpec(VertexClass vertexClass, int n, int n2, AggregationKind aggregationKind) {
            this(vertexClass, n, n2, "", aggregationKind);
        }

        public IncidenceClassSpec(VertexClass vertexClass, IncidenceClass incidenceClass) {
            this(vertexClass, incidenceClass.getMin(), incidenceClass.getMax(), incidenceClass.getRolename(), incidenceClass.getAggregationKind());
        }
    }
}

