/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.types;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.FiniteAutomaton;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.types.Path;
import de.uni_koblenz.jgralab.greql.types.PathSystem;
import de.uni_koblenz.jgralab.greql.types.Table;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import de.uni_koblenz.jgralab.greql.types.Undefined;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.pcollections.ArrayPSet;
import org.pcollections.ArrayPVector;
import org.pcollections.PCollection;
import org.pcollections.PMap;
import org.pcollections.POrderedSet;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class Types {
    private static final Class<?>[] GREQL_TYPES = new Class[]{Integer.class, Long.class, Boolean.class, Double.class, Number.class, String.class, Vertex.class, Edge.class, Graph.class, AttributedElement.class, GraphElement.class, Path.class, PathSystem.class, TypeCollection.class, Enum.class, Record.class, Table.class, Tuple.class, PVector.class, PSet.class, POrderedSet.class, PCollection.class, PMap.class, AttributedElementClass.class, FiniteAutomaton.class, TraversalContext.class, Undefined.class, InternalGreqlEvaluator.class};
    private static final HashMap<Class<?>, String> typeNames = new HashMap();
    private static final HashSet<Class<?>> types = new HashSet();

    private Types() {
    }

    public static final boolean isValidGreqlValue(Object object) {
        if (object == null) {
            return true;
        }
        for (Class<?> clazz : GREQL_TYPES) {
            if (!clazz.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public static String[] getGreqlTypeNames() {
        String[] stringArray = new String[typeNames.size()];
        int n = 0;
        Iterator<String> iterator = typeNames.values().iterator();
        while (iterator.hasNext()) {
            String string;
            stringArray[n] = string = iterator.next();
            ++n;
        }
        return stringArray;
    }

    public static final String getGreqlTypeName(Object object) {
        if (object == null) {
            object = Undefined.UNDEFINED;
        }
        for (Class<?> clazz : GREQL_TYPES) {
            if (!clazz.isInstance(object)) continue;
            return typeNames.get(clazz);
        }
        return object.getClass().getSimpleName() + " [unknown to GReQL]";
    }

    public static final String getGreqlTypeName(Class<?> clazz) {
        String string = typeNames.get(clazz);
        if (string != null) {
            return string;
        }
        return clazz.getSimpleName();
    }

    public static final PVector<?> toPVector(Object object) {
        if (object instanceof ArrayPVector) {
            return (PVector)object;
        }
        if (object instanceof ArrayPSet) {
            return ((ArrayPSet)object).toPVector();
        }
        if (object instanceof Tuple) {
            return ((Tuple)object).toPVector();
        }
        if (object instanceof Collection) {
            return JGraLab.vector().plusAll((Collection)object);
        }
        throw new GreqlException("Can't convert object of type " + object.getClass().getName() + " to org.pcollections.PVector<?>");
    }

    static {
        for (Class<?> clazz : GREQL_TYPES) {
            typeNames.put(clazz, clazz.getSimpleName());
            types.add(clazz);
        }
        typeNames.put(PVector.class, "List");
        typeNames.put(PSet.class, "Set");
        typeNames.put(POrderedSet.class, "Set");
        typeNames.put(PMap.class, "Map");
        typeNames.put(PCollection.class, "Collection");
        typeNames.put(FiniteAutomaton.class, "PathDescription");
    }
}

