/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsGraphArgument;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;

@NeedsGraphArgument
public class EdgeTypeSubgraph
extends Function {
    @Description(params={"graph", "typeCollection"}, description="Returns the subgraph induced by the edge types in typeCollection, i.e. all edges specified by typeCollection together with their alpha and omega vertices.", categories={Function.Category.GRAPH})
    public EdgeTypeSubgraph() {
        super(7L, 1L, 1.0);
    }

    public SubGraphMarker evaluate(Graph graph, TypeCollection typeCollection) {
        SubGraphMarker subGraphMarker = new SubGraphMarker(graph);
        for (Edge edge = graph.getFirstEdge(); edge != null; edge = edge.getNextEdge()) {
            if (!typeCollection.acceptsType(edge.getAttributedElementClass())) continue;
            subGraphMarker.mark(edge);
            subGraphMarker.mark(edge.getAlpha());
            subGraphMarker.mark(edge.getOmega());
        }
        return subGraphMarker;
    }
}

