/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VariableEvaluator;
import de.uni_koblenz.jgralab.greql.exception.QuerySourceException;
import de.uni_koblenz.jgralab.greql.schema.GreqlAggregation;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.SourcePosition;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.pcollections.PVector;

public abstract class VertexEvaluator<V extends GreqlVertex> {
    protected static Logger logger = Logger.getLogger(VertexEvaluator.class.getName());
    private static ArrayList<String> unevaluatedVertices = new ArrayList();
    protected V vertex;
    protected GreqlQueryImpl query;
    protected Set<Variable> neededVariables = null;
    protected Set<Variable> definedVariables = null;
    protected long currentSubtreeEvaluationCosts = Long.MIN_VALUE;
    protected long initialSubtreeEvaluationCosts = Long.MIN_VALUE;
    protected long ownEvaluationCosts = Long.MIN_VALUE;
    protected long iteratedEvaluationCosts = Long.MIN_VALUE;
    protected static final int transitionCosts = 10;
    protected static final int addToListCosts = 5;
    protected static final int addToSetCosts = 10;
    protected long estimatedCardinality = Long.MIN_VALUE;
    protected double estimatedSelectivity = Double.NaN;

    protected VertexEvaluator(V v, GreqlQueryImpl greqlQueryImpl) {
        this.vertex = v;
        this.query = greqlQueryImpl;
    }

    public V getVertex() {
        return this.vertex;
    }

    public String getLoggingName() {
        return this.getVertex().getAttributedElementClass().getSimpleName();
    }

    public Object getResult(InternalGreqlEvaluator internalGreqlEvaluator) {
        Object object = internalGreqlEvaluator.getLocalEvaluationResult((GreqlVertex)this.vertex);
        if (object != null) {
            return object;
        }
        try {
            object = this.evaluate(internalGreqlEvaluator);
            internalGreqlEvaluator.setLocalEvaluationResult((GreqlVertex)this.vertex, object);
        }
        catch (QuerySourceException querySourceException) {
            this.removeInvalidSourcePosition(querySourceException);
            throw querySourceException;
        }
        return object;
    }

    public boolean isEvaluated(InternalGreqlEvaluator internalGreqlEvaluator) {
        return internalGreqlEvaluator.getLocalEvaluationResult((GreqlVertex)this.vertex) != null;
    }

    public abstract Object evaluate(InternalGreqlEvaluator var1);

    public final void clear(InternalGreqlEvaluator internalGreqlEvaluator) {
        internalGreqlEvaluator.removeLocalEvaluationResult((GreqlVertex)this.vertex);
    }

    public void resetToInitialState(InternalGreqlEvaluator internalGreqlEvaluator) {
        if (internalGreqlEvaluator != null) {
            internalGreqlEvaluator.removeLocalEvaluationResult((GreqlVertex)this.vertex);
        }
        this.currentSubtreeEvaluationCosts = Long.MIN_VALUE;
        this.initialSubtreeEvaluationCosts = Long.MIN_VALUE;
        this.ownEvaluationCosts = Long.MIN_VALUE;
        this.iteratedEvaluationCosts = Long.MIN_VALUE;
        this.estimatedCardinality = Long.MIN_VALUE;
        this.estimatedSelectivity = Double.NaN;
    }

    public void resetSubtreeToInitialState(InternalGreqlEvaluator internalGreqlEvaluator) {
        this.resetToInitialState(internalGreqlEvaluator);
        for (Edge edge : this.getVertex().incidences(EdgeDirection.IN)) {
            GreqlVertex greqlVertex = (GreqlVertex)edge.getThat();
            VertexEvaluator<GreqlVertex> vertexEvaluator = this.query.getVertexEvaluator(greqlVertex);
            if (vertexEvaluator == null) continue;
            vertexEvaluator.resetSubtreeToInitialState(internalGreqlEvaluator);
        }
    }

    protected abstract VertexCosts calculateSubtreeEvaluationCosts();

    public long getCurrentSubtreeEvaluationCosts() {
        if (this.currentSubtreeEvaluationCosts == Long.MIN_VALUE) {
            return this.getInitialSubtreeEvaluationCosts();
        }
        return 1L;
    }

    public long getInitialSubtreeEvaluationCosts() {
        if (this.initialSubtreeEvaluationCosts > 0L) {
            return this.initialSubtreeEvaluationCosts;
        }
        VertexCosts vertexCosts = this.calculateSubtreeEvaluationCosts();
        this.ownEvaluationCosts = vertexCosts.ownEvaluationCosts;
        this.iteratedEvaluationCosts = vertexCosts.iteratedEvaluationCosts;
        this.currentSubtreeEvaluationCosts = vertexCosts.subtreeEvaluationCosts;
        this.initialSubtreeEvaluationCosts = vertexCosts.subtreeEvaluationCosts;
        return this.initialSubtreeEvaluationCosts;
    }

    public long getOwnEvaluationCosts() {
        if (this.ownEvaluationCosts == Long.MIN_VALUE) {
            this.getInitialSubtreeEvaluationCosts();
        }
        return this.ownEvaluationCosts;
    }

    public void calculateNeededAndDefinedVariables() {
        VertexEvaluator<GreqlVertex> vertexEvaluator;
        this.neededVariables = new HashSet<Variable>();
        this.definedVariables = new HashSet<Variable>();
        for (Edge edge = this.getVertex().getFirstIncidence(EdgeDirection.IN); edge != null; edge = edge.getNextIncidence(EdgeDirection.IN)) {
            vertexEvaluator = this.query.getVertexEvaluator((GreqlVertex)edge.getAlpha());
            if (vertexEvaluator == null) continue;
            this.neededVariables.addAll(vertexEvaluator.getNeededVariables());
            this.definedVariables.addAll(vertexEvaluator.getDefinedVariables());
        }
        vertexEvaluator = new HashSet<Variable>();
        ((AbstractCollection)((Object)vertexEvaluator)).addAll(this.neededVariables);
        this.neededVariables.removeAll(this.definedVariables);
        this.definedVariables.removeAll((Collection<?>)((Object)vertexEvaluator));
    }

    public Set<Variable> getNeededVariables() {
        if (this.neededVariables == null) {
            this.calculateNeededAndDefinedVariables();
        }
        return this.neededVariables;
    }

    public Set<Variable> getDefinedVariables() {
        if (this.definedVariables == null) {
            this.calculateNeededAndDefinedVariables();
        }
        return this.definedVariables;
    }

    public long getVariableCombinations() {
        int n = 1;
        Iterator<Variable> iterator = this.getNeededVariables().iterator();
        while (iterator.hasNext()) {
            VariableEvaluator variableEvaluator = (VariableEvaluator)this.query.getVertexEvaluator((GreqlVertex)iterator.next());
            n = (int)((long)n * variableEvaluator.getVariableCombinations());
        }
        return n;
    }

    public long getEstimatedCardinality() {
        if (this.estimatedCardinality == Long.MIN_VALUE) {
            this.estimatedCardinality = this.calculateEstimatedCardinality();
        }
        return this.estimatedCardinality;
    }

    public long calculateEstimatedCardinality() {
        return 1L;
    }

    public double getEstimatedSelectivity() {
        if (Double.isNaN(this.estimatedSelectivity)) {
            this.estimatedSelectivity = this.calculateEstimatedSelectivity();
        }
        return this.estimatedSelectivity;
    }

    public double calculateEstimatedSelectivity() {
        return 1.0;
    }

    public List<SourcePosition> createPossibleSourcePositions() {
        ArrayList<SourcePosition> arrayList = new ArrayList<SourcePosition>();
        for (GreqlAggregation greqlAggregation = (GreqlAggregation)this.getVertex().getFirstIncidence(EdgeDirection.OUT); greqlAggregation != null; greqlAggregation = greqlAggregation.getNextGreqlAggregationIncidence(EdgeDirection.OUT)) {
            PVector<SourcePosition> pVector = greqlAggregation.get_sourcePositions();
            arrayList.addAll(pVector);
        }
        return arrayList;
    }

    protected List<SourcePosition> createSourcePositions(GreqlAggregation greqlAggregation) {
        ArrayList<SourcePosition> arrayList = new ArrayList<SourcePosition>();
        PVector<SourcePosition> pVector = greqlAggregation.get_sourcePositions();
        arrayList.addAll(pVector);
        return arrayList;
    }

    private void removeInvalidSourcePosition(QuerySourceException querySourceException) {
        Object object;
        ArrayList<SourcePosition> arrayList = new ArrayList<SourcePosition>();
        for (GreqlAggregation greqlAggregation = (GreqlAggregation)this.getVertex().getFirstIncidence(EdgeDirection.OUT); greqlAggregation != null; greqlAggregation = greqlAggregation.getNextGreqlAggregationIncidence(EdgeDirection.OUT)) {
            object = greqlAggregation.get_sourcePositions();
            arrayList.addAll((Collection<SourcePosition>)object);
        }
        if (arrayList.size() == 0) {
            return;
        }
        object = querySourceException.getSourcePositions().iterator();
        while (object.hasNext()) {
            boolean bl = false;
            SourcePosition sourcePosition = (SourcePosition)object.next();
            for (SourcePosition sourcePosition2 : arrayList) {
                if (sourcePosition2.get_offset() > sourcePosition.get_offset() || sourcePosition2.get_offset() + sourcePosition2.get_length() < sourcePosition.get_offset() + sourcePosition.get_length()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            object.remove();
        }
    }

    public static <V extends GreqlVertex> VertexEvaluator<V> createVertexEvaluator(V v, GreqlQueryImpl greqlQueryImpl) {
        Class<?> clazz = v.getClass();
        String string = clazz.getName();
        string = string.substring(0, string.length() - 4);
        String string2 = (string = string.replaceFirst(".impl.std.", ".")).substring(string.lastIndexOf(".") + 1);
        if (unevaluatedVertices.contains(string2)) {
            return null;
        }
        String string3 = string2 + "Evaluator";
        string3 = string3.substring(string2.lastIndexOf(".") + 1);
        string3 = VertexEvaluator.class.getPackage().getName() + "." + string3;
        try {
            Class[] classArray = new Class[]{Class.forName(string), GreqlQueryImpl.class};
            Class<?> clazz2 = Class.forName(string3);
            Constructor<?> constructor = clazz2.getConstructor(classArray);
            VertexEvaluator vertexEvaluator = (VertexEvaluator)constructor.newInstance(v, greqlQueryImpl);
            return vertexEvaluator;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(string2, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(string2, noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(string2, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(string2, instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(string2, invocationTargetException);
        }
    }

    static {
        unevaluatedVertices.add("Quantifier");
        unevaluatedVertices.add("RoleId");
        unevaluatedVertices.add("FunctionId");
        unevaluatedVertices.add("RecordId");
        unevaluatedVertices.add("Direction");
    }
}

