/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator;

import de.uni_koblenz.jgralab.greql.evaluator.GreqlEvaluatorImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VariableDeclaration;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.WrongResultTypeException;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import java.util.List;

public class VariableDeclarationLayer {
    private final List<VariableDeclaration> variableDeclarations;
    private final List<VertexEvaluator<? extends Expression>> constraintList;
    private boolean firstIteration = true;
    private Declaration declaration = null;

    public VariableDeclarationLayer(Declaration declaration, List<VariableDeclaration> list, List<VertexEvaluator<? extends Expression>> list2) {
        this.declaration = declaration;
        this.variableDeclarations = list;
        this.constraintList = list2;
    }

    public boolean iterate(InternalGreqlEvaluator internalGreqlEvaluator) {
        StringBuilder stringBuilder = null;
        if (GreqlEvaluatorImpl.DEBUG_DECLARATION_ITERATIONS) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("### New Declaration Layer Iteration (");
            stringBuilder.append(this.declaration);
            stringBuilder.append(")\n");
        }
        boolean bl = false;
        if (this.firstIteration) {
            if (!this.getFirstCombination(internalGreqlEvaluator)) {
                if (GreqlEvaluatorImpl.DEBUG_DECLARATION_ITERATIONS) {
                    stringBuilder.append("## 1st. iteration: returning false (");
                    stringBuilder.append(this.declaration);
                    stringBuilder.append(")");
                    System.out.println(stringBuilder.toString());
                }
                return false;
            }
            bl = this.fullfillsConstraints(internalGreqlEvaluator);
            this.firstIteration = false;
        }
        while (!bl) {
            if (!this.getNextCombination(false, internalGreqlEvaluator)) {
                if (GreqlEvaluatorImpl.DEBUG_DECLARATION_ITERATIONS) {
                    stringBuilder.append("## nth iteration: returning false (");
                    stringBuilder.append(this.declaration);
                    stringBuilder.append(")");
                    System.out.println(stringBuilder.toString());
                }
                return false;
            }
            bl = this.fullfillsConstraints(internalGreqlEvaluator);
        }
        if (GreqlEvaluatorImpl.DEBUG_DECLARATION_ITERATIONS) {
            boolean bl2 = true;
            for (VariableDeclaration variableDeclaration : this.variableDeclarations) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(variableDeclaration);
            }
            stringBuilder.append(" (");
            stringBuilder.append(this.declaration);
            stringBuilder.append(")");
            System.out.println(stringBuilder.toString());
        }
        return true;
    }

    private boolean getFirstCombination(InternalGreqlEvaluator internalGreqlEvaluator) {
        this.variableDeclarations.get(0).reset(internalGreqlEvaluator);
        return this.getNextCombination(true, internalGreqlEvaluator);
    }

    private boolean getNextCombination(boolean bl, InternalGreqlEvaluator internalGreqlEvaluator) {
        boolean bl2;
        int n = bl ? 0 : this.variableDeclarations.size() - 1;
        block0: do {
            bl2 = false;
            VariableDeclaration variableDeclaration = null;
            do {
                if (n >= 0) continue;
                return false;
            } while (!(variableDeclaration = this.variableDeclarations.get(n--)).iterate(internalGreqlEvaluator));
            n += 2;
            int n2 = this.variableDeclarations.size();
            while (n < n2) {
                variableDeclaration = this.variableDeclarations.get(n++);
                variableDeclaration.reset(internalGreqlEvaluator);
                if (variableDeclaration.iterate(internalGreqlEvaluator)) continue;
                n -= 2;
                bl2 = true;
                continue block0;
            }
        } while (bl2);
        return true;
    }

    private boolean fullfillsConstraints(InternalGreqlEvaluator internalGreqlEvaluator) {
        if (this.constraintList == null || this.constraintList.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.constraintList.size(); ++i) {
            VertexEvaluator<? extends Expression> vertexEvaluator = this.constraintList.get(i);
            Object object = vertexEvaluator.getResult(internalGreqlEvaluator);
            if (object instanceof Boolean) {
                if ((Boolean)object == Boolean.TRUE) continue;
                return false;
            }
            throw new WrongResultTypeException(vertexEvaluator.getVertex(), "Boolean", object.getClass().getSimpleName(), vertexEvaluator.createPossibleSourcePositions());
        }
        return true;
    }

    public void reset() {
        this.firstIteration = true;
    }
}

