/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.search;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.search.DepthFirstSearch;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.graphmarker.ArrayVertexMarker;
import java.util.Iterator;
import java.util.Stack;

public class IterativeDepthFirstSearch
extends DepthFirstSearch {
    private ArrayVertexMarker<Iterator<Edge>> remainingIncidences;
    private Stack<Vertex> incompleteVertices;

    public IterativeDepthFirstSearch(Graph graph, BooleanFunction<Edge> booleanFunction) {
        super(graph, booleanFunction);
    }

    public IterativeDepthFirstSearch(Graph graph) {
        this(graph, null);
    }

    @Override
    public void reset() {
        super.reset();
        this.parent = new ArrayVertexMarker(this.graph);
        this.remainingIncidences = new ArrayVertexMarker(this.graph);
        this.incompleteVertices = new Stack();
    }

    @Override
    public void disableOptionalResults() {
        this.checkStateForSettingParameters();
        this.level = null;
        this.rorder = null;
    }

    @Override
    public DepthFirstSearch withoutParent() {
        this.checkStateForSettingParameters();
        throw new UnsupportedOperationException("The result \"parent\" is mandatory for iterative DFS and cannot be deactivated.");
    }

    @Override
    public IterativeDepthFirstSearch execute(Vertex vertex) throws AlgorithmTerminatedException {
        TraversalContext traversalContext = this.graph.getTraversalContext();
        if (traversalContext != null && !traversalContext.containsVertex(vertex) || this.visitedVertices.get(vertex)) {
            return this;
        }
        this.startRunning();
        if (this.level != null) {
            this.level.set(vertex, 0);
        }
        this.number.set(vertex, this.num);
        this.visitors.visitRoot(vertex);
        this.incompleteVertices.push(vertex);
        while (!this.incompleteVertices.isEmpty()) {
            Iterator iterator;
            Vertex vertex2 = this.incompleteVertices.peek();
            if (!this.visitedVertices.get(vertex2)) {
                this.vertexOrder[this.num] = vertex2;
                this.number.set(vertex2, this.num);
                this.remainingIncidences.mark(vertex2, vertex2.incidences(this.traversalDirection).iterator());
                this.visitors.visitVertex(vertex2);
                this.visitedVertices.set(vertex2, true);
                ++this.num;
            }
            if ((iterator = (Iterator)this.remainingIncidences.getMark(vertex2)).hasNext()) {
                this.cancelIfInterrupted();
                Edge edge = (Edge)iterator.next();
                if (this.visitedEdges.get(edge) || this.navigable != null && !this.navigable.get(edge)) continue;
                Vertex vertex3 = edge.getThat();
                this.edgeOrder[this.eNum] = edge;
                if (this.enumber != null) {
                    this.enumber.set(edge, this.eNum);
                }
                this.visitors.visitEdge(edge);
                this.visitedEdges.set(edge, true);
                ++this.eNum;
                if (this.visitedVertices.get(vertex3)) {
                    this.visitors.visitFrond(edge);
                    if (!this.rnumber.isDefined(vertex3)) {
                        this.visitors.visitBackwardArc(edge);
                        continue;
                    }
                    if (this.number.get(vertex3) > this.number.get(vertex2)) {
                        this.visitors.visitForwardArc(edge);
                        continue;
                    }
                    this.visitors.visitCrosslink(edge);
                    continue;
                }
                if (this.level != null) {
                    this.level.set(vertex3, this.level.get(vertex2) + 1);
                }
                this.parent.set(edge.getThat(), edge);
                this.visitors.visitTreeEdge(edge);
                this.incompleteVertices.push(vertex3);
                continue;
            }
            this.incompleteVertices.pop();
            this.rnumber.set(vertex2, this.rNum);
            if (this.rorder != null) {
                this.rorder[this.rNum] = vertex2;
            }
            this.visitors.leaveVertex(vertex2);
            ++this.rNum;
            this.remainingIncidences.removeMark(vertex2);
            if (vertex2 == vertex) continue;
            this.visitors.leaveTreeEdge((Edge)this.parent.get(vertex2));
        }
        this.done();
        return this;
    }

    @Override
    public IterativeDepthFirstSearch execute() throws AlgorithmTerminatedException {
        super.execute();
        return this;
    }
}

