/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.reachability;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmStates;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.StructureOrientedAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.search.SearchAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.SearchVisitor;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.SearchVisitorAdapter;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.problems.ReachableSolver;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;

public class ReachableWithSearch
extends StructureOrientedAlgorithm
implements ReachableSolver {
    private SearchAlgorithm search;
    private SearchVisitor reachableVisitor;
    private boolean reachable;
    private Vertex target;

    public ReachableWithSearch(Graph graph, SearchAlgorithm searchAlgorithm, BooleanFunction<Edge> booleanFunction) {
        super(graph, booleanFunction);
        this.search = searchAlgorithm;
    }

    public ReachableWithSearch(Graph graph, SearchAlgorithm searchAlgorithm) {
        this(graph, searchAlgorithm, null);
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        this.search.addVisitor(visitor);
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        this.search.removeVisitor(visitor);
    }

    @Override
    public void disableOptionalResults() {
    }

    @Override
    protected void done() {
        this.state = this.search.getState() == AlgorithmStates.STOPPED ? AlgorithmStates.FINISHED : this.search.getState();
    }

    @Override
    public ReachableWithSearch normal() {
        super.normal();
        return this;
    }

    @Override
    public ReachableWithSearch reversed() {
        super.reversed();
        return this;
    }

    @Override
    public ReachableWithSearch undirected() {
        super.undirected();
        return this;
    }

    @Override
    public boolean isDirected() {
        return super.isDirected();
    }

    @Override
    public boolean isHybrid() {
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.target = null;
        this.reachable = false;
    }

    @Override
    public void resetParameters() {
        this.traversalDirection = EdgeDirection.OUT;
        this.reachableVisitor = new SearchVisitorAdapter(){

            @Override
            public void visitVertex(Vertex vertex) throws AlgorithmTerminatedException {
                if (vertex == ReachableWithSearch.this.target) {
                    ReachableWithSearch.this.reachable = true;
                    ReachableWithSearch.this.search.terminate();
                }
            }
        };
    }

    @Override
    public ReachableWithSearch execute(Vertex vertex, Vertex vertex2) throws AlgorithmTerminatedException {
        this.search.reset();
        this.search.setGraph(this.graph);
        this.search.setNavigable(this.navigable);
        this.search.setTraversalDirection(this.traversalDirection);
        this.search.addVisitor(this.reachableVisitor);
        this.startRunning();
        this.target = vertex2;
        try {
            this.search.execute(vertex);
        }
        catch (AlgorithmTerminatedException algorithmTerminatedException) {
            // empty catch block
        }
        this.done();
        this.search.removeVisitor(this.reachableVisitor);
        return this;
    }

    @Override
    public boolean isReachable() {
        this.checkStateForResult();
        return this.reachable;
    }

    public boolean getInternalReachable() {
        return this.reachable;
    }
}

