/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmStates;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.problems.ProblemSolver;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;

public abstract class GraphAlgorithm
implements ProblemSolver {
    protected Graph graph;
    protected AlgorithmStates state;

    public GraphAlgorithm(Graph graph) {
        this.graph = graph;
        this.state = AlgorithmStates.INITIALIZED;
        this.resetParameters();
        this.reset();
    }

    public synchronized AlgorithmStates getState() {
        return this.state;
    }

    @Override
    public void setGraph(Graph graph) {
        this.checkStateForSettingParameters();
        this.graph = graph;
        this.reset();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void reset() {
        if (this.getState() == AlgorithmStates.RUNNING) {
            throw new IllegalStateException("The algorithm may not be reseted while it is running.");
        }
        this.state = AlgorithmStates.INITIALIZED;
    }

    public void resetParameters() {
        this.checkStateForSettingParameters();
        this.disableOptionalResults();
    }

    public void checkStateForResult() {
        if (this.state != AlgorithmStates.FINISHED && this.state != AlgorithmStates.STOPPED) {
            throw new IllegalStateException("The result cannot be obtained while in this state: " + (Object)((Object)this.state));
        }
    }

    public void checkStateForSettingParameters() {
        if (this.getState() != AlgorithmStates.INITIALIZED) {
            throw new IllegalStateException("Parameters may not be changed while in state " + (Object)((Object)this.state));
        }
    }

    public void checkStateForSettingVisitors() {
        if (this.getState() == AlgorithmStates.RUNNING || this.getState() == AlgorithmStates.CANCELED) {
            throw new IllegalStateException("Parameters may not be changed while in state " + (Object)((Object)this.state));
        }
    }

    public abstract void disableOptionalResults();

    public void terminate() throws AlgorithmTerminatedException {
        if (this.getState() == AlgorithmStates.RUNNING) {
            this.done();
            throw new AlgorithmTerminatedException("Terminated by algorithm.");
        }
        throw new IllegalStateException("The algorithm may only be terminated, when in state " + (Object)((Object)AlgorithmStates.RUNNING));
    }

    protected synchronized void cancelIfInterrupted() throws AlgorithmTerminatedException {
        if (Thread.interrupted()) {
            this.state = AlgorithmStates.CANCELED;
            Thread.currentThread().interrupt();
            throw new AlgorithmTerminatedException("Thread interrupted.");
        }
    }

    protected void startRunning() {
        if (this.state != AlgorithmStates.INITIALIZED && this.state != AlgorithmStates.STOPPED) {
            throw new IllegalStateException("The algorithm cannot be started, when in state " + (Object)((Object)this.state));
        }
        this.state = AlgorithmStates.RUNNING;
    }

    protected abstract void done();

    public abstract boolean isDirected();

    public abstract boolean isHybrid();

    @Override
    public abstract void addVisitor(Visitor var1);

    public abstract void removeVisitor(Visitor var1);
}

