/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.GraphChangeListener;
import de.uni_koblenz.jgralab.GraphFactory;
import de.uni_koblenz.jgralab.GraphStructureChangedListener;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.TemporaryEdge;
import de.uni_koblenz.jgralab.TemporaryVertex;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.VertexFilter;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.DataOutputStream;
import java.util.Comparator;
import java.util.Map;

public interface Graph
extends AttributedElement<GraphClass, Graph> {
    public <T extends Vertex> T createVertex(VertexClass var1);

    public <T extends Edge> T createEdge(EdgeClass var1, Vertex var2, Vertex var3);

    public TemporaryVertex createTemporaryVertex();

    public TemporaryVertex createTemporaryVertex(VertexClass var1);

    public TemporaryEdge createTemporaryEdge(Vertex var1, Vertex var2);

    public TemporaryEdge createTemporaryEdge(EdgeClass var1, Vertex var2, Vertex var3);

    public Object getEnumConstant(EnumDomain var1, String var2);

    public Record createRecord(RecordDomain var1, Map<String, Object> var2);

    public boolean isGraphModified(long var1);

    public long getGraphVersion();

    public boolean containsVertex(Vertex var1);

    public boolean containsEdge(Edge var1);

    public void deleteVertex(Vertex var1);

    public void deleteEdge(Edge var1);

    public Vertex getFirstVertex();

    public Vertex getLastVertex();

    public Vertex getFirstVertex(VertexClass var1);

    public Edge getFirstEdge();

    public Edge getLastEdge();

    public Edge getFirstEdge(EdgeClass var1);

    public Vertex getVertex(int var1);

    public Edge getEdge(int var1);

    public int getVCount();

    public int getECount();

    public String getId();

    public Iterable<Edge> edges();

    public Iterable<Edge> edges(EdgeClass var1);

    public Iterable<Vertex> vertices();

    public Iterable<Vertex> vertices(VertexFilter<Vertex> var1);

    public Iterable<Vertex> vertices(VertexClass var1);

    public Iterable<Vertex> vertices(VertexClass var1, VertexFilter<Vertex> var2);

    public boolean hasTemporaryElements();

    public void sortVertices(Comparator<Vertex> var1);

    public void sortEdges(Comparator<Edge> var1);

    public void addGraphStructureChangedListener(GraphStructureChangedListener var1);

    public void removeGraphStructureChangedListener(GraphStructureChangedListener var1);

    public void removeAllGraphStructureChangedListeners();

    public int getGraphStructureChangedListenerCount();

    public void addGraphChangeListener(GraphChangeListener var1);

    public void removeGraphChangeListener(GraphChangeListener var1);

    public TraversalContext setTraversalContext(TraversalContext var1);

    public TraversalContext getTraversalContext();

    public GraphFactory getGraphFactory();

    public void setGraphFactory(GraphFactory var1);

    public void save(String var1) throws GraphIOException;

    public void save(String var1, ProgressFunction var2) throws GraphIOException;

    public void save(DataOutputStream var1) throws GraphIOException;

    public void save(DataOutputStream var1, ProgressFunction var2) throws GraphIOException;

    @Override
    public GraphClass getAttributedElementClass();
}

