/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.util.Collection;
import java.util.Iterator;
import org.pcollections.Empty;
import org.pcollections.POrderedSet;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class OrderedPSet<E>
implements POrderedSet<E> {
    private static final OrderedPSet<Object> EMPTY = new OrderedPSet(Empty.set(), Empty.vector());
    private PSet<E> contents;
    private PVector<E> order;
    private int hashCode = 0;

    public static <E> OrderedPSet<E> empty() {
        return EMPTY;
    }

    public static <E> PSet<E> from(Collection<? extends E> list) {
        if (list instanceof OrderedPSet) {
            return (OrderedPSet)list;
        }
        return OrderedPSet.empty().plusAll((Collection)list);
    }

    public static <E> PSet<E> singleton(E e) {
        return OrderedPSet.empty().plus((Object)e);
    }

    private OrderedPSet(PSet<E> c, PVector<E> o) {
        this.contents = c;
        this.order = o;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0 && this.size() > 0) {
            for (Object item : this.order) {
                this.hashCode += item.hashCode();
            }
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        return this.contents.equals(o);
    }

    @Override
    public POrderedSet<E> plus(E e) {
        if (this.contents.contains(e)) {
            return this;
        }
        return new OrderedPSet<E>(this.contents.plus(e), this.order.plus(e));
    }

    @Override
    public POrderedSet<E> plusAll(Collection<? extends E> list) {
        POrderedSet<E> s = this;
        for (E e : list) {
            s = s.plus(e);
        }
        return s;
    }

    @Override
    public POrderedSet<E> minus(Object e) {
        if (!this.contents.contains(e)) {
            return this;
        }
        return new OrderedPSet<E>(this.contents.minus(e), this.order.minus(e));
    }

    @Override
    public POrderedSet<E> minusAll(Collection<?> list) {
        POrderedSet<E> s = this;
        for (Object e : list) {
            s = s.minus(e);
        }
        return s;
    }

    @Override
    public Iterator<E> iterator() {
        return this.order.iterator();
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public E get(int index) {
        return this.order.get(index);
    }

    @Override
    public int indexOf(Object o) {
        if (!this.contents.contains(o)) {
            return -1;
        }
        return this.order.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.contents.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.order.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.order.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.contents.containsAll(c);
    }

    @Override
    @Deprecated
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean first = true;
        for (Object item : this.order) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(item);
        }
        sb.append("}");
        return sb.toString();
    }
}

