/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.pcollections.PBag;
import org.pcollections.PMap;

public final class MapPBag<E>
extends AbstractCollection<E>
implements PBag<E> {
    private final PMap<E, Integer> map;
    private final int size;

    public static <E> MapPBag<E> empty(PMap<E, Integer> map) {
        return new MapPBag<E>(map.minusAll(map.keySet()), 0);
    }

    private MapPBag(PMap<E, Integer> map, int size) {
        this.map = map;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator i = this.map.entrySet().iterator();
        return new Iterator<E>(){
            private E e;
            private int n = 0;

            @Override
            public boolean hasNext() {
                return this.n > 0 || i.hasNext();
            }

            @Override
            public E next() {
                if (this.n == 0) {
                    Map.Entry entry = (Map.Entry)i.next();
                    this.e = entry.getKey();
                    this.n = (Integer)entry.getValue();
                }
                --this.n;
                return this.e;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean contains(Object e) {
        return this.map.containsKey(e);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (E e : this) {
            hashCode += e.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (!(that instanceof PBag)) {
            return false;
        }
        if (!(that instanceof MapPBag)) {
            PBag empty = this.minusAll((Collection)this);
            that = ((MapPBag)empty).plusAll((Collection)((PBag)that));
        }
        return this.map.equals(((MapPBag)that).map);
    }

    @Override
    public MapPBag<E> plus(E e) {
        return new MapPBag<E>(this.map.plus(e, this.count(e) + 1), this.size + 1);
    }

    @Override
    public MapPBag<E> minus(Object e) {
        int n = this.count(e);
        if (n == 0) {
            return this;
        }
        if (n == 1) {
            return new MapPBag<E>(this.map.minus(e), this.size - 1);
        }
        return new MapPBag<Object>(this.map.plus(e, n - 1), this.size - 1);
    }

    @Override
    public MapPBag<E> plusAll(Collection<? extends E> list) {
        PBag<E> bag = this;
        for (E e : list) {
            bag = bag.plus((Object)e);
        }
        return bag;
    }

    @Override
    public MapPBag<E> minusAll(Collection<?> list) {
        PMap<E, Integer> map = this.map.minusAll(list);
        return new MapPBag<E>(map, MapPBag.size(map));
    }

    private int count(Object o) {
        if (!this.contains(o)) {
            return 0;
        }
        return (Integer)this.map.get(o);
    }

    private static int size(PMap<?, Integer> map) {
        int size = 0;
        for (Integer n : map.values()) {
            size += n.intValue();
        }
        return size;
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }
}

