/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.xml2tg.schema.impl.std;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.VertexFilter;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.impl.IncidenceIterable;
import de.uni_koblenz.jgralab.impl.NeighbourIterable;
import de.uni_koblenz.jgralab.impl.std.VertexImpl;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Attribute;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Element;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.HasAttribute;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.References;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.XMLGraph;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AttributeImpl
extends VertexImpl
implements Attribute,
Vertex {
    protected String _name;
    protected String _value;

    public AttributeImpl(int id, Graph g) {
        super(id, g);
    }

    @Override
    public final VertexClass getAttributedElementClass() {
        return Attribute.VC;
    }

    @Override
    public final Class<? extends Vertex> getSchemaClass() {
        return Attribute.class;
    }

    @Override
    public <T> T getAttribute(String attributeName) {
        if (attributeName.equals("name")) {
            return (T)this.get_name();
        }
        if (attributeName.equals("value")) {
            return (T)this.get_value();
        }
        throw new NoSuchAttributeException("Attribute doesn't contain an attribute " + attributeName);
    }

    @Override
    public <T> void setAttribute(String attributeName, T data) {
        if (attributeName.equals("name")) {
            this.set_name((String)data);
            return;
        }
        if (attributeName.equals("value")) {
            this.set_value((String)data);
            return;
        }
        throw new NoSuchAttributeException("Attribute doesn't contain an attribute " + attributeName);
    }

    @Override
    public String get_name() {
        return this._name;
    }

    @Override
    public void set_name(String _name) {
        this.ecaAttributeChanging("name", this._name, _name);
        String oldValue = this._name;
        this._name = _name;
        this.graphModified();
        this.ecaAttributeChanged("name", oldValue, _name);
    }

    @Override
    public String get_value() {
        return this._value;
    }

    @Override
    public void set_value(String _value) {
        this.ecaAttributeChanging("value", this._value, _value);
        String oldValue = this._value;
        this._value = _value;
        this.graphModified();
        this.ecaAttributeChanged("value", oldValue, _value);
    }

    @Override
    public void readAttributeValues(GraphIO io) throws GraphIOException {
        this._name = io.matchUtfString();
        this.set_name(this._name);
        this._value = io.matchUtfString();
        this.set_value(this._value);
    }

    @Override
    public void readAttributeValueFromString(String attributeName, String value) throws GraphIOException {
        if (attributeName.equals("name")) {
            GraphIO io = GraphIO.createStringReader(value, this.getSchema());
            this._name = io.matchUtfString();
            this.set_name(this._name);
            return;
        }
        if (attributeName.equals("value")) {
            GraphIO io = GraphIO.createStringReader(value, this.getSchema());
            this._value = io.matchUtfString();
            this.set_value(this._value);
            return;
        }
        throw new NoSuchAttributeException("Attribute doesn't contain an attribute " + attributeName);
    }

    @Override
    public void writeAttributeValues(GraphIO io) throws GraphIOException, IOException {
        io.space();
        io.writeUtfString(this._name);
        io.writeUtfString(this._value);
    }

    @Override
    public String writeAttributeValueToString(String attributeName) throws IOException, GraphIOException {
        if (attributeName.equals("name")) {
            GraphIO io = GraphIO.createStringWriter(this.getSchema());
            io.writeUtfString(this._name);
            return io.getStringWriterResult();
        }
        if (attributeName.equals("value")) {
            GraphIO io = GraphIO.createStringWriter(this.getSchema());
            io.writeUtfString(this._value);
            return io.getStringWriterResult();
        }
        throw new NoSuchAttributeException("Attribute doesn't contain an attribute " + attributeName);
    }

    @Override
    public Attribute getNextAttribute() {
        return (Attribute)this.getNextVertex(Attribute.VC);
    }

    @Override
    public References getFirstReferencesIncidence() {
        return (References)this.getFirstIncidence(References.EC);
    }

    @Override
    public References getFirstReferencesIncidence(EdgeDirection orientation) {
        return (References)this.getFirstIncidence(References.EC, orientation);
    }

    @Override
    public HasAttribute getFirstHasAttributeIncidence() {
        return (HasAttribute)this.getFirstIncidence(HasAttribute.EC);
    }

    @Override
    public HasAttribute getFirstHasAttributeIncidence(EdgeDirection orientation) {
        return (HasAttribute)this.getFirstIncidence(HasAttribute.EC, orientation);
    }

    @Override
    public HasAttribute add_element(Element vertex) {
        return (HasAttribute)((XMLGraph)this.getGraph()).createEdge(HasAttribute.EC, vertex, this);
    }

    @Override
    public List<? extends Element> remove_element() {
        ArrayList<Element> adjacences = new ArrayList<Element>();
        HasAttribute edge = (HasAttribute)this.getFirstIncidence(HasAttribute.EC, EdgeDirection.IN);
        while (edge != null) {
            HasAttribute next = (HasAttribute)edge.getNextIncidence(HasAttribute.EC, EdgeDirection.IN);
            adjacences.add((Element)edge.getThat());
            edge.delete();
            edge = next;
        }
        return adjacences;
    }

    @Override
    public boolean remove_element(Element vertex) {
        boolean elementRemoved = false;
        HasAttribute edge = (HasAttribute)this.getFirstIncidence(HasAttribute.EC, EdgeDirection.IN);
        while (edge != null) {
            HasAttribute next = (HasAttribute)edge.getNextIncidence(HasAttribute.EC, EdgeDirection.IN);
            if (edge.getThat().equals(vertex)) {
                edge.delete();
                elementRemoved = true;
            }
            edge = next;
        }
        return elementRemoved;
    }

    @Override
    public Element get_element() {
        HasAttribute edge = (HasAttribute)this.getFirstIncidence(HasAttribute.EC, EdgeDirection.IN);
        if (edge != null) {
            return (Element)edge.getThat();
        }
        return null;
    }

    @Override
    public References add_refs(Element vertex) {
        return (References)((XMLGraph)this.getGraph()).createEdge(References.EC, this, vertex);
    }

    @Override
    public List<? extends Element> remove_refs() {
        ArrayList<Element> adjacences = new ArrayList<Element>();
        References edge = (References)this.getFirstIncidence(References.EC, EdgeDirection.OUT);
        while (edge != null) {
            References next = (References)edge.getNextIncidence(References.EC, EdgeDirection.OUT);
            adjacences.add((Element)edge.getThat());
            edge.delete();
            edge = next;
        }
        return adjacences;
    }

    @Override
    public boolean remove_refs(Element vertex) {
        boolean elementRemoved = false;
        References edge = (References)this.getFirstIncidence(References.EC, EdgeDirection.OUT);
        while (edge != null) {
            References next = (References)edge.getNextIncidence(References.EC, EdgeDirection.OUT);
            if (edge.getThat().equals(vertex)) {
                edge.delete();
                elementRemoved = true;
            }
            edge = next;
        }
        return elementRemoved;
    }

    @Override
    public <V extends Element> Iterable<V> get_refs() {
        return new NeighbourIterable(this, References.EC, EdgeDirection.OUT, null);
    }

    @Override
    public <V extends Element> Iterable<V> get_refs(VertexFilter<V> filter) {
        return new NeighbourIterable(this, References.EC, EdgeDirection.OUT, filter);
    }

    @Override
    public Iterable<References> getReferencesIncidences() {
        return new IncidenceIterable<References>((Vertex)this, References.EC);
    }

    @Override
    public Iterable<References> getReferencesIncidences(EdgeDirection direction) {
        return new IncidenceIterable<References>(this, References.EC, direction);
    }

    @Override
    public Iterable<HasAttribute> getHasAttributeIncidences() {
        return new IncidenceIterable<HasAttribute>((Vertex)this, HasAttribute.EC);
    }

    @Override
    public Iterable<HasAttribute> getHasAttributeIncidences(EdgeDirection direction) {
        return new IncidenceIterable<HasAttribute>(this, HasAttribute.EC, direction);
    }
}

