/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgschema2java;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.utilities.tgschema2java.SchemaJarGenerator;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class TgSchema2Java {
    int i = 0;
    private String tgFilename;
    private String commitPath = ".";
    private String classpath;
    private boolean compile = false;
    private boolean createJar = false;
    private boolean overwrite = true;
    private String jarFileName = null;
    private Schema schema;
    private CodeGeneratorConfiguration config = new CodeGeneratorConfiguration();

    public static void main(String[] args) {
        TgSchema2Java t = new TgSchema2Java();
        String tgFilename = null;
        try {
            CommandLine comLine = TgSchema2Java.processCommandLineOptions(args);
            assert (comLine != null);
            if (comLine.hasOption("p")) {
                t.setCommitPath(comLine.getOptionValue("p"));
            }
            t.setCompile(comLine.hasOption("c"));
            if (comLine.hasOption("j")) {
                t.setCreateJar(true);
                t.setJarFileName(comLine.getOptionValue("j"));
            }
            if (comLine.hasOption('w')) {
                t.setTypeSpecificMethodSupport(false);
            } else {
                t.setTypeSpecificMethodSupport(true);
            }
            tgFilename = comLine.getOptionValue("s");
            t.loadSchema(tgFilename);
        }
        catch (GraphIOException e) {
            e.printStackTrace();
            System.err.println("Couldn't read schema in file '" + tgFilename + "': " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        t.execute();
    }

    public void loadSchema(String tgFilename) throws GraphIOException {
        this.schema = GraphIO.loadSchemaFromFile(tgFilename);
    }

    public void setTypeSpecificMethodSupport(boolean enabled) {
        this.config.setTypeSpecificMethodsSupport(enabled);
    }

    private boolean deleteFolder(String path) {
        File folder = new File(path);
        if (!folder.exists()) {
            return false;
        }
        for (String filename : folder.list()) {
            File file = new File(path + File.separator + filename);
            if (file.isDirectory()) {
                this.deleteFolder(file.getPath());
                continue;
            }
            file.delete();
        }
        folder.delete();
        return true;
    }

    private Set<String> getGeneratedFilePaths(String path) {
        HashSet<String> generatedFilePaths = new HashSet<String>();
        JavaFileFilter javaFileFilter = new JavaFileFilter();
        File folder = new File(path);
        if (!folder.exists()) {
            return generatedFilePaths;
        }
        for (File file : folder.listFiles(javaFileFilter)) {
            if (file.isDirectory()) {
                generatedFilePaths.addAll(this.getGeneratedFilePaths(file.getAbsolutePath()));
                continue;
            }
            generatedFilePaths.add(file.getAbsolutePath());
        }
        return generatedFilePaths;
    }

    private boolean isExistingSchema(Schema schema) {
        String pathName;
        String schemaPath = schema.getPathName();
        Set<String> existingFilePaths = this.getGeneratedFilePaths(this.commitPath + File.separator + schemaPath);
        HashSet<String> requiredFilePaths = new HashSet<String>();
        requiredFilePaths.add(this.commitPath + File.separator + schema.getFileName() + ".java");
        requiredFilePaths.add(this.commitPath + File.separator + schema.getPathName() + File.separator + "impl" + File.separator + schema.getName() + "Factory.java");
        for (Domain d : schema.getDomains()) {
            pathName = d.getPathName();
            if (pathName != "") {
                pathName = pathName.concat(File.separator);
            }
            if (!d.toString().startsWith("Enum") && !d.toString().startsWith("Record")) continue;
            requiredFilePaths.add(this.commitPath + File.separator + schemaPath + File.separator + pathName + d.getSimpleName() + ".java");
        }
        GraphClass gc = schema.getGraphClass();
        requiredFilePaths.add(this.commitPath + File.separator + schemaPath + File.separator + gc.getFileName() + ".java");
        if (!gc.isAbstract()) {
            pathName = gc.getPathName();
            if (pathName != "") {
                pathName = pathName.concat(File.separator);
            }
            requiredFilePaths.add(this.commitPath + File.separator + schemaPath + File.separator + "impl" + File.separator + pathName + gc.getSimpleName() + "Impl.java");
        }
        for (VertexClass vc : schema.getGraphClass().getVertexClasses()) {
            requiredFilePaths.add(this.commitPath + File.separator + schemaPath + File.separator + vc.getFileName() + ".java");
            if (vc.isAbstract()) continue;
            pathName = vc.getPathName();
            if (pathName != "") {
                pathName = pathName.concat(File.separator);
            }
            requiredFilePaths.add(this.commitPath + File.separator + schemaPath + File.separator + "impl" + File.separator + pathName + vc.getSimpleName() + "Impl.java");
        }
        for (EdgeClass ec : schema.getGraphClass().getEdgeClasses()) {
            requiredFilePaths.add(this.commitPath + File.separator + schemaPath + File.separator + ec.getFileName() + ".java");
            if (ec.isAbstract()) continue;
            pathName = ec.getPathName();
            if (pathName != "") {
                pathName = pathName.concat(File.separator);
            }
            requiredFilePaths.add(this.commitPath + File.separator + schemaPath + File.separator + "impl" + File.separator + pathName + ec.getSimpleName() + "Impl.java");
            requiredFilePaths.add(this.commitPath + File.separator + schemaPath + File.separator + "impl" + File.separator + pathName + "Reversed" + ec.getSimpleName() + "Impl.java");
        }
        return existingFilePaths.containsAll(requiredFilePaths) && requiredFilePaths.containsAll(existingFilePaths);
    }

    public void compile() throws Exception {
        String packageFolder = this.schema.getPathName();
        File folder = new File(this.commitPath + File.separator + packageFolder);
        List<File> files1 = this.findFilesInDirectory(folder);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> compilationUnits1 = fileManager.getJavaFileObjectsFromFiles(files1);
        Vector<String> options = new Vector<String>();
        if (this.classpath != null) {
            options.add("-cp");
            options.add(this.classpath);
        }
        System.out.print("Starting compilation....");
        compiler.getTask(null, fileManager, null, null, null, compilationUnits1).call();
        System.out.println("finished");
    }

    private List<File> findFilesInDirectory(File folder) throws Exception {
        ArrayList<File> javaSources = new ArrayList<File>();
        for (File file : folder.listFiles()) {
            if (file.isFile() && file.getName().endsWith(".java")) {
                javaSources.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            javaSources.addAll(this.findFilesInDirectory(file));
        }
        return javaSources;
    }

    public void execute() {
        try {
            if (this.isExistingSchema(this.schema)) {
                System.out.println("Schema already exists in " + this.commitPath);
                System.out.print("Overwrite existing files (y|n)? ");
                int input = System.in.read();
                switch (input) {
                    case 121: {
                        break;
                    }
                    case 110: {
                        this.overwrite = false;
                    }
                }
            }
            if (this.overwrite) {
                this.deleteFolder(this.commitPath + File.separator + this.schema.getPathName());
                System.out.println("Committing schema " + this.schema.getQualifiedName());
                this.schema.commit(this.commitPath, this.config);
                System.out.println("Schema " + this.schema.getQualifiedName() + " committed successfully");
            }
            if (this.compile) {
                System.out.println("Compiling...");
                this.compile();
                System.out.println("Compiling successful");
            }
            if (this.createJar) {
                System.out.println("Creating .jar-file");
                this.generateJarFile();
                System.out.println(".jar-file created successfully");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateJarFile() {
        SchemaJarGenerator jarGenerator = new SchemaJarGenerator(this.commitPath, this.schema.getFileName(), this.jarFileName);
        try {
            jarGenerator.createJar();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static CommandLine processCommandLineOptions(String[] args) {
        String toolString = "java " + TgSchema2Java.class.getName();
        String versionString = JGraLab.getInfo(false);
        OptionHandler oh = new OptionHandler(toolString, versionString);
        Option filename = new Option("s", "schema", true, "(required): specifies the .tg-file of the schema to be converted");
        filename.setRequired(true);
        filename.setArgName("file");
        oh.addOption(filename);
        Option compile = new Option("c", "compile", false, "(optional): if specified, the .java are compiled");
        compile.setRequired(false);
        oh.addOption(compile);
        Option jar = new Option("j", "jar", true, "(optional): specifies the name of the .jar-file; if omitted, no jar will be created");
        jar.setRequired(false);
        jar.setArgName("file");
        oh.addOption(jar);
        Option without_types = new Option("w", "without-types", false, "(optional): Don't create typespecific methods in classes");
        without_types.setRequired(false);
        oh.addOption(without_types);
        Option path = new Option("p", "path", true, "specifies the path to where the created files are stored; default is current folder (\".\")");
        path.setRequired(true);
        path.setArgName("path");
        oh.addOption(path);
        return oh.parse(args);
    }

    public String getTgFilename() {
        return this.tgFilename;
    }

    public void setTgFilename(String tgFilename) {
        this.tgFilename = tgFilename;
    }

    public String getCommitPath() {
        return this.commitPath;
    }

    public void setCommitPath(String commitPath) {
        commitPath = commitPath.replace("/", File.separator);
        this.commitPath = commitPath = commitPath.replace("\\", File.separator);
    }

    public boolean isCompile() {
        return this.compile;
    }

    public void setCompile(boolean compile) {
        this.compile = compile;
    }

    public boolean isCreateJar() {
        return this.createJar;
    }

    public void setCreateJar(boolean createJar) {
        this.createJar = createJar;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getJarFileName() {
        return this.jarFileName;
    }

    public void setJarFileName(String jarFileName) {
        this.jarFileName = jarFileName;
    }

    public Schema getSchema() {
        return this.schema;
    }

    static class JavaFileFilter
    implements FileFilter {
        JavaFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".java");
        }
    }
}

