/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgraphbrowser;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.RequestThread;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.StateRepository;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.TGraphBrowserServer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import org.pcollections.PSet;

public class TwoDVisualizer {
    public static int SECONDS_TO_WAIT_FOR_DOT = 60;
    public static boolean PRINT_ROLE_NAMES = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visualizeElements(StringBuilder code, StateRepository.State state, Integer sessionId, String workspace, Object currentElement, Boolean showAttributes, Integer pathLength, RequestThread currentThread) {
        if (currentElement instanceof Vertex) {
            code.append("current").append("Vertex = \"").append(((Vertex)currentElement).getId()).append("\";\n");
        } else if (currentElement instanceof Edge) {
            code.append("current").append("Edge = \"").append(((Edge)currentElement).getId()).append("\";\n");
        }
        PSet<GraphElement<?, ?>> elementsToDisplay = JGraLab.set();
        if (currentElement instanceof Vertex) {
            SubGraphMarker slice = this.computeElements((Vertex)currentElement, pathLength, state.getGraph(), state);
            elementsToDisplay = this.calculateElementsInSet(code, state, elementsToDisplay, slice);
        } else if (currentElement instanceof Edge) {
            Edge current = (Edge)currentElement;
            SubGraphMarker slice = this.computeElements(current.getAlpha(), pathLength, state.getGraph(), state);
            elementsToDisplay = this.calculateElementsInSet(code, state, elementsToDisplay, slice);
            slice = this.computeElements(current.getOmega(), pathLength, state.getGraph(), state);
            elementsToDisplay = this.calculateElementsInSet(code, state, elementsToDisplay, slice);
        } else {
            elementsToDisplay = this.calculateElementsInSet(code, state, elementsToDisplay, currentElement);
        }
        File tempFolder = new File(System.getProperty("java.io.tmpdir") + File.separator + "tgraphbrowser");
        if (!tempFolder.exists() && !tempFolder.mkdir()) {
            TGraphBrowserServer.logger.warning(tempFolder + " could not be created.");
        }
        tempFolder.deleteOnExit();
        String dotFileName = null;
        try {
            dotFileName = tempFolder.getCanonicalPath() + File.separator + sessionId + "GraphSnippet.dot";
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        MyTg2Dot mtd = new MyTg2Dot(elementsToDisplay, dotFileName, showAttributes, currentElement, state.selectedEdgeClasses, state.selectedVertexClasses);
        mtd.convert();
        if (mtd.exception != null) {
            code.append("document.getElementById('divError').style.display = \"block\";\n");
            code.append("document.getElementById('h2ErrorMessage').innerHTML = \"ERROR: ").append("Could not create file ").append(dotFileName).append("\";\n");
            code.append("document.getElementById('divNonError').style.display = \"none\";\n");
            return;
        }
        String svgFileName = null;
        try {
            svgFileName = tempFolder.getCanonicalPath() + File.separator + sessionId + "GraphSnippet.svg";
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            String e1 = StateRepository.dot;
            synchronized (e1) {
                String execStr = null;
                execStr = System.getProperty("os.name").startsWith("Windows") ? StateRepository.dot + " -Tsvg -o \"" + svgFileName + "\" \"" + dotFileName + "\"" : StateRepository.dot + " -Tsvg -o " + svgFileName + " " + dotFileName;
                ExecutingDot dotThread = new ExecutingDot(execStr, currentThread);
                dotThread.start();
                try {
                    RequestThread requestThread = currentThread;
                    synchronized (requestThread) {
                        currentThread.wait(SECONDS_TO_WAIT_FOR_DOT * 1000);
                    }
                    dotThread.svgCreationProcess.destroy();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (dotThread.exitCode != -1) {
                    if (dotThread.exitCode != 0 && dotThread.exception != null) {
                        throw dotThread.exception;
                    }
                } else {
                    code.append("changeView();\n");
                    code.append("document.getElementById('divError').style.display = \"block\";\n");
                    code.append("document.getElementById('h2ErrorMessage').innerHTML = \"ERROR: ").append("Creation of file ").append(svgFileName.contains("\\") ? svgFileName.replace("\\", "/") : svgFileName).append(" was terminated because it took more than ").append(SECONDS_TO_WAIT_FOR_DOT).append(" seconds.\";\n");
                    code.append("document.getElementById('divNonError').style.display = \"none\";\n");
                    return;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            code.append("document.getElementById('divError').style.display = \"block\";\n");
            code.append("document.getElementById('h2ErrorMessage').innerHTML = \"ERROR: ").append("Could not create file ").append(svgFileName).append("\";\n");
            code.append("document.getElementById('divNonError').style.display = \"none\";\n");
            return;
        }
        if (!new File(dotFileName).delete()) {
            TGraphBrowserServer.logger.warning(dotFileName + " could not be deleted");
        }
        assert (svgFileName != null) : "svg file name must not be null";
        svgFileName = svgFileName.substring(svgFileName.lastIndexOf(File.separator) + 1);
        code.append("/*@cc_on\n");
        code.append("/*@if (@_jscript_version > 5.6)\n");
        code.append("var div2D = document.getElementById(\"div2DGraph\");\n");
        code.append("var object = document.createElement(\"embed\");\n");
        code.append("object.id = \"embed2DGraph\";\n");
        code.append("object.src = \"_").append(svgFileName).append("\";\n");
        code.append("object.type = \"image/svg+xml\";\n");
        code.append("div2D.appendChild(object);\n");
        code.append("@else @*/\n");
        code.append("var div2D = document.getElementById(\"div2DGraph\");\n");
        code.append("var object = document.createElement(\"object\");\n");
        code.append("object.id = \"embed2DGraph\";\n");
        code.append("object.data = \"").append(svgFileName).append("\";\n");
        code.append("object.type = \"image/svg+xml\";\n");
        code.append("div2D.appendChild(object);\n");
        code.append("/*@end\n");
        code.append("@*/\n");
        code.append("object.onload = function(){\n");
        code.append("resize();\n");
        code.append("};\n");
    }

    private PSet<GraphElement<?, ?>> calculateElementsInSet(StringBuilder code, StateRepository.State state, PSet<GraphElement<?, ?>> elementsToDisplay, Object elements) {
        int totalElements = 0;
        int selectedElements = 0;
        if (elements instanceof SubGraphMarker) {
            SubGraphMarker slice = (SubGraphMarker)elements;
            for (GraphElement<?, ?> elem : slice.getMarkedElements()) {
                ++totalElements;
                if (elem instanceof Vertex) {
                    if (!state.selectedVertexClasses.get(elem.getAttributedElementClass()).booleanValue()) continue;
                    elementsToDisplay = elementsToDisplay.plus(elem);
                    ++selectedElements;
                    continue;
                }
                if (!state.selectedEdgeClasses.get(elem.getAttributedElementClass()).booleanValue()) continue;
                elementsToDisplay = elementsToDisplay.plus(((Edge)elem).getNormalEdge());
                ++selectedElements;
            }
        } else {
            PSet s = (PSet)elements;
            for (GraphElement v : s) {
                ++totalElements;
                if (v instanceof Vertex && state.selectedVertexClasses.get(v.getAttributedElementClass()).booleanValue()) {
                    elementsToDisplay = elementsToDisplay.plus(v);
                    ++selectedElements;
                    continue;
                }
                if (!state.selectedEdgeClasses.get(v.getAttributedElementClass()).booleanValue()) continue;
                elementsToDisplay = elementsToDisplay.plus(((Edge)v).getNormalEdge());
                ++selectedElements;
            }
        }
        code.append("var div2D = document.getElementById(\"div2DGraph\");\n");
        code.append("div2D.innerHTML = \"\";\n");
        code.append("document.getElementById(\"h3HowManyElements\").innerHTML = \"").append(selectedElements).append(" of ").append(totalElements).append(" elements selected.\";\n");
        return elementsToDisplay;
    }

    private SubGraphMarker computeElements(Vertex currentElement, Integer pathLength, Graph graph, StateRepository.State state) {
        HashMap<String, Object> boundVars = new HashMap<String, Object>();
        boundVars.put("current", currentElement);
        StringBuilder query = new StringBuilder("using current: ");
        query.append("slice(current,<->" + state.getEdgeTypeSet() + "^1");
        for (int i = 2; i <= pathLength; ++i) {
            query.append("|<->" + state.getEdgeTypeSet() + "^" + i);
        }
        query.append(")");
        return (SubGraphMarker)StateRepository.evaluateGReQL(query.toString(), graph, boundVars);
    }

    private static class MyTg2Dot {
        private static final double ranksep = 1.5;
        private static final boolean ranksepEqually = false;
        private static final double nodesep = 0.25;
        private static final String fontname = "Helvetica";
        private static final int fontsize = 14;
        protected String outputName = null;
        private boolean printIncidenceNumbers = false;
        private final PSet<GraphElement<?, ?>> elements;
        private final Object current;
        private final boolean showAttributes;
        public Exception exception;
        private int counter = 0;
        private final HashMap<EdgeClass, Boolean> selectedEdgeClasses;
        private final HashMap<VertexClass, Boolean> selectedVertexClasses;

        public MyTg2Dot(PSet<GraphElement<?, ?>> elements, String outputFileName, Boolean showAttributes, Object currentElement, HashMap<EdgeClass, Boolean> selectedEdgeClasses2, HashMap<VertexClass, Boolean> selectedVertexClasses2) {
            this.selectedEdgeClasses = selectedEdgeClasses2;
            this.selectedVertexClasses = selectedVertexClasses2;
            this.elements = elements;
            this.outputName = outputFileName;
            this.showAttributes = showAttributes;
            this.setPrintIncidenceNumbers(true);
            this.current = currentElement;
        }

        public void setPrintIncidenceNumbers(boolean printIncidenceNumbers) {
            this.printIncidenceNumbers = printIncidenceNumbers;
        }

        public boolean isPrintIncidenceNumbers() {
            return this.printIncidenceNumbers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void convert() {
            try (PrintStream out = null;){
                out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.outputName)));
                this.graphStart(out);
                for (GraphElement graphElement : this.elements) {
                    if (graphElement instanceof Vertex) {
                        this.printVertex(out, (Vertex)graphElement);
                        continue;
                    }
                    this.printEdge(out, (Edge)graphElement);
                }
                this.graphEnd(out);
                out.flush();
            }
        }

        public void graphEnd(PrintStream out) {
            out.println("}");
        }

        public void graphStart(PrintStream out) {
            out.println("digraph \"" + this.outputName + "\"");
            out.println("{");
            out.println("ranksep=\"1.5\";");
            out.println("nodesep=\"0.25\";");
            out.println("node [shape=\"record\" style=\"filled\"  fillcolor=\"white\" fontname=\"Helvetica\" fontsize=\"14\" color=\"#999999\"];");
            out.println("edge [fontname=\"Helvetica\" fontsize=\"14\" labelfontname=\"Helvetica\" labelfontsize=\"14\" color=\"#999999\" penwidth=\"3\"  arrowsize=\"1.5\" ];");
        }

        protected void printEdge(PrintStream out, Edge e) {
            if (!this.selectedEdgeClasses.get(e.getAttributedElementClass()).booleanValue()) {
                return;
            }
            Vertex alpha = e.getAlpha();
            Vertex omega = e.getOmega();
            if (!this.selectedVertexClasses.get(alpha.getAttributedElementClass()).booleanValue() || !this.selectedVertexClasses.get(omega.getAttributedElementClass()).booleanValue()) {
                return;
            }
            out.print("v" + alpha.getId() + " -> v" + omega.getId() + " [");
            EdgeClass cls = e.getAttributedElementClass();
            out.print("dir=\"both\" ");
            if (e.getOmegaAggregationKind() == AggregationKind.SHARED) {
                out.print("arrowtail=\"odiamond\" ");
            } else if (e.getOmegaAggregationKind() == AggregationKind.COMPOSITE) {
                out.print("arrowtail=\"diamond\" ");
            } else if (e.getAlphaAggregationKind() == AggregationKind.SHARED) {
                out.print("arrowhead=\"odiamondnormal\" ");
                out.print("arrowtail=\"none\" ");
            } else if (e.getAlphaAggregationKind() == AggregationKind.COMPOSITE) {
                out.print("arrowhead=\"diamondnormal\" ");
                out.print("arrowtail=\"none\" ");
            } else {
                out.print("arrowtail=\"none\" ");
            }
            out.print(" label=\"e" + e.getId() + ": " + cls.getUniqueName().replace('$', '.') + "");
            if (this.showAttributes && cls.getAttributeCount() > 0) {
                out.print("\\l");
                this.printAttributes(out, e);
            }
            out.print("\"");
            out.print(" tooltip=\"");
            if (!this.showAttributes) {
                this.printAttributes(out, e);
            }
            out.print(" \"");
            if (this.isPrintIncidenceNumbers()) {
                String fromRole = null;
                String toRole = null;
                if (PRINT_ROLE_NAMES) {
                    EdgeClass ec = e.getAttributedElementClass();
                    fromRole = ec.getFrom().getRolename();
                    toRole = ec.getTo().getRolename();
                }
                out.print(" taillabel=\"" + this.getIncidenceNumber(e, alpha) + (fromRole != null && !fromRole.isEmpty() ? ", " + fromRole : "") + "\"");
                out.print(" headlabel=\"" + this.getIncidenceNumber(e.getReversedEdge(), omega) + (toRole != null && !toRole.isEmpty() ? ", " + toRole : "") + "\"");
            }
            out.print(" href=\"javascript:top.showElement('e" + e.getId() + "');\"");
            if (e == this.current) {
                out.print(" color=\"red\"");
            }
            out.println("];");
        }

        private int getIncidenceNumber(Edge e, Vertex v) {
            int num = 1;
            for (Edge inc : v.incidences()) {
                if (inc == e) {
                    return num;
                }
                ++num;
            }
            return -1;
        }

        private void printAttributes(PrintStream out, AttributedElement<?, ?> elem) {
            Object cls = elem.getAttributedElementClass();
            StringBuilder value = new StringBuilder();
            for (Attribute attr : cls.getAttributeList()) {
                String attributeString;
                String current = attr.getName();
                Object attribute = elem.getAttribute(attr.getName());
                String string = attributeString = attribute != null ? attribute.toString() : "null";
                if (attribute instanceof String) {
                    attributeString = '\"' + attributeString + '\"';
                }
                current = current + " = " + this.stringQuote(attributeString) + (this.showAttributes ? "\\l" : ";");
                if (!this.showAttributes) {
                    if (value.length() + current.length() < 400) {
                        value.append(current);
                        continue;
                    }
                    value.append(" ...");
                    break;
                }
                value.append(current);
            }
            out.print(value);
        }

        protected void printVertex(PrintStream out, Vertex v) {
            VertexClass cls = v.getAttributedElementClass();
            out.print("v" + v.getId() + " [label=\"{{v" + v.getId() + "|" + cls.getUniqueName().replace('$', '.') + "}");
            if (this.showAttributes && cls.getAttributeCount() > 0) {
                out.print("|");
                this.printAttributes(out, v);
            }
            out.print("}\"");
            out.print(" href=\"javascript:top.showElement('v" + v.getId() + "');\"");
            if (v == this.current) {
                out.print(" fillcolor=\"#FFC080\"");
            }
            out.print(" tooltip=\"");
            if (!this.showAttributes) {
                this.printAttributes(out, v);
            }
            out.print(" \"");
            out.println("];");
            for (Edge e : v.incidences()) {
                if (this.elements.contains(e.getNormalEdge()) || !this.selectedEdgeClasses.get(e.getNormalEdge().getAttributedElementClass()).booleanValue()) continue;
                out.println("nv" + this.counter + " [shape=\"plaintext\" fontcolor=\"white\"]");
                out.println("nv" + this.counter++ + " -> v" + v.getId() + " [style=\"dashed\"]");
                break;
            }
        }

        protected String stringQuote(String s) {
            StringBuilder sb = new StringBuilder();
            block12: for (char ch : s.toCharArray()) {
                switch (ch) {
                    case '\\': {
                        sb.append("\\\\");
                        continue block12;
                    }
                    case '<': {
                        sb.append("\\<");
                        continue block12;
                    }
                    case '>': {
                        sb.append("\\>");
                        continue block12;
                    }
                    case '{': {
                        sb.append("\\{");
                        continue block12;
                    }
                    case '}': {
                        sb.append("\\}");
                        continue block12;
                    }
                    case '\"': {
                        sb.append("\\\"");
                        continue block12;
                    }
                    case '|': {
                        sb.append("\\|");
                        continue block12;
                    }
                    case '\n': {
                        sb.append("\\\\n");
                        continue block12;
                    }
                    case '\r': {
                        sb.append("\\\\r");
                        continue block12;
                    }
                    case '\t': {
                        sb.append("\\\\t");
                        continue block12;
                    }
                    default: {
                        if (ch < ' ' || ch > '\u007f') {
                            sb.append("\\\\u");
                            String code = "000" + Integer.toHexString(ch);
                            sb.append(code.substring(code.length() - 4, code.length()));
                            continue block12;
                        }
                        sb.append(ch);
                    }
                }
            }
            return sb.toString();
        }
    }

    private static final class ExecutingDot
    extends Thread {
        public Process svgCreationProcess;
        private final String execStr;
        public int exitCode = -1;
        public IOException exception;
        private final RequestThread sleepingRequestThread;

        public ExecutingDot(String command, RequestThread currentThread) {
            this.execStr = command;
            this.sleepingRequestThread = currentThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            try {
                this.svgCreationProcess = Runtime.getRuntime().exec(this.execStr);
                this.exitCode = this.svgCreationProcess.waitFor();
                RequestThread requestThread = this.sleepingRequestThread;
                synchronized (requestThread) {
                    if (this.sleepingRequestThread.getState() == Thread.State.TIMED_WAITING) {
                        this.sleepingRequestThread.notify();
                    }
                }
            }
            catch (IOException e) {
                this.exception = e;
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

