/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgraphbrowser;

import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.StateRepository;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pcollections.PSet;

public class SchemaVisualizer {
    public void createSchemaRepresentation(StringBuilder code, StateRepository.State state) {
        this.createAttributedElementClassRepresentation(code, state, true);
        this.createAttributedElementClassRepresentation(code, state, false);
        this.createPackageRepresentation(code, state);
    }

    private void createPackageRepresentation(StringBuilder code, StateRepository.State state) {
        Package defaultPackage = state.getGraph().getSchema().getDefaultPackage();
        code.append("var divPackage = document.getElementById(\"divPackage\");\n");
        code.append("var ulRootPackage = document.createElement(\"ul\");\n");
        code.append("ulRootPackage.id = \"ulRootPackage\";\n");
        code.append("divPackage.appendChild(ulRootPackage);\n");
        this.createEntriesForPackage(code, "ulRootPackage", defaultPackage, true, state.getGraph().getSchema().getGraphClass().getVertexClasses(), state.getGraph().getSchema().getGraphClass().getEdgeClasses());
    }

    private void createEntriesForPackage(StringBuilder code, String parentUl, Package currentPackage, boolean isDefaultPackage, List<VertexClass> vertices, List<EdgeClass> edges) {
        String codeSnippet;
        GraphElementClass<VertexClass, Vertex> next;
        boolean superClassIsAlreadyDeselected;
        Iterator iterator;
        String simpleName = isDefaultPackage ? "defaultPackage" : currentPackage.getSimpleName();
        String uniqueName = isDefaultPackage ? "defaultPackage" : this.replaceDollar(currentPackage.getUniqueName().replaceAll(Pattern.quote("."), "__"));
        String qualifiedName = isDefaultPackage ? "defaultPackage" : currentPackage.getQualifiedName();
        String thenPartOfAdditionalCode = "";
        String elsePartOfAdditionalCode = "";
        for (VertexClass vc : vertices) {
            if (vc.getQualifiedName().equals("Vertex")) continue;
            iterator = vc.getDirectSuperClasses().iterator();
            superClassIsAlreadyDeselected = false;
            while (iterator.hasNext() && !superClassIsAlreadyDeselected) {
                next = (VertexClass)iterator.next();
                if (next.getQualifiedName().equals("Vertex")) continue;
                superClassIsAlreadyDeselected |= vertices.contains(next);
            }
            if (superClassIsAlreadyDeselected) continue;
            String uniqueNameOfVc = this.replaceDollar(vc.getUniqueName());
            codeSnippet = "";
            codeSnippet = codeSnippet + "var checkbox" + uniqueNameOfVc + " = document.getElementById(\"input" + uniqueNameOfVc + "\");\n";
            codeSnippet = codeSnippet + "checkbox" + uniqueNameOfVc + ".checked = !checkbox" + uniqueNameOfVc + ".checked;\n";
            codeSnippet = codeSnippet + "deSelect(\"" + uniqueNameOfVc + "\",\"input" + uniqueName + "\");\n";
            if (vc.getPackage() == currentPackage) {
                elsePartOfAdditionalCode = elsePartOfAdditionalCode + codeSnippet;
            }
            thenPartOfAdditionalCode = thenPartOfAdditionalCode + codeSnippet;
        }
        for (EdgeClass e : edges) {
            if (e.getQualifiedName().equals("Edge") || e.getQualifiedName().equals("Aggregation") || e.getQualifiedName().equals("Composition")) continue;
            iterator = e.getDirectSuperClasses().iterator();
            superClassIsAlreadyDeselected = false;
            while (iterator.hasNext() && !superClassIsAlreadyDeselected) {
                next = (EdgeClass)iterator.next();
                if (next.getQualifiedName().equals("Edge") || next.getQualifiedName().equals("Aggregation") || next.getQualifiedName().equals("Composition")) continue;
                superClassIsAlreadyDeselected |= edges.contains(next);
            }
            if (superClassIsAlreadyDeselected) continue;
            String uniqueNameOfE = this.replaceDollar(e.getUniqueName());
            codeSnippet = "";
            codeSnippet = codeSnippet + "var checkbox" + uniqueNameOfE + " = document.getElementById(\"input" + uniqueNameOfE + "\");\n";
            codeSnippet = codeSnippet + "checkbox" + uniqueNameOfE + ".checked = !checkbox" + uniqueNameOfE + ".checked;\n";
            codeSnippet = codeSnippet + "deSelect(\"" + uniqueNameOfE + "\",\"input" + uniqueName + "\");\n";
            if (e.getPackage() == currentPackage) {
                elsePartOfAdditionalCode = elsePartOfAdditionalCode + codeSnippet;
            }
            thenPartOfAdditionalCode = thenPartOfAdditionalCode + codeSnippet;
        }
        String additionalCode = "if(document.getElementById(\"checkSelectAll\").checked){\n";
        additionalCode = additionalCode + thenPartOfAdditionalCode;
        additionalCode = additionalCode + "}else{\n";
        additionalCode = additionalCode + elsePartOfAdditionalCode;
        additionalCode = additionalCode + "}\n";
        this.createLi(code, parentUl, uniqueName, simpleName);
        this.createCheckBox(code, uniqueName, qualifiedName, additionalCode);
        this.createP(code, simpleName, uniqueName, qualifiedName, false, null);
        PSet<Package> subPackages = currentPackage.getSubPackages();
        if (!subPackages.isEmpty()) {
            this.convertToTypeWithSubtypes(code, uniqueName);
            for (Package p : subPackages) {
                ArrayList<VertexClass> verticesOfThisPackage = new ArrayList<VertexClass>();
                for (VertexClass vc : vertices) {
                    if (!vc.getQualifiedName().startsWith(p.getQualifiedName())) continue;
                    verticesOfThisPackage.add(vc);
                }
                ArrayList<EdgeClass> edgesOfThisPackage = new ArrayList<EdgeClass>();
                for (EdgeClass e : edges) {
                    if (!e.getQualifiedName().startsWith(p.getQualifiedName())) continue;
                    edgesOfThisPackage.add(e);
                }
                this.createEntriesForPackage(code, "ul" + uniqueName, p, false, verticesOfThisPackage, edgesOfThisPackage);
            }
        }
    }

    private String replaceDollar(String uniqueName) {
        return Pattern.compile(Matcher.quoteReplacement("$")).matcher(uniqueName).replaceAll(Matcher.quoteReplacement(""));
    }

    private void createAttributedElementClassRepresentation(StringBuilder code, StateRepository.State state, boolean createForVertex) {
        assert (state != null) : "state is null";
        assert (state.getGraph() != null) : "graph is null";
        assert (state.getGraph().getSchema() != null) : "schema is null";
        List<GraphElementClass<VertexClass, Vertex>> classes = createForVertex ? state.getGraph().getSchema().getGraphClass().getVertexClasses() : state.getGraph().getSchema().getGraphClass().getEdgeClasses();
        String var = createForVertex ? "Vertex" : "Edge";
        this.createRootUl(code, var);
        ArrayList<GraphElementClass<VertexClass, Vertex>> unsetAEClasses = new ArrayList<GraphElementClass<VertexClass, Vertex>>();
        ArrayList unsetSuperClasses = new ArrayList();
        for (GraphElementClass<VertexClass, Vertex> graphElementClass : classes) {
            if (createForVertex) {
                state.selectedVertexClasses.put((VertexClass)graphElementClass, true);
            } else {
                state.selectedEdgeClasses.put((EdgeClass)graphElementClass, true);
            }
            PSet<VertexClass> superClasses = graphElementClass.getDirectSuperClasses();
            String ulName = "";
            Iterator superClassIter = superClasses.iterator();
            if (superClassIter.hasNext()) {
                GraphElementClass superClass = (GraphElementClass)superClassIter.next();
                while ((superClass.getQualifiedName().equals("Vertex") || superClass.getQualifiedName().equals("Edge") || superClass.getQualifiedName().equals("Aggregation") || superClass.getQualifiedName().equals("Composition")) && superClassIter.hasNext()) {
                    superClass = (GraphElementClass)superClassIter.next();
                }
                if (superClass.getQualifiedName().equals("Vertex") || superClass.getQualifiedName().equals("Edge") || superClass.getQualifiedName().equals("Aggregation") || superClass.getQualifiedName().equals("Composition")) {
                    ulName = "Root" + var;
                } else {
                    ulName = this.replaceDollar(superClass.getUniqueName());
                    if (superClassIter.hasNext()) {
                        unsetAEClasses.add(graphElementClass);
                        unsetSuperClasses.add(superClassIter);
                    }
                }
            } else {
                ulName = "Root" + var;
            }
            this.createLi(code, "ul" + ulName, this.replaceDollar(graphElementClass.getUniqueName()), graphElementClass.getSimpleName());
            this.createCheckBox(code, this.replaceDollar(graphElementClass.getUniqueName()), graphElementClass.getQualifiedName(), "");
            this.createP(code, graphElementClass.getSimpleName(), this.replaceDollar(graphElementClass.getUniqueName()), graphElementClass.getQualifiedName(), graphElementClass.isAbstract(), graphElementClass.getAttributeList());
            if (graphElementClass.getDirectSubClasses().size() <= 0) continue;
            this.convertToTypeWithSubtypes(code, this.replaceDollar(graphElementClass.getUniqueName()));
        }
        if (!unsetSuperClasses.isEmpty()) {
            for (int z = unsetAEClasses.size() - 1; z >= 0; --z) {
                AttributedElementClass attributedElementClass = (AttributedElementClass)unsetAEClasses.get(z);
                int i = 0;
                while (((Iterator)unsetSuperClasses.get(z)).hasNext()) {
                    AttributedElementClass cls = (AttributedElementClass)((Iterator)unsetSuperClasses.get(z)).next();
                    String supCls = this.replaceDollar(cls.getUniqueName());
                    if (state.getGraph().getSchema().getAttributedElementClass("Aggregation") != cls && state.getGraph().getSchema().getAttributedElementClass("Composition") != cls) {
                        this.cloneType(code, attributedElementClass, i, supCls);
                        this.adaptClone(code, attributedElementClass, i);
                    }
                    ++i;
                }
            }
        }
    }

    private void cloneType(StringBuilder code, AttributedElementClass<?, ?> aeclass, int i, String supCls) {
        String uniqueName = this.replaceDollar(aeclass.getUniqueName());
        code.append("var li").append(uniqueName).append("_").append(i).append(" = li").append(uniqueName).append(".cloneNode(true);\n");
        code.append("insertSorted(li").append(uniqueName).append("_").append(i).append(", '").append(aeclass.getSimpleName()).append("', ul").append(supCls).append(", 0, (ul").append(supCls).append(".childNodes && ul").append(supCls).append(".childNodes.length>0)?ul").append(supCls).append(".childNodes.length-1:0);\n");
    }

    private void adaptClone(StringBuilder code, AttributedElementClass<?, ?> aeclass, int i) {
        String uniqueName = this.replaceDollar(aeclass.getUniqueName());
        code.append("var findFreeNumber = function(prefix){\n");
        code.append("var sufcnt=0;\n");
        code.append("while(document.getElementById(prefix+\":\"+sufcnt)){\n");
        code.append("sufcnt++;\n");
        code.append("}\n;");
        code.append("return sufcnt;\n");
        code.append("}\n;");
        code.append("var baseName = li").append(uniqueName).append("_").append(i).append(".id.substr(2);\n");
        code.append("li").append(uniqueName).append("_").append(i).append(".id = \"li\"+baseName+\":\"").append(" + findFreeNumber(\"li\"+baseName);\n");
        code.append("var li").append(uniqueName).append("_").append(i).append("ulChildren = li").append(uniqueName).append("_").append(i).append(".getElementsByTagName(\"ul\");\n");
        code.append("for (var i=0; i<li").append(uniqueName).append("_").append(i).append("ulChildren.length;i++){\n");
        code.append("var baseName = li").append(uniqueName).append("_").append(i).append("ulChildren[i].parentNode.childNodes[1].name.substr(5);\n");
        code.append("li").append(uniqueName).append("_").append(i).append("ulChildren[i].id = \"ul\"+baseName+\":\"").append(" + findFreeNumber(\"ul\"+baseName);\n");
        code.append("}\n");
        code.append("var li").append(uniqueName).append("_").append(i).append("liChildren = li").append(uniqueName).append("_").append(i).append(".getElementsByTagName(\"li\");\n");
        code.append("for (var i=0; i<li").append(uniqueName).append("_").append(i).append("liChildren.length;i++){\n");
        code.append("var baseName = li").append(uniqueName).append("_").append(i).append("liChildren[i].childNodes[1].name.substr(5);\n");
        code.append("li").append(uniqueName).append("_").append(i).append("liChildren[i].id = \"li\"+baseName+\":\" ").append("+ findFreeNumber(\"li\"+baseName);\n");
        code.append("}\n");
        code.append("var li").append(uniqueName).append("_").append(i).append("aChildren = li").append(uniqueName).append("_").append(i).append(".getElementsByTagName(\"a\");\n");
        code.append("for (var i=0; i<li").append(uniqueName).append("_").append(i).append("aChildren.length;i++){\n");
        code.append("var baseName = li").append(uniqueName).append("_").append(i).append("aChildren[i].parentNode.childNodes[1].name.substr(5);\n");
        code.append("var baseName = baseName+\":\"+findFreeNumber(\"a\"+baseName);\n");
        code.append("li").append(uniqueName).append("_").append(i).append("aChildren[i].id = \"a\"+baseName;\n");
        code.append("li").append(uniqueName).append("_").append(i).append("aChildren[i].href =").append(" \"javascript:expand('ul\"+baseName+\"','a\"+baseName+\"');\";\n");
        code.append("}\n");
        code.append("var li").append(uniqueName).append("_").append(i).append("inputChildren = li").append(uniqueName).append("_").append(i).append(".getElementsByTagName(\"input\");\n");
        code.append("for (var i=0; i<li").append(uniqueName).append("_").append(i).append("inputChildren.length;i++){\n");
        code.append("var baseName = li").append(uniqueName).append("_").append(i).append("inputChildren[i].name.substr(5);\n");
        code.append("li").append(uniqueName).append("_").append(i).append("inputChildren[i].id = \"input\"+baseName+\":\"").append(" + findFreeNumber(\"input\"+baseName);\n");
        code.append("li").append(uniqueName).append("_").append(i).append("inputChildren[i].onclick = function(){").append("deSelect(this.value.substr(this.value.lastIndexOf('.')+1),this.id);\n").append("submitDeselectedTypes();\n};\n");
        code.append("li").append(uniqueName).append("_").append(i).append("inputChildren[i].checked = true;\n");
        code.append("}\n");
    }

    private void createRootUl(StringBuilder code, String var) {
        code.append("var div").append(var).append("Class = document.getElementById(\"div").append(var).append("Class\");\n");
        code.append("var ulRoot").append(var).append(" = document.createElement(\"ul\");\n");
        code.append("ulRoot").append(var).append(".id = \"ulRoot").append(var).append("\";\n");
        code.append("div").append(var).append("Class.appendChild(ulRoot").append(var).append(");\n");
    }

    private void convertToTypeWithSubtypes(StringBuilder code, String uniqueName) {
        code.append("var a").append(uniqueName).append(" = document.createElement(\"a\");\n");
        code.append("a").append(uniqueName).append(".id = \"a").append(uniqueName).append("\";\n");
        code.append("a").append(uniqueName).append(".href = \"javascript:expand('ul").append(uniqueName).append("','a").append(uniqueName).append("');\";\n");
        code.append("var img").append(uniqueName).append(" = document.createElement(\"img\");\n");
        code.append("img").append(uniqueName).append(".src = \"plus.png\";\n");
        code.append("img").append(uniqueName).append(".alt = \"+\";\n");
        code.append("a").append(uniqueName).append(".appendChild(img").append(uniqueName).append(");\n");
        code.append("var ul").append(uniqueName).append(" = document.createElement(\"ul\");\n");
        code.append("ul").append(uniqueName).append(".id = \"ul").append(uniqueName).append("\";\n");
        code.append("li").append(uniqueName).append(".appendChild(ul").append(uniqueName).append(");\n");
        code.append("li").append(uniqueName).append(".replaceChild(a").append(uniqueName).append(",ws").append(uniqueName).append(");\n");
    }

    private void createP(StringBuilder code, String simpleName, String uniqueName, String qualifiedName, boolean isAbstract, List<Attribute> attributes) {
        StringBuilder title = new StringBuilder(qualifiedName);
        if (attributes != null) {
            if (!attributes.isEmpty()) {
                title.append(":");
            }
            for (Attribute attr : attributes) {
                title.append("    ").append(attr.getDomain().getQualifiedName()).append(" ").append(attr.getName()).append(";");
            }
        }
        code.append("var p").append(uniqueName).append(" = document.createElement(\"p\");\n");
        code.append("p").append(uniqueName).append(".title = \"").append((CharSequence)title).append("\";\n");
        code.append("p").append(uniqueName).append(".innerHTML = \"").append(isAbstract ? "<i>" : "").append(simpleName).append(isAbstract ? "</i>" : "").append("\";\n");
        code.append("li").append(uniqueName).append(".appendChild(p").append(uniqueName).append(");\n");
    }

    private void createCheckBox(StringBuilder code, String uniqueName, String qualifiedName, String additionalCode) {
        code.append("var input").append(uniqueName).append(";\n");
        code.append("if(navigator.appName == \"Microsoft Internet Explorer\" && navigator.appVersion.indexOf(\"MSIE 7.\")!=-1){\n");
        code.append("input").append(uniqueName).append(" = document.createElement('<input checked=\"checked\" />');\n");
        code.append("} else {\n");
        code.append("input").append(uniqueName).append(" = document.createElement(\"input\");\n");
        code.append("}\n");
        code.append("input").append(uniqueName).append(".checked = true;\n");
        code.append("input").append(uniqueName).append(".id = \"input").append(uniqueName).append("\";\n");
        code.append("input").append(uniqueName).append(".type = \"checkbox\";\n");
        code.append("input").append(uniqueName).append(".name = \"input").append(uniqueName).append("\";\n");
        code.append("input").append(uniqueName).append(".value = \"").append(qualifiedName).append("\";\n");
        code.append("li").append(uniqueName).append(".appendChild(input").append(uniqueName).append(");\n");
        code.append("input").append(uniqueName).append(".onclick = function(){\n").append(additionalCode).append("deSelect('").append(uniqueName).append("',this.id);\n").append("submitDeselectedTypes();\n").append("};\n");
    }

    private void createLi(StringBuilder code, String parentUl, String uniqueName, String simpleName) {
        code.append("var li").append(uniqueName).append(" = document.createElement(\"li\");\n");
        code.append("li").append(uniqueName).append(".id = \"li").append(uniqueName).append("\";\n");
        code.append("insertSorted(li").append(uniqueName).append(", '").append(simpleName).append("', ").append(parentUl).append(", 0, (").append(parentUl).append(".childNodes && ").append(parentUl).append(".childNodes.length>0)?").append(parentUl).append(".childNodes.length-1:0);\n");
        code.append("var ws").append(uniqueName).append(" = document.createElement(\"span\");\n");
        code.append("ws").append(uniqueName).append(".style.border = \"none\";\n");
        code.append("ws").append(uniqueName).append(".style.paddingRight = \"1em\";\n");
        code.append("ws").append(uniqueName).append(".style.marginRight = \"0.2em\";\n");
        code.append("ws").append(uniqueName).append(".style.visibility = \"hidden\";\n");
        code.append("li").append(uniqueName).append(".appendChild(ws").append(uniqueName).append(");\n");
    }
}

