/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgmerge;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.graphmarker.AbstractGraphMarker;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.Schema;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class TGMerge {
    private List<Graph> additionalGraphs = new LinkedList<Graph>();
    private List<AbstractGraphMarker<?>> additionalGraphMarkers = new LinkedList();
    private Graph targetGraph;
    private Map<Vertex, Vertex> old2NewVertices = new HashMap<Vertex, Vertex>();
    private Map<Vertex, Vertex> new2OldVertices = new HashMap<Vertex, Vertex>();
    private Map<Edge, Edge> new2OldEdges = new HashMap<Edge, Edge>();
    private Map<GraphElement<?, ?>, Integer> copiedGraphPositions = new HashMap();
    private Map<GraphElement<?, ?>, Integer> targetGraphPositions = new HashMap();
    private static Logger logger = JGraLab.getLogger(TGMerge.class);

    public TGMerge(List<Graph> graphs) {
        this(graphs.toArray(new Graph[graphs.size()]));
    }

    public TGMerge(Graph g, AbstractGraphMarker<?> ... markers) {
        if (markers.length == 0) {
            throw new RuntimeException("No marker given!");
        }
        this.targetGraph = g;
        for (AbstractGraphMarker<?> m : markers) {
            this.additionalGraphMarkers.add(m);
        }
    }

    public TGMerge(Graph ... graphs) {
        if (graphs.length < 2) {
            throw new RuntimeException("Merging makes no sense with less than 2 Graphs.");
        }
        Schema s = graphs[0].getSchema();
        for (Graph g : graphs) {
            if (g.getSchema() == s) continue;
            throw new RuntimeException("It's only possible to merge additionalGraphs conforming to one schema.");
        }
        this.targetGraph = graphs[0];
        this.additionalGraphs = new LinkedList<Graph>();
        for (int i = 1; i < graphs.length; ++i) {
            this.additionalGraphs.add(graphs[i]);
        }
    }

    public static void main(String[] args) throws GraphIOException {
        CommandLine cmdl = TGMerge.processCommandLineOptions(args);
        String outputFilename = cmdl.getOptionValue('o').trim();
        LinkedList<Graph> graphs = new LinkedList<Graph>();
        for (String g : cmdl.getArgs()) {
            graphs.add(GraphIO.loadGraphFromFile(g, new ConsoleProgressFunction("Loading")));
        }
        TGMerge tgmerge = new TGMerge(graphs);
        Graph merged = tgmerge.merge();
        GraphIO.saveGraphToFile(merged, outputFilename, (ProgressFunction)new ConsoleProgressFunction("Saving"));
    }

    public Graph merge() {
        logger.fine("TargetGraph is '" + this.targetGraph.getId() + "'.");
        for (Graph graph : this.additionalGraphs) {
            logger.fine("Merging graph '" + graph.getId() + "'...");
            this.rememberTargetGraphPositions();
            this.rememberCopiedGraphPositions(graph);
            for (Vertex v : graph.vertices()) {
                this.copyVertex(v);
            }
            for (Edge e : graph.edges()) {
                this.copyEdge(e);
            }
            this.sortVertices();
            this.sortEdges();
            this.sortIncidences();
            this.resetMaps();
        }
        for (AbstractGraphMarker abstractGraphMarker : this.additionalGraphMarkers) {
            logger.fine("Merging GraphMarker '" + abstractGraphMarker + "'...");
            this.rememberTargetGraphPositions();
            this.rememberCopiedGraphPositions(abstractGraphMarker.getGraph());
            for (AttributedElement ae : abstractGraphMarker.getMarkedElements()) {
                if (!(ae instanceof Vertex)) continue;
                this.copyVertex((Vertex)ae);
            }
            for (AttributedElement ae : abstractGraphMarker.getMarkedElements()) {
                if (!(ae instanceof Edge)) continue;
                this.copyEdge((Edge)ae);
            }
            this.sortVertices();
            this.sortEdges();
            this.sortIncidences();
            this.resetMaps();
        }
        return this.targetGraph;
    }

    private void resetMaps() {
        this.old2NewVertices.clear();
        this.new2OldVertices.clear();
        this.new2OldEdges.clear();
        this.copiedGraphPositions.clear();
        this.targetGraphPositions.clear();
    }

    private void rememberCopiedGraphPositions(Graph g) {
        int pos = 0;
        for (Vertex v : g.vertices()) {
            this.copiedGraphPositions.put(v, ++pos);
        }
        pos = 0;
        for (Edge e : g.edges()) {
            this.copiedGraphPositions.put(e, ++pos);
        }
    }

    private void rememberTargetGraphPositions() {
        int pos = 0;
        for (Vertex v : this.targetGraph.vertices()) {
            this.targetGraphPositions.put(v, ++pos);
        }
        pos = 0;
        for (Edge e : this.targetGraph.edges()) {
            this.targetGraphPositions.put(e, ++pos);
        }
    }

    private void sortVertices() {
        logger.fine("Sorting " + this.targetGraph.getVCount() + " vertices...");
        VertexComparator vc = new VertexComparator();
        this.targetGraph.sortVertices(vc);
        logger.fine(vc.compareCount + " comparisons were needed to sort " + this.targetGraph.getVCount() + " vertices.");
    }

    private void sortEdges() {
        logger.fine("Sorting " + this.targetGraph.getECount() + " edges...");
        EdgeComparator ec = new EdgeComparator();
        this.targetGraph.sortEdges(ec);
        logger.fine(ec.compareCount + " comparisons were needed to sort " + this.targetGraph.getECount() + " edges.");
    }

    private void sortIncidences() {
        logger.fine("Sorting incidences...");
        for (Vertex v : this.old2NewVertices.values()) {
            v.sortIncidences(new Comparator<Edge>(){

                @Override
                public int compare(Edge e1, Edge e2) {
                    Edge old2;
                    Edge old1 = (Edge)TGMerge.this.new2OldEdges.get(e1);
                    if (old1.isBeforeIncidence(old2 = (Edge)TGMerge.this.new2OldEdges.get(e2))) {
                        return -1;
                    }
                    if (old2.isBeforeIncidence(old1)) {
                        return 1;
                    }
                    throw new RuntimeException("Exception while sorting incidences.");
                }
            });
        }
    }

    private void copyEdge(Edge e) {
        Vertex start = this.old2NewVertices.get(e.getAlpha());
        Vertex end = this.old2NewVertices.get(e.getOmega());
        Object newEdge = this.targetGraph.createEdge(e.getAttributedElementClass(), start, end);
        this.copyAttributes(e, (AttributedElement<?, ?>)newEdge);
        this.new2OldEdges.put((Edge)newEdge, e);
        this.new2OldEdges.put(newEdge.getReversedEdge(), e.getReversedEdge());
    }

    private void copyVertex(Vertex v) {
        Object newVertex = this.targetGraph.createVertex(v.getAttributedElementClass());
        this.copyAttributes(v, (AttributedElement<?, ?>)newVertex);
        this.old2NewVertices.put(v, (Vertex)newVertex);
        this.new2OldVertices.put((Vertex)newVertex, v);
    }

    private void copyAttributes(AttributedElement<?, ?> oldAttrElem, AttributedElement<?, ?> newAttrElem) {
        for (Attribute attr : oldAttrElem.getAttributedElementClass().getAttributeList()) {
            newAttrElem.setAttribute(attr.getName(), oldAttrElem.getAttribute(attr.getName()));
        }
    }

    private static CommandLine processCommandLineOptions(String[] args) {
        String toolString = "java " + TGMerge.class.getName();
        String versionString = JGraLab.getInfo(false);
        OptionHandler oh = new OptionHandler(toolString, versionString);
        Option output = new Option("o", "outTG", true, "(required): output TG file");
        output.setRequired(true);
        output.setArgName("outputTG");
        oh.addOption(output);
        oh.setArgumentCount(-2);
        oh.setArgumentName("inputTG");
        oh.setOptionalArgument(false);
        return oh.parse(args);
    }

    private class EdgeComparator
    implements Comparator<Edge> {
        long compareCount = 0L;

        private EdgeComparator() {
        }

        @Override
        public int compare(Edge e1, Edge e2) {
            ++this.compareCount;
            if (TGMerge.this.new2OldEdges.containsKey(e1) && TGMerge.this.new2OldEdges.containsKey(e2)) {
                Edge oe1 = (Edge)TGMerge.this.new2OldEdges.get(e1);
                Edge oe2 = (Edge)TGMerge.this.new2OldEdges.get(e2);
                return (Integer)TGMerge.this.copiedGraphPositions.get(oe1) - (Integer)TGMerge.this.copiedGraphPositions.get(oe2);
            }
            if (TGMerge.this.new2OldEdges.containsKey(e1) && !TGMerge.this.new2OldEdges.containsKey(e2)) {
                return 1;
            }
            if (!TGMerge.this.new2OldEdges.containsKey(e1) && TGMerge.this.new2OldEdges.containsKey(e2)) {
                return -1;
            }
            if (!TGMerge.this.new2OldEdges.containsKey(e1) && !TGMerge.this.new2OldEdges.containsKey(e2)) {
                return (Integer)TGMerge.this.targetGraphPositions.get(e1) - (Integer)TGMerge.this.targetGraphPositions.get(e2);
            }
            throw new RuntimeException("Exception while sorting edges.");
        }
    }

    private class VertexComparator
    implements Comparator<Vertex> {
        long compareCount = 0L;

        private VertexComparator() {
        }

        @Override
        public int compare(Vertex v1, Vertex v2) {
            ++this.compareCount;
            if (TGMerge.this.new2OldVertices.containsKey(v1) && TGMerge.this.new2OldVertices.containsKey(v2)) {
                Vertex ov1 = (Vertex)TGMerge.this.new2OldVertices.get(v1);
                Vertex ov2 = (Vertex)TGMerge.this.new2OldVertices.get(v2);
                return (Integer)TGMerge.this.copiedGraphPositions.get(ov1) - (Integer)TGMerge.this.copiedGraphPositions.get(ov2);
            }
            if (TGMerge.this.new2OldVertices.containsKey(v1) && !TGMerge.this.new2OldVertices.containsKey(v2)) {
                return 1;
            }
            if (!TGMerge.this.new2OldVertices.containsKey(v1) && TGMerge.this.new2OldVertices.containsKey(v2)) {
                return -1;
            }
            if (!TGMerge.this.new2OldVertices.containsKey(v1) && !TGMerge.this.new2OldVertices.containsKey(v2)) {
                return (Integer)TGMerge.this.targetGraphPositions.get(v1) - (Integer)TGMerge.this.targetGraphPositions.get(v2);
            }
            throw new RuntimeException("Exception while sorting vertices.");
        }
    }
}

