/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.reader;

import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.GraphLayout;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.Definition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.ElementDefinition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.TypeDefinition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.reader.GraphLayoutReader;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.GreqlEvaluatorFacade;
import java.util.Collection;

public abstract class AbstractGraphLayoutReader
implements GraphLayoutReader {
    protected GraphLayout graphLayout;
    protected Definition currentDefinition;
    private GreqlEvaluatorFacade evaluator;

    public AbstractGraphLayoutReader(GreqlEvaluatorFacade evaluator) {
        this.evaluator = evaluator;
        this.initilizeStates();
    }

    protected void initilizeStates() {
    }

    protected void definitionStarted(String definitionName) {
        TypeDefinition definition = null;
        definition = this.graphLayout.getTypeDefinition(definitionName);
        this.currentDefinition = definition;
        if (definition == null && this.isElementDefinition(definitionName)) {
            this.currentDefinition = new ElementDefinition(definitionName);
            this.graphLayout.add(this.currentDefinition);
        }
    }

    private boolean isElementDefinition(String text) {
        return this.containsGraphElements(this.evaluator.evaluate(text));
    }

    private boolean containsGraphElements(Object result) {
        if (result instanceof GraphElement) {
            return true;
        }
        if (result instanceof Collection) {
            for (Object o : (Collection)result) {
                if (!(o instanceof GraphElement)) continue;
                return true;
            }
        }
        return false;
    }

    protected void definitionEnded() {
        this.currentDefinition = null;
    }

    protected boolean isGlobalVariable(String string) {
        return string.charAt(0) == '@';
    }

    public void processGlobalVariable(String name, String value) {
        if (!this.isGlobalVariable(name)) {
            throw new RuntimeException("Field " + name + " does not have a '@' as prefix. Delete it or add an @.");
        }
        this.graphLayout.getGlobalVariables().put(this.removeFirstChar(name), value);
    }

    public void processDefinitionAttribute(String name, String value) {
        this.currentDefinition.setAttribute(name, value);
    }

    private String removeFirstChar(String name) {
        return name.substring(1, name.length());
    }
}

