/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition;

import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.Definition;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDefinition
implements Definition {
    protected Map<String, String> attributes = new HashMap<String, String>();

    protected AbstractDefinition() {
    }

    public AbstractDefinition(AbstractDefinition definition) {
        this();
        this.attributes = new HashMap<String, String>(definition.attributes);
    }

    @Override
    public String getAttributeValue(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    @Override
    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public void validateAttributeNames(Set<String> allowedNames) {
        for (String attributeName : this.attributes.keySet()) {
            allowedNames.contains(attributeName);
        }
    }

    @Override
    public void addNonExistingAttributes(Definition spec) {
        for (String name : spec.getAttributeNames()) {
            if (this.attributes.containsKey(name)) continue;
            this.attributes.put(name, spec.getAttributeValue(name));
        }
    }

    @Override
    public void overwriteAttributes(Definition spec) {
        for (String name : spec.getAttributeNames()) {
            this.attributes.put(name, spec.getAttributeValue(name));
        }
    }

    @Override
    public abstract Definition clone();
}

