/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.greqlgui;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.utilities.greqlgui.GreqlGui;
import de.uni_koblenz.jgralab.utilities.gui.xdot.XDotPanel;
import de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizLayouter;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizOutputFormat;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizProgram;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class GraphViewer
extends JDialog {
    private GreqlGui gui;
    private Graph graph;
    private String queryText;
    private InputStream xdotInputStream;
    private XDotPanel xdPanel;
    private JScrollPane graphScrollPane;

    public GraphViewer(GreqlGui gui, Graph graph, String queryText) {
        super((Frame)gui, gui.getMessage("GraphViewer.Title"));
        this.gui = gui;
        this.queryText = queryText;
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.graph = graph;
        Tg2Dot t2d = new Tg2Dot();
        t2d.setGraph(graph);
        t2d.setReversedEdges(true);
        t2d.setPrintIncidenceNumbers(true);
        try {
            this.xdotInputStream = t2d.convertToGraphVizStream(new GraphVizProgram().layouter(GraphVizLayouter.DOT).outputFormat(GraphVizOutputFormat.XDOT));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.add(this.createContent(), "Center");
        this.pack();
    }

    protected Component createContent() {
        JPanel pnl = new JPanel();
        pnl.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        pnl.setLayout(new BorderLayout());
        try {
            this.xdPanel = new XDotPanel(this.graph, this.xdotInputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSlider zoomSlider = new JSlider(this.xdPanel.getZoomLevelModel());
        zoomSlider.setMajorTickSpacing(16);
        zoomSlider.setPaintTicks(true);
        JButton btn = new JButton(this.gui.getMessage("GraphViewer.ZoomToFit"));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphViewer.this.xdPanel.zoomToFit(GraphViewer.this.graphScrollPane.getSize());
            }
        });
        JPanel controlPanel = new JPanel();
        controlPanel.add(btn);
        controlPanel.add(zoomSlider);
        pnl.add((Component)controlPanel, "North");
        this.xdPanel.setAutoscrolls(true);
        this.graphScrollPane = new JScrollPane(this.xdPanel);
        this.graphScrollPane.setPreferredSize(new Dimension(800, 600));
        this.graphScrollPane.setBorder(BorderFactory.createEtchedBorder(1));
        JTextArea queryArea = new JTextArea();
        queryArea.setEditable(false);
        queryArea.setLineWrap(true);
        queryArea.setWrapStyleWord(true);
        queryArea.setText(this.queryText);
        JScrollPane queryTextScrollpane = new JScrollPane(queryArea);
        queryTextScrollpane.setPreferredSize(new Dimension(100, 100));
        JSplitPane split = new JSplitPane(0, this.graphScrollPane, queryTextScrollpane);
        split.setContinuousLayout(true);
        pnl.add((Component)split, "Center");
        return pnl;
    }
}

