/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.ant;

import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.utilities.ant.DeleteGeneratedSchemaTask;
import de.uni_koblenz.jgralab.utilities.tgschema2java.TgSchema2Java;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.resources.FileResource;

public class TgSchema2JavaTask
extends Task {
    private TgSchema2Java executeObject = new TgSchema2Java();
    private Set<String> schemaLocation;
    private String commitPath;

    public TgSchema2JavaTask() {
        this.executeObject.setTypeSpecificMethodSupport(true);
        this.schemaLocation = new HashSet<String>();
    }

    public void setSourcePath(String value) {
        this.commitPath = value;
    }

    public void setSchemaFile(String value) {
        this.schemaLocation.add(value);
    }

    public void setWithoutTypes(String value) {
        String v = value.toLowerCase();
        if (v.equals("true") || v.equals("yes")) {
            this.executeObject.setTypeSpecificMethodSupport(false);
        } else if (!v.equals("false") && !v.equals("no")) {
            throw new BuildException("Invalid value for boolean field: " + value);
        }
    }

    public void addConfiguredFileset(FileSet files) {
        for (Object current : files) {
            if (!(current instanceof FileResource)) continue;
            File currentFile = ((FileResource)current).getFile();
            this.schemaLocation.add(currentFile.getAbsolutePath());
        }
    }

    public void execute() {
        if (this.schemaLocation == null) {
            throw new BuildException("Schema file not set.");
        }
        if (this.commitPath == null) {
            throw new BuildException("Source path not set.");
        }
        this.executeObject.setCommitPath(this.commitPath);
        try {
            for (String currentTG : this.schemaLocation) {
                this.executeObject.loadSchema(currentTG);
                DeleteGeneratedSchemaTask.deleteGeneratedSchema(this.commitPath, this.executeObject.getSchema());
                this.executeObject.execute();
            }
        }
        catch (GraphIOException e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }
}

