/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.StringDomain;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.impl.BasicDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import java.io.IOException;

public final class StringDomainImpl
extends BasicDomainImpl
implements StringDomain {
    StringDomainImpl(Schema schema) {
        super("String", (PackageImpl)schema.getDefaultPackage());
    }

    @Override
    public String getJavaAttributeImplementationTypeName(String schemaRootPackagePrefix) {
        return "java.lang.String";
    }

    @Override
    public String getJavaClassName(String schemaRootPackagePrefix) {
        return this.getJavaAttributeImplementationTypeName(schemaRootPackagePrefix);
    }

    @Override
    public CodeBlock getReadMethod(String schemaPrefix, String variableName, String graphIoVariableName) {
        return new CodeSnippet(variableName + " = " + graphIoVariableName + ".matchUtfString();");
    }

    @Override
    public String getTGTypeName(Package pkg) {
        return "String";
    }

    @Override
    public CodeBlock getWriteMethod(String schemaRootPackagePrefix, String variableName, String graphIoVariableName) {
        return new CodeSnippet(graphIoVariableName + ".writeUtfString(" + variableName + ");");
    }

    @Override
    public CodeBlock getTransactionReadMethod(String schemaPrefix, String variableName, String graphIoVariableName) {
        return new CodeSnippet(this.getJavaAttributeImplementationTypeName(schemaPrefix) + " " + variableName + " = " + graphIoVariableName + ".matchUtfString();");
    }

    @Override
    public CodeBlock getTransactionWriteMethod(String schemaRootPackagePrefix, String variableName, String graphIoVariableName) {
        return this.getWriteMethod(schemaRootPackagePrefix, "get" + CodeGenerator.camelCase(variableName) + "()", graphIoVariableName);
    }

    @Override
    public String getTransactionJavaAttributeImplementationTypeName(String schemaRootPackagePrefix) {
        return this.getJavaAttributeImplementationTypeName(schemaRootPackagePrefix);
    }

    @Override
    public String getTransactionJavaClassName(String schemaRootPackagePrefix) {
        return "java.lang.String";
    }

    @Override
    public String getVersionedClass(String schemaRootPackagePrefix) {
        return "de.uni_koblenz.jgralab.impl.trans.VersionedReferenceImpl<" + this.getTransactionJavaAttributeImplementationTypeName(schemaRootPackagePrefix) + ">";
    }

    @Override
    public String getInitialValue() {
        return "null";
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public Object parseGenericAttribute(GraphIO io) throws GraphIOException {
        String result = io.matchUtfString();
        return result;
    }

    @Override
    public void serializeGenericAttribute(GraphIO io, Object data) throws IOException {
        io.writeUtfString((String)data);
    }

    @Override
    public boolean isConformValue(Object value) {
        return value == null || String.class.isInstance(value);
    }
}

