/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphFactory;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.impl.generic.GenericGraphFactoryImpl;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.BooleanDomain;
import de.uni_koblenz.jgralab.schema.CompositeDomain;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.DoubleDomain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.IntegerDomain;
import de.uni_koblenz.jgralab.schema.ListDomain;
import de.uni_koblenz.jgralab.schema.LongDomain;
import de.uni_koblenz.jgralab.schema.MapDomain;
import de.uni_koblenz.jgralab.schema.NamedElement;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.SetDomain;
import de.uni_koblenz.jgralab.schema.StringDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.AttributedElementCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.EdgeCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.EnumCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.GraphCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.GraphFactoryGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.RecordCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.ReversedEdgeCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.SchemaCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.VertexCodeGenerator;
import de.uni_koblenz.jgralab.schema.exception.SchemaClassAccessException;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.BooleanDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.DirectedAcyclicGraph;
import de.uni_koblenz.jgralab.schema.impl.DoubleDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.EnumDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.GraphClassImpl;
import de.uni_koblenz.jgralab.schema.impl.IntegerDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.ListDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.LongDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.MapDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import de.uni_koblenz.jgralab.schema.impl.RecordDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.SetDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.StringDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.compilation.ClassFileManager;
import de.uni_koblenz.jgralab.schema.impl.compilation.InMemoryJavaSourceFile;
import de.uni_koblenz.jgralab.schema.impl.compilation.ManagableArtifact;
import de.uni_koblenz.jgralab.schema.impl.compilation.SchemaClassManager;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.pcollections.ArrayPSet;
import org.pcollections.PSet;

public class SchemaImpl
implements Schema,
ManagableArtifact {
    private SchemaClassManager schemaClassManager = null;
    static final Class<?>[] GRAPHCLASS_CREATE_SIGNATURE = new Class[]{ImplementationType.class, String.class, Integer.TYPE, Integer.TYPE};
    public static final String IMPL_PACKAGE_NAME = "impl";
    public static final String IMPLSTDPACKAGENAME = "impl.std";
    public static final String IMPLTRANSPACKAGENAME = "impl.trans";
    public static final String IMPLDATABASEPACKAGENAME = "impl.db";
    static final Class<?>[] VERTEX_CLASS_CREATE_SIGNATURE = new Class[]{Integer.TYPE};
    private boolean allowLowercaseEnumConstants = true;
    private PackageImpl defaultPackage;
    Map<String, Domain> domains = new HashMap<String, Domain>();
    private DirectedAcyclicGraph<Domain> domainsDag = new DirectedAcyclicGraph();
    private int version;
    private boolean finished = false;
    private GraphClassImpl graphClass;
    private String name;
    private String packagePrefix;
    Map<String, PackageImpl> packages = new TreeMap<String, PackageImpl>();
    private String qualifiedName;
    Map<String, NamedElement> namedElements = new TreeMap<String, NamedElement>();
    private BooleanDomain booleanDomain;
    private DoubleDomain doubleDomain;
    private IntegerDomain integerDomain;
    private LongDomain longDomain;
    private StringDomain stringDomain;
    private static final Pattern SCHEMA_NAME_PATTERN = Pattern.compile("^\\p{Upper}(\\p{Alnum}|[_])*\\p{Alnum}$");
    private static final Pattern PACKAGE_PREFIX_PATTERN = Pattern.compile("^\\p{Lower}\\w*(\\.\\p{Lower}\\w*)*$");
    private int graphElementClassCount = 0;
    private int incidenceClassCount = 0;

    public SchemaClassManager getSchemaClassManager() {
        return this.schemaClassManager;
    }

    public SchemaImpl(String name, String packagePrefix) {
        if (!SCHEMA_NAME_PATTERN.matcher(name).matches()) {
            throw new SchemaException("Invalid schema name '" + name + "'.\n" + "The name must not be empty.\n" + "The name must start with a capital letter.\n" + "Any following character must be alphanumeric and/or a '_' character.\n" + "The name must end with an alphanumeric character.");
        }
        if (!PACKAGE_PREFIX_PATTERN.matcher(packagePrefix).matches()) {
            throw new SchemaException("Invalid schema package prefix '" + packagePrefix + "'.\n" + "The packagePrefix must not be empty.\n" + "The package prefix must start with a small letter.\n" + "The first character after each '.' must be a small letter.\n" + "Following characters may be alphanumeric and/or '_' characters.\n" + "The last character before a '.' and the end of the line must be an alphanumeric character.");
        }
        this.name = name;
        this.packagePrefix = packagePrefix;
        this.qualifiedName = packagePrefix + "." + name;
        this.schemaClassManager = SchemaClassManager.instance(this.qualifiedName);
        this.defaultPackage = PackageImpl.createDefaultPackage(this);
        this.createBooleanDomain();
        this.createDoubleDomain();
        this.createIntegerDomain();
        this.createLongDomain();
        this.createStringDomain();
    }

    void addDomain(Domain dom) {
        if (this.domains.containsKey(dom.getQualifiedName())) {
            throw new SchemaException("Duplicate Domain '" + dom.getQualifiedName() + "'");
        }
        this.domains.put(dom.getQualifiedName(), dom);
        this.domainsDag.createNode(dom);
    }

    void addPackage(PackageImpl pkg) {
        if (this.packages.containsKey(pkg.getQualifiedName())) {
            throw new SchemaException("Duplicate Package '" + pkg.getQualifiedName() + "'");
        }
        this.packages.put(pkg.getQualifiedName(), pkg);
    }

    void addNamedElement(NamedElement namedElement) {
        if (this.namedElements.containsKey(namedElement.getQualifiedName())) {
            throw new SchemaException("Duplicate NamedElement '" + namedElement.getQualifiedName() + "'");
        }
        this.namedElements.put(namedElement.getQualifiedName(), namedElement);
        if (!(namedElement instanceof AttributedElementClass)) {
            return;
        }
    }

    @Override
    public NamedElement getNamedElement(String qualifiedName) {
        return this.namedElements.get(qualifiedName);
    }

    @Override
    public boolean allowsLowercaseEnumConstants() {
        return this.allowLowercaseEnumConstants;
    }

    private Vector<InMemoryJavaSourceFile> createClasses(CodeGeneratorConfiguration config) {
        AttributedElementCodeGenerator codeGen;
        Vector<InMemoryJavaSourceFile> javaSources = new Vector<InMemoryJavaSourceFile>();
        GraphCodeGenerator graphCodeGenerator = new GraphCodeGenerator(this.graphClass, this.packagePrefix, this.name, config);
        javaSources.addAll(graphCodeGenerator.createJavaSources());
        for (VertexClass vertexClass : this.graphClass.getVertexClasses()) {
            codeGen = new VertexCodeGenerator(vertexClass, this.packagePrefix, config);
            javaSources.addAll(codeGen.createJavaSources());
        }
        for (EdgeClass edgeClass : this.graphClass.getEdgeClasses()) {
            codeGen = new EdgeCodeGenerator(edgeClass, this.packagePrefix, config);
            javaSources.addAll(codeGen.createJavaSources());
            if (edgeClass.isAbstract()) continue;
            codeGen = new ReversedEdgeCodeGenerator(edgeClass, this.packagePrefix, config);
            javaSources.addAll(codeGen.createJavaSources());
        }
        for (Domain domain : this.getRecordDomains()) {
            RecordCodeGenerator rcode = new RecordCodeGenerator((RecordDomain)domain, this.packagePrefix, config);
            javaSources.addAll(rcode.createJavaSources());
        }
        for (Domain domain : this.getEnumDomains()) {
            EnumCodeGenerator ecode = new EnumCodeGenerator((EnumDomain)domain, this.packagePrefix);
            javaSources.addAll(ecode.createJavaSources());
        }
        return javaSources;
    }

    @Override
    public void createJAR(CodeGeneratorConfiguration config, String jarFileName) throws IOException, GraphIOException {
        this.assertFinished();
        File tmpFile = File.createTempFile("jar-creation", "tmp");
        tmpFile.deleteOnExit();
        File tmpDir = new File(tmpFile.getParent());
        File schemaDir = new File(tmpDir + File.separator + this.getName());
        if (!schemaDir.mkdir()) {
            System.err.println("Couldn't create " + schemaDir);
            return;
        }
        System.out.println("Committing schema classes to " + schemaDir);
        this.commit(schemaDir.getAbsolutePath(), config, new ConsoleProgressFunction("Committing"));
        this.compileClasses(schemaDir);
        Process proc = Runtime.getRuntime().exec("jar cf " + jarFileName + " -C " + schemaDir.getAbsolutePath() + " .");
        try {
            proc.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.deleteRecursively(schemaDir);
    }

    private void deleteRecursively(File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.deleteRecursively(f);
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    private void compileClasses(File schemaDir) throws IOException {
        JavaCompiler c = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = c.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(this.getJavaFiles(schemaDir));
        c.getTask(null, fileManager, null, null, null, compilationUnits).call();
        fileManager.close();
    }

    private List<File> getJavaFiles(File schemaDir) {
        LinkedList<File> sources = new LinkedList<File>();
        for (File f : schemaDir.listFiles()) {
            if (f.isDirectory()) {
                sources.addAll(this.getJavaFiles(f));
                continue;
            }
            if (!f.getName().endsWith(".java")) continue;
            sources.add(f);
        }
        return sources;
    }

    @Override
    public Vector<InMemoryJavaSourceFile> commit(CodeGeneratorConfiguration config) {
        this.assertFinished();
        Vector<InMemoryJavaSourceFile> javaSources = new Vector<InMemoryJavaSourceFile>();
        SchemaCodeGenerator schemaCodeGenerator = new SchemaCodeGenerator(this, this.packagePrefix, config);
        javaSources.addAll(schemaCodeGenerator.createJavaSources());
        GraphFactoryGenerator factoryCodeGenerator = new GraphFactoryGenerator(this, this.packagePrefix, config);
        javaSources.addAll(factoryCodeGenerator.createJavaSources());
        javaSources.addAll(this.createClasses(config));
        return javaSources;
    }

    private void createFiles(CodeGeneratorConfiguration config, String pathPrefix, ProgressFunction progressFunction, long schemaElements, long currentCount, long interval) throws GraphIOException {
        AttributedElementCodeGenerator codeGen;
        GraphCodeGenerator graphCodeGenerator = new GraphCodeGenerator(this.graphClass, this.packagePrefix, this.name, config);
        graphCodeGenerator.createFiles(pathPrefix);
        for (VertexClass vertexClass : this.graphClass.getVertexClasses()) {
            codeGen = new VertexCodeGenerator(vertexClass, this.packagePrefix, config);
            codeGen.createFiles(pathPrefix);
            if (progressFunction == null) continue;
            ++schemaElements;
            if (++currentCount != interval) continue;
            progressFunction.progress(schemaElements);
            currentCount = 0L;
        }
        for (EdgeClass edgeClass : this.graphClass.getEdgeClasses()) {
            codeGen = new EdgeCodeGenerator(edgeClass, this.packagePrefix, config);
            codeGen.createFiles(pathPrefix);
            if (!edgeClass.isAbstract()) {
                codeGen = new ReversedEdgeCodeGenerator(edgeClass, this.packagePrefix, config);
                codeGen.createFiles(pathPrefix);
            }
            if (progressFunction == null) continue;
            ++schemaElements;
            if (++currentCount != interval) continue;
            progressFunction.progress(schemaElements);
            currentCount = 0L;
        }
        for (Domain domain : this.getRecordDomains()) {
            RecordCodeGenerator rcode = new RecordCodeGenerator((RecordDomain)domain, this.packagePrefix, config);
            rcode.createFiles(pathPrefix);
            if (progressFunction == null) continue;
            ++schemaElements;
            if (++currentCount != interval) continue;
            progressFunction.progress(schemaElements);
            currentCount = 0L;
        }
        for (Domain domain : this.getEnumDomains()) {
            EnumCodeGenerator ecode = new EnumCodeGenerator((EnumDomain)domain, this.packagePrefix);
            ecode.createFiles(pathPrefix);
        }
        if (progressFunction != null) {
            ++schemaElements;
            if (++currentCount == interval) {
                progressFunction.progress(schemaElements);
                currentCount = 0L;
            }
        }
    }

    @Override
    public void commit(String pathPrefix, CodeGeneratorConfiguration config) throws GraphIOException {
        this.assertFinished();
        this.commit(pathPrefix, config, null);
    }

    @Override
    public void commit(String pathPrefix, CodeGeneratorConfiguration config, ProgressFunction progressFunction) throws GraphIOException {
        this.assertFinished();
        long schemaElements = 0L;
        long currentCount = 0L;
        long interval = 1L;
        if (progressFunction != null) {
            int elements = this.getNumberOfElements();
            progressFunction.init(elements);
            interval = progressFunction.getUpdateInterval();
        }
        if (!pathPrefix.endsWith(File.separator)) {
            pathPrefix = pathPrefix + File.separator;
        }
        SchemaCodeGenerator schemaCodeGenerator = new SchemaCodeGenerator(this, this.packagePrefix, config);
        schemaCodeGenerator.createFiles(pathPrefix);
        GraphFactoryGenerator factoryCodeGenerator = new GraphFactoryGenerator(this, this.packagePrefix, config);
        factoryCodeGenerator.createFiles(pathPrefix);
        if (this.graphClass.getQualifiedName().equals("Graph")) {
            throw new SchemaException("The defined GraphClass must not be named Graph!");
        }
        this.createFiles(config, pathPrefix, progressFunction, schemaElements, currentCount, interval);
        if (progressFunction != null) {
            progressFunction.finished();
        }
    }

    @Override
    public int compareTo(Schema other) {
        return this.qualifiedName.compareTo(other.getQualifiedName());
    }

    @Override
    public void compile(CodeGeneratorConfiguration config) {
        this.assertFinished();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new SchemaException("Cannot compile schema " + this.qualifiedName + ". Most probably you use a JRE instead of a JDK. " + "The JRE does not provide a compiler.");
        }
        StandardJavaFileManager jfm = compiler.getStandardFileManager(null, null, null);
        ClassFileManager manager = new ClassFileManager(this, jfm);
        Vector<InMemoryJavaSourceFile> javaSources = this.commit(config);
        compiler.getTask(null, manager, null, null, null, javaSources).call();
    }

    @Override
    public EnumDomain createEnumDomain(String qualifiedName) {
        return this.createEnumDomain(qualifiedName, new ArrayList<String>());
    }

    @Override
    public EnumDomain createEnumDomain(String qualifiedName, List<String> enumComponents) {
        this.assertNotFinished();
        String[] components = SchemaImpl.splitQualifiedName(qualifiedName);
        PackageImpl parent = this.createPackageWithParents(components[0]);
        String simpleName = components[1];
        EnumDomainImpl ed = new EnumDomainImpl(simpleName, parent, enumComponents);
        return ed;
    }

    @Override
    public EnumDomain createEnumDomain(String qualifiedName, String ... enumComponents) {
        return this.createEnumDomain(qualifiedName, Arrays.asList(enumComponents));
    }

    @Override
    public GraphClass createGraphClass(String simpleName) {
        this.assertNotFinished();
        if (this.graphClass != null) {
            throw new SchemaException("Only one GraphClass (except DefaultGraphClass) is allowed in a Schema! '" + this.graphClass.getQualifiedName() + "' is already there.");
        }
        if (simpleName.contains(".")) {
            throw new SchemaException("A GraphClass must always be in the default package!");
        }
        GraphClassImpl gc = new GraphClassImpl(simpleName, this);
        gc.initializeDefaultVertexClass();
        gc.initializeDefaultEdgeClass();
        gc.initializeTemporaryVertexClass();
        gc.initializeTemporaryEdgeClass();
        return gc;
    }

    private BooleanDomain createBooleanDomain() {
        this.assertNotFinished();
        if (this.booleanDomain == null) {
            this.booleanDomain = new BooleanDomainImpl(this);
        }
        return this.booleanDomain;
    }

    private DoubleDomain createDoubleDomain() {
        this.assertNotFinished();
        if (this.doubleDomain == null) {
            this.doubleDomain = new DoubleDomainImpl(this);
        }
        return this.doubleDomain;
    }

    private IntegerDomain createIntegerDomain() {
        this.assertNotFinished();
        if (this.integerDomain == null) {
            this.integerDomain = new IntegerDomainImpl(this);
        }
        return this.integerDomain;
    }

    private LongDomain createLongDomain() {
        this.assertNotFinished();
        if (this.longDomain == null) {
            this.longDomain = new LongDomainImpl(this);
        }
        return this.longDomain;
    }

    private StringDomain createStringDomain() {
        this.assertNotFinished();
        if (this.stringDomain == null) {
            this.stringDomain = new StringDomainImpl(this);
        }
        return this.stringDomain;
    }

    @Override
    public ListDomain createListDomain(Domain baseDomain) {
        this.assertNotFinished();
        String qn = "List<" + baseDomain.getQualifiedName() + ">";
        if (this.domains.containsKey(qn)) {
            return (ListDomain)this.domains.get(qn);
        }
        return new ListDomainImpl(this, baseDomain);
    }

    @Override
    public MapDomain createMapDomain(Domain keyDomain, Domain valueDomain) {
        this.assertNotFinished();
        String qn = "Map<" + keyDomain.getQualifiedName() + ", " + valueDomain.getQualifiedName() + ">";
        if (this.domains.containsKey(qn)) {
            return (MapDomain)this.domains.get(qn);
        }
        return new MapDomainImpl(this, keyDomain, valueDomain);
    }

    PackageImpl createPackage(String sn, PackageImpl parentPkg) {
        this.assertNotFinished();
        return new PackageImpl(sn, parentPkg, this);
    }

    PackageImpl createPackageWithParents(String qn) {
        this.assertNotFinished();
        if (this.packages.containsKey(qn)) {
            return this.packages.get(qn);
        }
        String[] components = SchemaImpl.splitQualifiedName(qn);
        String parent = components[0];
        String pkgSimpleName = components[1];
        assert (!pkgSimpleName.contains(".")) : "The package simple name '" + pkgSimpleName + "' must not contain a dot!";
        PackageImpl currentParent = this.defaultPackage;
        String currentPkgQName = "";
        if (!this.packages.containsKey(parent)) {
            for (String component : parent.split("\\.")) {
                currentPkgQName = currentParent != this.defaultPackage ? currentParent.getQualifiedName() + "." + component : component;
                currentParent = this.packages.containsKey(currentPkgQName) ? this.packages.get(currentPkgQName) : this.createPackage(component, currentParent);
            }
        } else {
            currentParent = this.packages.get(parent);
        }
        assert (currentParent.getQualifiedName().equals(parent)) : "Something went wrong when creating a package with parents: parent should be \"" + parent + "\" but created was \"" + currentParent.getQualifiedName() + "\".";
        assert (!currentParent.getQualifiedName().isEmpty() || currentParent == this.defaultPackage) : "The parent package of package '" + pkgSimpleName + "' is empty, but not the default package.";
        return this.createPackage(pkgSimpleName, currentParent);
    }

    public static String[] splitQualifiedName(String qualifiedName) {
        int lastIndex = qualifiedName.lastIndexOf(46);
        String[] components = new String[2];
        if (lastIndex == -1) {
            components[0] = "";
            components[1] = qualifiedName;
        } else {
            components[0] = qualifiedName.substring(0, lastIndex);
            if (components[0].length() >= 1 && components[0].charAt(0) == '.') {
                components[0] = components[0].substring(1);
            }
            components[1] = qualifiedName.substring(lastIndex + 1);
        }
        return components;
    }

    @Override
    public RecordDomain createRecordDomain(String qualifiedName) {
        return this.createRecordDomain(qualifiedName, null);
    }

    @Override
    public RecordDomain createRecordDomain(String qualifiedName, Collection<RecordDomain.RecordComponent> recordComponents) {
        this.assertNotFinished();
        String[] components = SchemaImpl.splitQualifiedName(qualifiedName);
        PackageImpl parent = this.createPackageWithParents(components[0]);
        String simpleName = components[1];
        RecordDomainImpl rd = new RecordDomainImpl(simpleName, parent, recordComponents);
        return rd;
    }

    @Override
    public SetDomain createSetDomain(Domain baseDomain) {
        this.assertNotFinished();
        String qn = "Set<" + baseDomain.getQualifiedName() + ">";
        if (this.domains.containsKey(qn)) {
            return (SetDomain)this.domains.get(qn);
        }
        return new SetDomainImpl(this, baseDomain);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof Schema)) {
            return false;
        }
        return this.qualifiedName.equals(((SchemaImpl)other).qualifiedName);
    }

    public int hashCode() {
        return this.qualifiedName.hashCode();
    }

    @Override
    public <T extends AttributedElementClass<?, ?>> T getAttributedElementClass(String qualifiedName) {
        if (this.graphClass == null) {
            return null;
        }
        if (this.graphClass.getQualifiedName().equals(qualifiedName)) {
            return (T)this.graphClass;
        }
        return (T)this.graphClass.getGraphElementClass(qualifiedName);
    }

    @Override
    public List<CompositeDomain> getCompositeDomains() {
        ArrayList<CompositeDomain> topologicalOrderList = new ArrayList<CompositeDomain>();
        for (Domain dom : this.domainsDag.getNodesInTopologicalOrder()) {
            if (!(dom instanceof CompositeDomain)) continue;
            topologicalOrderList.add((CompositeDomain)dom);
        }
        return topologicalOrderList;
    }

    private Method getCreateMethod(String className, String graphClassName, Class<?>[] signature, ImplementationType implementationType) {
        Class<? extends Graph> schemaClass = null;
        GraphElementClass<VertexClass, Vertex> aec = null;
        try {
            schemaClass = this.getGraphClassImpl(implementationType);
            if (className.equals(graphClassName)) {
                if (implementationType != ImplementationType.GENERIC) {
                    return this.getClass().getMethod("create" + graphClassName, signature);
                }
                return schemaClass.getMethod("createGraph", signature);
            }
            aec = this.graphClass.getVertexClass(className);
            if (aec == null && (aec = this.graphClass.getEdgeClass(className)) == null) {
                throw new SchemaClassAccessException("class " + className + " does not exist in schema");
            }
            if (implementationType != ImplementationType.GENERIC) {
                return schemaClass.getMethod("create" + CodeGenerator.camelCase(aec.getUniqueName()), signature);
            }
            if (signature[0].equals(VertexClass.class)) {
                return schemaClass.getMethod("createVertex", signature);
            }
            return schemaClass.getMethod("createEdge", signature);
        }
        catch (SecurityException e) {
            throw new SchemaClassAccessException("can't find create method in '" + schemaClass.getName() + "' for '" + aec.getUniqueName() + "'", e);
        }
        catch (NoSuchMethodException e) {
            throw new SchemaClassAccessException("can't find create method in '" + schemaClass.getName() + "' for '" + aec.getUniqueName() + "'", e);
        }
    }

    @Override
    public Package getDefaultPackage() {
        return this.defaultPackage;
    }

    @Override
    public Domain getDomain(String domainName) {
        return this.domains.get(domainName);
    }

    @Override
    public PSet<Domain> getDomains() {
        return ArrayPSet.empty().plusAll(this.domains.values());
    }

    void addDomainDependency(Domain composite, Domain base) {
        this.domainsDag.createEdge(base, composite);
    }

    @Override
    public Method getEdgeCreateMethod(String edgeClassName, ImplementationType implementationType) {
        Object aec = this.getAttributedElementClass(edgeClassName);
        if (aec == null || !(aec instanceof EdgeClass)) {
            throw new SchemaException("There's no EdgeClass with qualified name " + edgeClassName + "!");
        }
        EdgeClass ec = (EdgeClass)aec;
        String methodName = "create" + CodeGenerator.camelCase(ec.getUniqueName());
        Class<? extends Graph> schemaClass = this.getGraphClassImpl(implementationType);
        if (implementationType != ImplementationType.GENERIC) {
            for (Method m : schemaClass.getMethods()) {
                if (!m.getName().equals(methodName) || m.getParameterTypes().length != 3) continue;
                return m;
            }
        } else {
            try {
                return schemaClass.getMethod("createEdge", EdgeClass.class, Integer.TYPE, Vertex.class, Vertex.class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        throw new SchemaClassAccessException("can't find create method '" + methodName + "' in '" + schemaClass.getName() + "' for '" + ec.getUniqueName() + "'");
    }

    @Override
    public List<EnumDomain> getEnumDomains() {
        ArrayList<EnumDomain> enumList = new ArrayList<EnumDomain>();
        for (Domain dl : this.domains.values()) {
            if (!(dl instanceof EnumDomain)) continue;
            enumList.add((EnumDomain)dl);
        }
        return enumList;
    }

    @Override
    public BooleanDomain getBooleanDomain() {
        return this.booleanDomain;
    }

    @Override
    public DoubleDomain getDoubleDomain() {
        return this.doubleDomain;
    }

    @Override
    public IntegerDomain getIntegerDomain() {
        return this.integerDomain;
    }

    @Override
    public LongDomain getLongDomain() {
        return this.longDomain;
    }

    @Override
    public StringDomain getStringDomain() {
        return this.stringDomain;
    }

    @Override
    public GraphClass getGraphClass() {
        return this.graphClass;
    }

    private Class<? extends Graph> getGraphClassImpl(ImplementationType implementationType) {
        String implClassName = this.packagePrefix + ".";
        switch (implementationType) {
            case STANDARD: {
                implClassName = implClassName + IMPLSTDPACKAGENAME;
                break;
            }
            case GENERIC: {
                implClassName = "de.uni_koblenz.jgralab.impl.generic";
                break;
            }
            default: {
                throw new SchemaException("Implementation type " + (Object)((Object)implementationType) + " not supported yet.");
            }
        }
        if (implementationType != ImplementationType.GENERIC) {
            Class<?> schemaClass;
            implClassName = implClassName + "." + this.graphClass.getSimpleName() + "Impl";
            try {
                schemaClass = Class.forName(implClassName, true, SchemaClassManager.instance(this.qualifiedName));
            }
            catch (ClassNotFoundException e) {
                throw new SchemaClassAccessException("can't load implementation class '" + implClassName + "'", e);
            }
            return schemaClass;
        }
        implClassName = implClassName + ".GenericGraphImpl";
        try {
            return Class.forName(implClassName);
        }
        catch (ClassNotFoundException e) {
            throw new SchemaClassAccessException("can't load implementation class '" + implClassName + "'", e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    private int getNumberOfElements() {
        return this.graphClass.getGraphElementClasses().size() + 1;
    }

    @Override
    public Package getPackage(String packageName) {
        return this.packages.get(packageName);
    }

    @Override
    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public List<RecordDomain> getRecordDomains() {
        ArrayList<RecordDomain> recordList = new ArrayList<RecordDomain>();
        for (Domain dl : this.domains.values()) {
            if (!(dl instanceof RecordDomain)) continue;
            recordList.add((RecordDomain)dl);
        }
        return recordList;
    }

    @Override
    public Method getVertexCreateMethod(String vertexClassName, ImplementationType implementationType) {
        if (implementationType != ImplementationType.GENERIC) {
            return this.getCreateMethod(vertexClassName, this.graphClass.getSimpleName(), VERTEX_CLASS_CREATE_SIGNATURE, implementationType);
        }
        return this.getCreateMethod(vertexClassName, this.graphClass.getSimpleName(), new Class[]{VertexClass.class, Integer.TYPE}, implementationType);
    }

    @Override
    public boolean isValidEnumConstant(String name) {
        if (name.isEmpty()) {
            return false;
        }
        if (!this.allowLowercaseEnumConstants && !name.equals(name.toUpperCase())) {
            return false;
        }
        if (RESERVED_JAVA_WORDS.contains(name)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (char c : name.toCharArray()) {
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean knows(String qn) {
        return this.namedElements.containsKey(qn) || this.getQualifiedName().equals(qn);
    }

    @Override
    public void setAllowLowercaseEnumConstants(boolean allowLowercaseEnumConstants) {
        this.allowLowercaseEnumConstants = allowLowercaseEnumConstants;
    }

    void setGraphClass(GraphClassImpl gc) {
        if (this.graphClass != null) {
            throw new SchemaException("A GraphClass named '" + this.graphClass.getQualifiedName() + "' already exists in this Schema!");
        }
        this.graphClass = gc;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    @Override
    public String toTGString() {
        String schemaDefinition = null;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        try {
            GraphIO.saveSchemaToStream(this, out);
            out.close();
            byteOut.close();
            schemaDefinition = new String(byteOut.toByteArray());
        }
        catch (GraphIOException e) {
            throw new SchemaException(e);
        }
        catch (IOException e) {
            throw new SchemaException(e);
        }
        return schemaDefinition;
    }

    @Override
    public String getFileName() {
        return this.qualifiedName.replace('.', File.separatorChar);
    }

    @Override
    public String getPathName() {
        return this.packagePrefix.replace('.', File.separatorChar);
    }

    @Override
    public GraphFactory createDefaultGraphFactory(ImplementationType implementationType) {
        this.assertFinished();
        if (implementationType != ImplementationType.GENERIC) {
            throw new SchemaException("Base implementation can't create a GraphFactory for implementation type " + (Object)((Object)implementationType) + ". Only GENERIC is supported.");
        }
        return new GenericGraphFactoryImpl(this);
    }

    @Override
    public Graph createGraph(ImplementationType implementationType) {
        return this.createGraph(implementationType, null, 100, 100);
    }

    @Override
    public Graph createGraph(ImplementationType implementationType, String id, int vMax, int eMax) {
        this.assertFinished();
        GraphFactory factory = this.createDefaultGraphFactory(implementationType);
        return factory.createGraph(this.getGraphClass(), id, vMax, eMax);
    }

    protected void assertFinished() {
        if (!this.finished) {
            throw new SchemaException("Schema must be finished.");
        }
    }

    protected void assertNotFinished() {
        if (this.finished) {
            throw new SchemaException("No changes allowed in a finished Schema.");
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean finish() {
        if (this.finished) {
            return false;
        }
        if (this.graphClass == null) {
            throw new SchemaException("Can't finish a schema without a GraphClass. Create a GraphClass first!");
        }
        this.domainsDag.finish();
        this.graphClass.finish();
        this.finished = true;
        ++this.version;
        return true;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean reopen() {
        if (!this.finished) {
            return false;
        }
        this.domainsDag.reopen();
        this.graphClass.reopen();
        this.finished = false;
        return true;
    }

    @Override
    public void save(String filename) throws GraphIOException {
        GraphIO.saveSchemaToFile(this, filename);
    }

    @Override
    public void save(DataOutputStream out) throws GraphIOException {
        GraphIO.saveSchemaToStream(this, out);
    }

    protected int getNextGraphElementClassId() {
        return this.graphElementClassCount++;
    }

    @Override
    public int getGraphElementClassCount() {
        return this.graphElementClassCount;
    }

    public int getNextIncidenceClassId() {
        return this.incidenceClassCount++;
    }

    @Override
    public int getIncidenceClassCount() {
        return this.incidenceClassCount;
    }

    @Override
    public String getManagedName() {
        return this.qualifiedName;
    }
}

