/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.ListDomain;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.impl.CollectionDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.pcollections.PVector;

public final class ListDomainImpl
extends CollectionDomainImpl
implements ListDomain {
    public static Set<Object> toSet(List<Object> aList) {
        return new HashSet<Object>(aList);
    }

    ListDomainImpl(Schema schema, Domain aBaseDomain) {
        super("List<" + aBaseDomain.getTGTypeName(schema.getDefaultPackage()) + ">", (PackageImpl)schema.getDefaultPackage(), aBaseDomain);
    }

    @Override
    public String getJavaAttributeImplementationTypeName(String schemaRootPackagePrefix) {
        return "org.pcollections.PVector<" + this.baseDomain.getJavaClassName(schemaRootPackagePrefix) + ">";
    }

    @Override
    public String getTransactionJavaAttributeImplementationTypeName(String schemaRootPackagePrefix) {
        return this.getJavaAttributeImplementationTypeName(schemaRootPackagePrefix);
    }

    @Override
    public String getJavaClassName(String schemaRootPackagePrefix) {
        return this.getJavaAttributeImplementationTypeName(schemaRootPackagePrefix);
    }

    @Override
    public String getTransactionJavaClassName(String schemaRootPackagePrefix) {
        return this.getJavaAttributeImplementationTypeName(schemaRootPackagePrefix);
    }

    @Override
    public String getVersionedClass(String schemaRootPackagePrefix) {
        return "de.uni_koblenz.jgralab.impl.trans.VersionedReferenceImpl<" + this.getTransactionJavaAttributeImplementationTypeName(schemaRootPackagePrefix) + ">";
    }

    @Override
    public CodeBlock getReadMethod(String schemaPrefix, String variableName, String graphIoVariableName) {
        CodeList code = new CodeList();
        code.setVariable("init", "");
        this.internalGetReadMethod(code, schemaPrefix, variableName, graphIoVariableName);
        return code;
    }

    @Override
    public String getTGTypeName(Package pkg) {
        return "List<" + this.baseDomain.getTGTypeName(pkg) + ">";
    }

    @Override
    public CodeBlock getWriteMethod(String schemaRootPackagePrefix, String variableName, String graphIoVariableName) {
        CodeList code = new CodeList();
        code.setVariable("name", variableName);
        this.internalGetWriteMethod(code, schemaRootPackagePrefix, variableName, graphIoVariableName);
        return code;
    }

    @Override
    public String toString() {
        return "domain List<" + this.baseDomain.toString() + ">";
    }

    private void internalGetReadMethod(CodeList code, String schemaPrefix, String variableName, String graphIoVariableName) {
        code.setVariable("name", variableName);
        code.setVariable("empty", "de.uni_koblenz.jgralab.JGraLab.vector()");
        code.setVariable("basedom", this.getBaseDomain().getJavaClassName(schemaPrefix));
        code.setVariable("basetype", this.getBaseDomain().getJavaAttributeImplementationTypeName(schemaPrefix));
        code.setVariable("io", graphIoVariableName);
        code.addNoIndent(new CodeSnippet("#init#"));
        code.addNoIndent(new CodeSnippet("if (#io#.isNextToken(\"[\")) {"));
        code.add(new CodeSnippet("org.pcollections.PVector<#basedom#> $#name# = #empty#;", "#io#.match(\"[\");", "while (!#io#.isNextToken(\"]\")) {"));
        if (this.getBaseDomain().isComposite()) {
            code.add(new CodeSnippet("\t#basetype# $#name#Element = null;"));
        } else {
            code.add(new CodeSnippet("\t#basetype# $#name#Element;"));
        }
        code.add(this.getBaseDomain().getReadMethod(schemaPrefix, "$" + variableName + "Element", graphIoVariableName), 1);
        code.add(new CodeSnippet("\t$#name# = $#name#.plus($#name#Element);", "}", "#io#.match(\"]\");", "#name# = $#name#;"));
        code.addNoIndent(new CodeSnippet("} else if (#io#.isNextToken(GraphIO.NULL_LITERAL)) {"));
        code.add(new CodeSnippet("#io#.match(); ", "#name# = null;"));
        code.addNoIndent(new CodeSnippet("} else {", "\t#name# = null;", "}"));
    }

    private void internalGetWriteMethod(CodeList code, String schemaRootPackagePrefix, String variableName, String graphIoVariableName) {
        code.setVariable("basedom", this.getBaseDomain().getJavaClassName(schemaRootPackagePrefix));
        code.setVariable("basetype", this.getBaseDomain().getJavaAttributeImplementationTypeName(schemaRootPackagePrefix));
        code.setVariable("io", graphIoVariableName);
        String element = variableName + "Element";
        element = element.replace('(', '_');
        element = element.replace(')', '_');
        code.setVariable("element", element);
        code.addNoIndent(new CodeSnippet("if (#name# != null) {"));
        code.add(new CodeSnippet("#io#.writeSpace();", "#io#.write(\"[\");", "#io#.noSpace();", "for (#basetype# #element# : #name#) {"));
        code.add(this.getBaseDomain().getWriteMethod(schemaRootPackagePrefix, code.getVariable("element"), graphIoVariableName), 1);
        code.add(new CodeSnippet("}", "#io#.write(\"]\");", "#io#.space();"));
        code.addNoIndent(new CodeSnippet("} else {"));
        code.add(new CodeSnippet(graphIoVariableName + ".writeIdentifier(GraphIO.NULL_LITERAL);"));
        code.addNoIndent(new CodeSnippet("}"));
    }

    @Override
    public CodeBlock getTransactionReadMethod(String schemaPrefix, String variableName, String graphIoVariableName) {
        CodeList code = new CodeList();
        code.setVariable("init", "org.pcollections.PVector<#basedom#> #name# = null;");
        this.internalGetReadMethod(code, schemaPrefix, variableName, graphIoVariableName);
        return code;
    }

    @Override
    public CodeBlock getTransactionWriteMethod(String schemaRootPackagePrefix, String variableName, String graphIoVariableName) {
        CodeList code = new CodeList();
        code.setVariable("name", "get" + CodeGenerator.camelCase(variableName) + "()");
        this.internalGetWriteMethod(code, schemaRootPackagePrefix, variableName, graphIoVariableName);
        return code;
    }

    @Override
    public String getInitialValue() {
        return "null";
    }

    @Override
    public Object parseGenericAttribute(GraphIO io) throws GraphIOException {
        if (io.isNextToken("[")) {
            PVector<Object> result = JGraLab.vector();
            io.match("[");
            while (!io.isNextToken("]")) {
                Object listElement = null;
                listElement = this.getBaseDomain().parseGenericAttribute(io);
                result = result.plus(listElement);
            }
            io.match("]");
            return result;
        }
        if (io.isNextToken("n")) {
            io.match();
            return null;
        }
        return null;
    }

    @Override
    public void serializeGenericAttribute(GraphIO io, Object data) throws IOException {
        if (data != null) {
            io.writeSpace();
            io.write("[");
            io.noSpace();
            for (Object value : (PVector)data) {
                this.getBaseDomain().serializeGenericAttribute(io, value);
            }
            io.write("]");
            io.space();
        } else {
            io.writeIdentifier("n");
        }
    }

    @Override
    public boolean isConformValue(Object value) {
        boolean result = true;
        if (value == null) {
            return result;
        }
        if (!(result &= value instanceof PVector)) {
            return false;
        }
        Iterator iterator = ((PVector)value).iterator();
        while (iterator.hasNext() && result) {
            result &= this.getBaseDomain().isConformValue(iterator.next());
        }
        return result;
    }
}

