/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.codegenerator.ImportCodeSnippet;
import de.uni_koblenz.jgralab.schema.impl.compilation.InMemoryJavaSourceFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public abstract class CodeGenerator {
    private final List<GenerationCycle> cycles;
    private int cycleCount = 0;
    private static Logger logger = Logger.getLogger(CodeGenerator.class.getName());
    protected CodeList rootBlock;
    private final ImportCodeSnippet imports;
    protected String schemaRootPackageName;
    protected CodeGeneratorConfiguration config;
    protected GenerationCycle currentCycle;

    public CodeGenerator(String schemaRootPackageName, String packageName, CodeGeneratorConfiguration config) {
        this.schemaRootPackageName = schemaRootPackageName;
        this.config = config;
        this.rootBlock = new CodeList(null);
        this.rootBlock.setVariable("jgPackage", "de.uni_koblenz.jgralab");
        this.rootBlock.setVariable("jgTransPackage", "de.uni_koblenz.jgralab.trans");
        this.rootBlock.setVariable("jgImplPackage", "de.uni_koblenz.jgralab.impl");
        this.rootBlock.setVariable("jgImplStdPackage", "de.uni_koblenz.jgralab.impl.std");
        this.rootBlock.setVariable("jgImplTransPackage", "de.uni_koblenz.jgralab.impl.trans");
        this.rootBlock.setVariable("jgImplDbPackage", "de.uni_koblenz.jgralab.impl.db");
        this.rootBlock.setVariable("jgSchemaPackage", "de.uni_koblenz.jgralab.schema");
        this.rootBlock.setVariable("jgSchemaImplPackage", "de.uni_koblenz.jgralab.schema.impl");
        if (packageName != null && !packageName.equals("")) {
            this.rootBlock.setVariable("schemaPackage", schemaRootPackageName + "." + packageName);
            this.rootBlock.setVariable("schemaImplStdPackage", schemaRootPackageName + ".impl.std." + packageName);
            this.rootBlock.setVariable("schemaImplTransPackage", schemaRootPackageName + ".impl.trans." + packageName);
            this.rootBlock.setVariable("schemaImplDbPackage", schemaRootPackageName + ".impl.db." + packageName);
        } else {
            this.rootBlock.setVariable("schemaPackage", schemaRootPackageName);
            this.rootBlock.setVariable("schemaImplStdPackage", schemaRootPackageName + ".impl.std");
            this.rootBlock.setVariable("schemaImplTransPackage", schemaRootPackageName + ".impl.trans");
            this.rootBlock.setVariable("schemaImplDbPackage", schemaRootPackageName + ".impl.db");
        }
        this.rootBlock.setVariable("isClassOnly", "false");
        this.rootBlock.setVariable("isImplementationClassOnly", "false");
        this.rootBlock.setVariable("isAbstractClass", "false");
        this.imports = new ImportCodeSnippet();
        this.cycles = GenerationCycle.filter(config);
    }

    protected abstract CodeBlock createHeader();

    protected abstract CodeBlock createBody();

    protected CodeBlock createFooter() {
        return new CodeSnippet("}");
    }

    public static CodeBlock createDisclaimer() {
        return new CodeSnippet("/*", " * This code was generated automatically.", " * Do NOT edit this file, changes will be lost.", " * Instead, change and commit the underlying schema.", " */");
    }

    public void writeCodeToFile(String pathPrefix, String fileName, String aPackage) throws GraphIOException {
        aPackage = aPackage.replace(".", File.separator);
        File dir = new File(pathPrefix + aPackage);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new GraphIOException("'" + dir.getAbsolutePath() + "' exists but is not a directory");
            }
        } else if (!dir.mkdirs()) {
            throw new GraphIOException("Couldn't create directory hierachy for '" + dir + "'.");
        }
        File outputFile = null;
        try {
            outputFile = new File(dir.getAbsolutePath() + File.separator + fileName);
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
            bw.write(this.rootBlock.getCode());
            bw.close();
        }
        catch (IOException e) {
            throw new GraphIOException("Unable to create file " + outputFile.getAbsolutePath(), e);
        }
    }

    public void createFiles(String pathPrefix) throws GraphIOException {
        String simpleClassName = this.rootBlock.getVariable("simpleClassName");
        String schemaPackage = this.rootBlock.getVariable("schemaPackage");
        String simpleImplClassName = this.rootBlock.getVariable("simpleImplClassName");
        String schemaImplPackage = "";
        logger.finer("createFiles(\"" + pathPrefix + "\")");
        logger.finer(" - simpleClassName=" + simpleClassName);
        logger.finer(" - schemaPackage=" + schemaPackage);
        logger.finer(" - simpleImplClassName=" + simpleImplClassName);
        this.currentCycle = this.getNextCycle();
        while (this.currentCycle != null) {
            this.createCode();
            if (this.currentCycle.isAbstract()) {
                logger.finer("Creating interface for class: " + simpleClassName);
                logger.finer("Writing file to: " + pathPrefix + "/" + schemaPackage);
            }
            if (this.currentCycle.isStdImpl()) {
                if (this.currentCycle.isStdImpl()) {
                    schemaImplPackage = this.rootBlock.getVariable("schemaImplStdPackage");
                    logger.finer(" - schemaImplStdPackage=" + schemaImplPackage);
                }
                this.writeCodeToFile(pathPrefix, simpleImplClassName + ".java", schemaImplPackage);
            } else {
                this.writeCodeToFile(pathPrefix, simpleClassName + ".java", schemaPackage);
            }
            this.currentCycle = this.getNextCycle();
        }
    }

    public void createCode() {
        this.imports.clear();
        this.rootBlock.clear();
        this.rootBlock.addNoIndent(CodeGenerator.createDisclaimer());
        this.rootBlock.addNoIndent(this.createPackageDeclaration());
        CodeBlock header = this.createHeader();
        CodeBlock body = this.createBody();
        CodeBlock footer = this.createFooter();
        this.rootBlock.addNoIndent(this.imports);
        this.rootBlock.addNoIndent(header);
        this.rootBlock.addNoIndent(body);
        this.rootBlock.addNoIndent(footer);
    }

    protected CodeBlock createPackageDeclaration() {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        if (this.rootBlock.getVariable("isClassOnly").equals("true")) {
            code.add("package #schemaPackage#;");
        } else {
            switch (this.currentCycle) {
                case ABSTRACT: {
                    code.add("package #schemaPackage#;");
                    break;
                }
                case STDIMPL: {
                    code.add("package #schemaImplStdPackage#;");
                    break;
                }
                case CLASSONLY: {
                    code.add("package #schemaPackage#;");
                }
            }
        }
        return code;
    }

    protected void addImports(String ... importPackages) {
        this.imports.add(importPackages);
    }

    public static String camelCase(String aString) {
        if (aString.length() < 1) {
            return aString;
        }
        if (aString.length() < 2) {
            return aString.toUpperCase();
        }
        return aString.substring(0, 1).toUpperCase() + aString.substring(1);
    }

    public static String stringQuote(String aString) {
        return aString.replaceAll("\"", Matcher.quoteReplacement("\\\""));
    }

    public Vector<InMemoryJavaSourceFile> createJavaSources() {
        String className = this.rootBlock.getVariable("simpleClassName");
        String implClassName = this.rootBlock.getVariable("simpleImplClassName");
        Vector<InMemoryJavaSourceFile> javaSources = new Vector<InMemoryJavaSourceFile>(2);
        this.currentCycle = this.getNextCycle();
        while (this.currentCycle != null) {
            this.createCode();
            if (this.currentCycle.isStdImpl()) {
                javaSources.add(new InMemoryJavaSourceFile(implClassName, this.rootBlock.getCode()));
            } else {
                javaSources.add(new InMemoryJavaSourceFile(className, this.rootBlock.getCode()));
            }
            this.currentCycle = this.getNextCycle();
        }
        return javaSources;
    }

    private GenerationCycle getNextCycle() {
        if (this.cycleCount >= this.cycles.size()) {
            return null;
        }
        GenerationCycle currentCycle = this.cycles.get(this.cycleCount);
        if (this.rootBlock.getVariable("isAbstractClass").equals("true") && !currentCycle.isAbstract()) {
            this.cycleCount = 0;
            return null;
        }
        if (this.rootBlock.getVariable("isImplementationClassOnly").equals("true") && currentCycle.isAbstract()) {
            ++this.cycleCount;
            return this.getNextCycle();
        }
        if (this.rootBlock.getVariable("isClassOnly").equals("true")) {
            this.cycleCount = GenerationCycle.CLASSONLY.ordinal() + 1;
            return GenerationCycle.CLASSONLY;
        }
        if (this.rootBlock.getVariable("isClassOnly").equals("false") && currentCycle.isClassOnly()) {
            this.cycleCount = 0;
            return null;
        }
        ++this.cycleCount;
        return currentCycle;
    }

    protected static enum GenerationCycle {
        ABSTRACT,
        STDIMPL,
        CLASSONLY;


        protected static List<GenerationCycle> filter(CodeGeneratorConfiguration config) {
            ArrayList<GenerationCycle> out = new ArrayList<GenerationCycle>();
            out.add(ABSTRACT);
            out.add(STDIMPL);
            out.add(CLASSONLY);
            return out;
        }

        protected boolean isStdImpl() {
            return this == STDIMPL;
        }

        protected boolean isAbstract() {
            return this == ABSTRACT;
        }

        protected boolean isClassOnly() {
            return this == CLASSONLY;
        }
    }
}

