/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public abstract class CodeBlock {
    private Map<String, String> variables = new HashMap<String, String>();
    private Stack<String> replacementStack = new Stack();
    private CodeList parent;
    protected int additionalIndent = 0;

    protected CodeBlock() {
        this(null);
    }

    protected CodeBlock(CodeList parent) {
        if (parent != null) {
            parent.add(this);
        }
    }

    public abstract String getCode(int var1);

    public abstract void clear();

    public abstract int size();

    public void addVariables(Map<String, String> map) {
        this.variables.putAll(map);
    }

    public void setVariable(String name, String value) {
        assert (name != null && name.trim().length() > 0 && name.equals(name.trim()));
        assert (value != null);
        this.variables.put(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVariable(String name) {
        if (this.replacementStack.contains(name)) {
            return name;
        }
        this.replacementStack.push(name);
        try {
            CodeBlock block = this;
            while (block != null) {
                if (block.variables.containsKey(name)) {
                    String string = this.replaceVariables(block.variables.get(name));
                    return string;
                }
                block = block.parent;
            }
            String string = "*UNDEFINED:" + name + "*";
            return string;
        }
        finally {
            this.replacementStack.pop();
        }
    }

    protected String replaceVariables(String line) {
        if (line != null) {
            StringBuilder sb = new StringBuilder(line);
            int b = sb.indexOf("#");
            while (b >= 0) {
                int e = sb.indexOf("#", b + 1);
                if (e < 0) {
                    throw new RuntimeException("missing end marker in string \"" + line + "\"");
                }
                String name = sb.substring(b + 1, e);
                String value = this.getVariable(name);
                sb.replace(b, e + 1, value);
                b = sb.indexOf("#");
            }
            line = sb.toString();
        }
        return line;
    }

    public String getCode() {
        return this.getCode(0);
    }

    public CodeList getParent() {
        return this.parent;
    }

    protected void setParent(CodeList newParent) {
        this.parent = newParent;
    }
}

