/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.PathElement;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.impl.GraphElementImpl;
import de.uni_koblenz.jgralab.impl.IncidenceIterable;
import de.uni_koblenz.jgralab.impl.InternalEdge;
import de.uni_koblenz.jgralab.impl.InternalVertex;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.impl.DirectedSchemaEdgeClass;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.pcollections.POrderedSet;
import org.pcollections.PSet;

public abstract class VertexBaseImpl
extends GraphElementImpl<VertexClass, Vertex>
implements Vertex,
InternalVertex {
    protected VertexBaseImpl(int id, Graph graph) {
        super(graph);
        this.id = id;
    }

    @Override
    public final int getDegree() {
        return this.getDegree(EdgeDirection.INOUT);
    }

    @Override
    public final int getDegree(EdgeDirection orientation) {
        int d = 0;
        switch (orientation) {
            case IN: {
                Edge i;
                for (i = this.getFirstIncidence(); i != null; i = i.getNextIncidence()) {
                    if (i.isNormal()) continue;
                    ++d;
                }
                return d;
            }
            case OUT: {
                Edge i;
                while (i != null) {
                    if (i.isNormal()) {
                        ++d;
                    }
                    i = i.getNextIncidence();
                }
                return d;
            }
            case INOUT: {
                Edge i;
                while (i != null) {
                    ++d;
                    i = i.getNextIncidence();
                }
                return d;
            }
        }
        throw new RuntimeException("FIXME!");
    }

    @Override
    public final Vertex getNextVertex() {
        InternalVertex nextVertex;
        TraversalContext tc = this.graph.getTraversalContext();
        if (tc != null && nextVertex != null && !tc.containsVertex(nextVertex)) {
            for (nextVertex = this.getNextVertexInVSeq(); nextVertex != null && !tc.containsVertex(nextVertex); nextVertex = nextVertex.getNextVertexInVSeq()) {
            }
        }
        return nextVertex;
    }

    @Override
    public final Vertex getNextVertex(VertexClass vertexClass) {
        assert (vertexClass != null);
        assert (this.isValid());
        for (Vertex v = this.getNextVertex(); v != null; v = v.getNextVertex()) {
            if (!v.isInstanceOf(vertexClass)) continue;
            return v;
        }
        return null;
    }

    @Override
    public final boolean isBefore(Vertex v) {
        InternalVertex prev;
        assert (v != null);
        assert (this.getGraph() == v.getGraph());
        assert (this.isValid() && v.isValid());
        if (this == v) {
            return false;
        }
        for (prev = ((InternalVertex)v).getPrevVertexInVSeq(); prev != null && prev != this; prev = prev.getPrevVertexInVSeq()) {
        }
        return prev != null;
    }

    @Override
    public final boolean isValid() {
        return this.graph.vSeqContainsVertex(this);
    }

    @Override
    public final void putBefore(Vertex v) {
        assert (v != null);
        assert (v != this);
        assert (this.getGraph() == v.getGraph());
        assert (this.isValid() && v.isValid());
        this.graph.putVertexBefore((InternalVertex)v, this);
    }

    @Override
    public final boolean isAfter(Vertex v) {
        InternalVertex next;
        assert (v != null);
        assert (this.getGraph() == v.getGraph());
        assert (this.isValid() && v.isValid());
        if (this == v) {
            return false;
        }
        for (next = ((InternalVertex)v).getNextVertexInVSeq(); next != null && next != this; next = next.getNextVertexInVSeq()) {
        }
        return next != null;
    }

    @Override
    public final void putAfter(Vertex v) {
        assert (v != null);
        assert (v != this);
        assert (this.getGraph() == v.getGraph());
        assert (this.isValid() && v.isValid());
        this.graph.putVertexAfter((InternalVertex)v, this);
    }

    @Override
    public final Edge getFirstIncidence() {
        TraversalContext tc = this.graph.getTraversalContext();
        Edge firstIncidence = this.getFirstIncidenceInISeq();
        if (tc != null && firstIncidence != null && !tc.containsEdge(firstIncidence)) {
            firstIncidence = firstIncidence.getNextIncidence();
        }
        return firstIncidence;
    }

    @Override
    public final Edge getLastIncidence() {
        TraversalContext tc = this.graph.getTraversalContext();
        Edge lastIncidence = this.getLastIncidenceInISeq();
        if (tc != null && lastIncidence != null && !tc.containsEdge(lastIncidence)) {
            lastIncidence = lastIncidence.getPrevIncidence();
        }
        return lastIncidence;
    }

    @Override
    public final Edge getFirstIncidence(EdgeDirection orientation) {
        assert (this.isValid());
        switch (orientation) {
            case IN: {
                Edge i;
                for (i = this.getFirstIncidence(); i != null && i.isNormal(); i = i.getNextIncidence()) {
                }
                return i;
            }
            case OUT: {
                Edge i;
                while (i != null && !i.isNormal()) {
                    i = i.getNextIncidence();
                }
                return i;
            }
            case INOUT: {
                Edge i;
                return i;
            }
        }
        throw new RuntimeException("FIXME!");
    }

    @Override
    public final Edge getFirstIncidence(boolean thisIncidence, AggregationKind ... kinds) {
        Edge i;
        assert (this.isValid());
        if (kinds.length == 0) {
            return i;
        }
        for (i = this.getFirstIncidence(); i != null; i = i.getNextIncidence()) {
            for (AggregationKind element : kinds) {
                if ((thisIncidence ? i.getThisAggregationKind() : i.getThatAggregationKind()) != element) continue;
                return i;
            }
        }
        return null;
    }

    @Override
    public final Edge getFirstIncidence(EdgeClass anEdgeClass) {
        assert (anEdgeClass != null);
        assert (this.isValid());
        return this.getFirstIncidence(anEdgeClass, EdgeDirection.INOUT);
    }

    @Override
    public final Edge getFirstIncidence(EdgeClass anEdgeClass, EdgeDirection orientation) {
        assert (anEdgeClass != null);
        assert (this.isValid());
        for (Edge currentEdge = this.getFirstIncidence(orientation); currentEdge != null; currentEdge = currentEdge.getNextIncidence(orientation)) {
            if (!currentEdge.isInstanceOf(anEdgeClass)) continue;
            return currentEdge;
        }
        return null;
    }

    @Override
    public final void delete() {
        assert (this.isValid()) : this + " is not valid!";
        this.graph.deleteVertex(this);
    }

    @Override
    public final void putIncidenceAfter(InternalEdge target, InternalEdge moved) {
        assert (target != null && moved != null);
        assert (target.isValid() && moved.isValid());
        assert (target.getGraph() == moved.getGraph());
        assert (target.getGraph() == this.getGraph());
        assert (target.getThis() == moved.getThis());
        assert (target != moved);
        if (target == moved || target.getNextIncidenceInISeq() == moved) {
            return;
        }
        assert (this.getFirstIncidenceInISeq() != this.getLastIncidenceInISeq());
        if (moved == this.getFirstIncidenceInISeq()) {
            this.setFirstIncidence(moved.getNextIncidenceInISeq());
            moved.getNextIncidenceInISeq().setPrevIncidenceInternal(null);
        } else if (moved == this.getLastIncidenceInISeq()) {
            this.setLastIncidence(moved.getPrevIncidenceInISeq());
            moved.getPrevIncidenceInISeq().setNextIncidenceInternal(null);
        } else {
            moved.getPrevIncidenceInISeq().setNextIncidenceInternal(moved.getNextIncidenceInISeq());
            moved.getNextIncidenceInISeq().setPrevIncidenceInternal(moved.getPrevIncidenceInISeq());
        }
        if (target == this.getLastIncidenceInISeq()) {
            this.setLastIncidence(moved);
            moved.setNextIncidenceInternal(null);
        } else {
            target.getNextIncidenceInISeq().setPrevIncidenceInternal(moved);
            moved.setNextIncidenceInternal(target.getNextIncidenceInISeq());
        }
        moved.setPrevIncidenceInternal(target);
        target.setNextIncidenceInternal(moved);
        this.incidenceListModified();
    }

    @Override
    public final void putIncidenceBefore(InternalEdge target, InternalEdge moved) {
        assert (target != null && moved != null);
        assert (target.isValid() && moved.isValid());
        assert (target.getGraph() == moved.getGraph());
        assert (target.getGraph() == this.getGraph());
        assert (target.getThis() == moved.getThis());
        assert (target != moved);
        if (target == moved || target.getPrevIncidenceInISeq() == moved) {
            return;
        }
        assert (this.getFirstIncidenceInISeq() != this.getLastIncidenceInISeq());
        if (moved == this.getFirstIncidenceInISeq()) {
            this.setFirstIncidence(moved.getNextIncidenceInISeq());
            moved.getNextIncidenceInISeq().setPrevIncidenceInternal(null);
        } else if (moved == this.getLastIncidenceInISeq()) {
            this.setLastIncidence(moved.getPrevIncidenceInISeq());
            moved.getPrevIncidenceInISeq().setNextIncidenceInternal(null);
        } else {
            moved.getPrevIncidenceInISeq().setNextIncidenceInternal(moved.getNextIncidenceInISeq());
            moved.getNextIncidenceInISeq().setPrevIncidenceInternal(moved.getPrevIncidenceInISeq());
        }
        if (target == this.getFirstIncidenceInISeq()) {
            this.setFirstIncidence(moved);
            moved.setPrevIncidenceInternal(null);
        } else {
            InternalEdge previousIncidence = target.getPrevIncidenceInISeq();
            previousIncidence.setNextIncidenceInternal(moved);
            moved.setPrevIncidenceInternal(previousIncidence);
        }
        moved.setNextIncidenceInternal(target);
        target.setPrevIncidenceInternal(moved);
        this.incidenceListModified();
    }

    @Override
    public abstract long getIncidenceListVersion();

    @Override
    public final boolean isIncidenceListModified(long vertexStructureVersion) {
        assert (this.isValid());
        return this.getIncidenceListVersion() != vertexStructureVersion;
    }

    @Override
    public final void incidenceListModified() {
        assert (this.isValid());
        this.setIncidenceListVersion(this.getIncidenceListVersion() + 1L);
    }

    @Override
    public final int getDegree(EdgeClass ec) {
        assert (ec != null);
        assert (this.isValid());
        return this.getDegree(ec, EdgeDirection.INOUT);
    }

    @Override
    public final int getDegree(EdgeClass ec, EdgeDirection orientation) {
        assert (ec != null);
        assert (this.isValid());
        int degree = 0;
        for (Edge e = this.getFirstIncidence(ec, orientation); e != null; e = e.getNextIncidence(ec, orientation)) {
            ++degree;
        }
        return degree;
    }

    public String toString() {
        return "v" + this.id + ": " + this.getAttributedElementClass().getQualifiedName();
    }

    @Override
    public final int compareTo(AttributedElement<VertexClass, Vertex> a) {
        assert (a instanceof Vertex);
        if (this == a) {
            return 0;
        }
        Vertex v = (Vertex)a;
        assert (this.isValid() && v.isValid());
        assert (this.getGraph() == v.getGraph());
        int x = this.getId() - v.getId();
        if (x != 0) {
            return x;
        }
        return this.getGraph().compareTo(v.getGraph());
    }

    @Override
    public final Iterable<Edge> incidences() {
        assert (this.isValid());
        return new IncidenceIterable<Edge>(this);
    }

    @Override
    public final Iterable<Edge> incidences(EdgeDirection dir) {
        assert (this.isValid());
        return new IncidenceIterable<Edge>((Vertex)this, dir);
    }

    @Override
    public final Iterable<Edge> incidences(EdgeClass eclass, EdgeDirection dir) {
        assert (eclass != null);
        assert (this.isValid());
        return new IncidenceIterable<Edge>(this, eclass, dir);
    }

    @Override
    public final Iterable<Edge> incidences(EdgeClass eclass) {
        assert (eclass != null);
        assert (this.isValid());
        return new IncidenceIterable<Edge>((Vertex)this, eclass);
    }

    @Override
    public final Vertex getPrevVertex() {
        InternalVertex prevVertex;
        TraversalContext tc = this.graph.getTraversalContext();
        if (tc != null && prevVertex != null && !tc.containsVertex(prevVertex)) {
            for (prevVertex = this.getPrevVertexInVSeq(); prevVertex != null && !tc.containsVertex(prevVertex); prevVertex = prevVertex.getPrevVertexInVSeq()) {
            }
        }
        return prevVertex;
    }

    @Override
    public final void appendIncidenceToISeq(InternalEdge i) {
        assert (i != null);
        assert (i.getIncidentVertex() != this);
        i.setIncidentVertex(this);
        if (this.getFirstIncidenceInISeq() == null) {
            this.setFirstIncidence(i);
        }
        if (this.getLastIncidenceInISeq() != null) {
            this.getLastIncidenceInISeq().setNextIncidenceInternal(i);
            i.setPrevIncidenceInternal(this.getLastIncidenceInISeq());
        }
        this.setLastIncidence(i);
    }

    @Override
    public final void removeIncidenceFromISeq(InternalEdge i) {
        assert (i != null);
        assert (i.getIncidentVertex() == this);
        if (i == this.getFirstIncidenceInISeq()) {
            this.setFirstIncidence(i.getNextIncidenceInISeq());
            if (this.getFirstIncidenceInISeq() != null) {
                this.getFirstIncidenceInISeq().setPrevIncidenceInternal(null);
            }
            if (i == this.getLastIncidenceInISeq()) {
                this.setLastIncidence(null);
            }
        } else if (i == this.getLastIncidenceInISeq()) {
            this.setLastIncidence(i.getPrevIncidenceInISeq());
            if (this.getLastIncidenceInISeq() != null) {
                this.getLastIncidenceInISeq().setNextIncidenceInternal(null);
            }
        } else {
            i.getPrevIncidenceInISeq().setNextIncidenceInternal(i.getNextIncidenceInISeq());
            i.getNextIncidenceInISeq().setPrevIncidenceInternal(i.getPrevIncidenceInISeq());
        }
        i.setIncidentVertex(null);
        i.setNextIncidenceInternal(null);
        i.setPrevIncidenceInternal(null);
    }

    @Override
    public final void sortIncidences(Comparator<Edge> comp) {
        assert (this.isValid());
        if (this.getFirstIncidenceInISeq() == null) {
            return;
        }
        final class IncidenceList {
            InternalEdge first;
            InternalEdge last;

            IncidenceList() {
            }

            public void add(InternalEdge e) {
                if (this.first == null) {
                    this.first = e;
                    assert (this.last == null);
                    this.last = e;
                } else {
                    e.setPrevIncidenceInternal(this.last);
                    this.last.setNextIncidenceInternal(e);
                    this.last = e;
                }
                e.setNextIncidenceInternal(null);
            }

            public InternalEdge remove() {
                if (this.first == null) {
                    throw new NoSuchElementException();
                }
                if (this.first == this.last) {
                    InternalEdge out = this.first;
                    this.first = null;
                    this.last = null;
                    return out;
                }
                InternalEdge out = this.first;
                this.first = out.getNextIncidenceInISeq();
                this.first.setPrevIncidenceInternal(null);
                return out;
            }

            public boolean isEmpty() {
                assert (this.first == null == (this.last == null));
                return this.first == null;
            }
        }
        IncidenceList a = new IncidenceList();
        IncidenceList b = new IncidenceList();
        IncidenceList out = a;
        IncidenceList l = new IncidenceList();
        l.first = this.getFirstIncidenceInISeq();
        l.last = this.getLastIncidenceInISeq();
        InternalEdge last = l.remove();
        out.add(last);
        while (!l.isEmpty()) {
            InternalEdge current = l.remove();
            if (comp.compare(current, last) < 0) {
                out = out == a ? b : a;
            }
            out.add(current);
            last = current;
        }
        if (a.isEmpty() || b.isEmpty()) {
            out = a.isEmpty() ? b : a;
            this.setFirstIncidence(out.first);
            this.setLastIncidence(out.last);
            return;
        }
        while (true) {
            if (a.isEmpty() || b.isEmpty()) {
                out = a.isEmpty() ? b : a;
                this.setFirstIncidence(out.first);
                this.setLastIncidence(out.last);
                this.incidenceListModified();
                return;
            }
            IncidenceList c = new IncidenceList();
            IncidenceList d = new IncidenceList();
            out = c;
            last = null;
            while (!a.isEmpty() && !b.isEmpty()) {
                int compareBToLast;
                int compareAToLast = last != null ? comp.compare(a.first, last) : 0;
                int n = compareBToLast = last != null ? comp.compare(b.first, last) : 0;
                if (compareAToLast >= 0 && compareBToLast >= 0) {
                    if (comp.compare(a.first, b.first) <= 0) {
                        last = a.remove();
                        out.add(last);
                        continue;
                    }
                    last = b.remove();
                    out.add(last);
                    continue;
                }
                if (compareAToLast < 0 && compareBToLast < 0) {
                    out = out == c ? d : c;
                    last = null;
                    continue;
                }
                if (compareAToLast < 0 && compareBToLast >= 0) {
                    last = b.remove();
                    out.add(last);
                    continue;
                }
                last = a.remove();
                out.add(last);
            }
            while (!a.isEmpty()) {
                InternalEdge current = a.remove();
                if (comp.compare(current, last) < 0) {
                    out = out == c ? d : c;
                }
                out.add(current);
                last = current;
            }
            while (!b.isEmpty()) {
                InternalEdge current = b.remove();
                if (comp.compare(current, last) < 0) {
                    out = out == c ? d : c;
                }
                out.add(current);
                last = current;
            }
            a = c;
            b = d;
        }
    }

    @Override
    public final List<? extends Vertex> adjacences(String role) {
        assert (role != null && role.length() > 0);
        assert (this.isValid());
        DirectedSchemaEdgeClass entry = this.getEdgeForRolename(role);
        ArrayList<Vertex> adjacences = new ArrayList<Vertex>();
        EdgeDirection dir = entry.getDirection();
        for (Edge e : this.incidences(entry.getEdgeClass(), dir)) {
            adjacences.add(e.getThat());
        }
        return adjacences;
    }

    @Override
    public final Edge addAdjacence(String role, Vertex other) {
        assert (role != null && role.length() > 0);
        assert (this.isValid());
        assert (other.isValid());
        assert (this.getGraph() == other.getGraph());
        DirectedSchemaEdgeClass entry = this.getEdgeForRolename(role);
        EdgeDirection dir = entry.getDirection();
        Vertex from = null;
        Vertex to = null;
        if (dir == EdgeDirection.IN) {
            from = other;
            to = this;
        } else {
            to = other;
            from = this;
        }
        return this.getGraph().createEdge(entry.getEdgeClass(), from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<Vertex> removeAdjacences(String role) {
        assert (role != null && role.length() > 0);
        assert (this.isValid());
        TraversalContext oldTC = this.getGraph().setTraversalContext(null);
        try {
            DirectedSchemaEdgeClass entry = this.getEdgeForRolename(role);
            ArrayList<Vertex> adjacences = new ArrayList<Vertex>();
            ArrayList<Edge> deleteList = new ArrayList<Edge>();
            EdgeDirection dir = entry.getDirection();
            for (Edge e : this.incidences(entry.getEdgeClass(), dir)) {
                deleteList.add(e);
                adjacences.add(e.getThat());
            }
            for (Edge e : deleteList) {
                e.delete();
            }
            ArrayList<Vertex> arrayList = adjacences;
            return arrayList;
        }
        finally {
            this.getGraph().setTraversalContext(oldTC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeAdjacence(String role, Vertex other) {
        assert (role != null && role.length() > 0);
        assert (this.isValid());
        assert (other.isValid());
        assert (this.getGraph() == other.getGraph());
        TraversalContext oldTC = this.getGraph().setTraversalContext(null);
        try {
            DirectedSchemaEdgeClass entry = this.getEdgeForRolename(role);
            ArrayList<Edge> deleteList = new ArrayList<Edge>();
            EdgeDirection dir = entry.getDirection();
            for (Edge e : this.incidences(entry.getEdgeClass(), dir)) {
                if (e.getThat() != other) continue;
                deleteList.add(e);
            }
            for (Edge e : deleteList) {
                e.delete();
            }
        }
        finally {
            this.getGraph().setTraversalContext(oldTC);
        }
    }

    @Override
    public final DirectedSchemaEdgeClass getEdgeForRolename(String rolename) {
        return this.getAttributedElementClass().getDirectedEdgeClassForFarEndRole(rolename);
    }

    @Override
    public final <T extends Vertex> POrderedSet<T> reachableVertices(Class<T> returnType, PathElement ... pathElements) {
        PSet<Object> result = JGraLab.set();
        LinkedList<Vertex> q = new LinkedList<Vertex>();
        q.add(this);
        for (int i = 0; i < pathElements.length; ++i) {
            PathElement t = pathElements[i];
            q.add(null);
            Vertex vx = (Vertex)q.poll();
            while (vx != null) {
                for (Edge e : vx.incidences(t.edgeClass, t.edgeDirection)) {
                    if (t.strictType && (!t.strictType || t.edgeClass != e.getAttributedElementClass())) continue;
                    if (i == pathElements.length - 1) {
                        Vertex r = e.getThat();
                        if (!returnType.isInstance(r)) continue;
                        result = result.plus(r);
                        continue;
                    }
                    q.add(e.getThat());
                }
                vx = (Vertex)q.poll();
            }
        }
        return (POrderedSet)result;
    }
}

