/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphFactory;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphException;
import de.uni_koblenz.jgralab.impl.InternalGraph;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.exception.SchemaClassAccessException;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public abstract class GraphFactoryImpl
implements GraphFactory {
    protected Constructor<? extends Graph> graphConstructor;
    protected HashMap<EdgeClass, Constructor<? extends Edge>> edgeMap;
    protected HashMap<VertexClass, Constructor<? extends Vertex>> vertexMap;
    protected Schema schema;
    protected ImplementationType implementationType;
    protected boolean graphCreated;

    protected GraphFactoryImpl(Schema s, ImplementationType i) {
        this.schema = s;
        this.implementationType = i;
    }

    protected void createMaps() {
        this.edgeMap = new HashMap();
        this.vertexMap = new HashMap();
    }

    @Override
    public ImplementationType getImplementationType() {
        return this.implementationType;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void setGraphImplementationClass(GraphClass gc, Class<? extends Graph> implementationClass) {
        if (this.graphCreated) {
            throw new IllegalStateException("Can't change implementation class after a graph was created.");
        }
        Class originalClass = gc.getSchemaClass();
        if (this.isSuperclassOrEqual(originalClass, implementationClass)) {
            try {
                Class[] params = new Class[]{String.class, Integer.TYPE, Integer.TYPE};
                this.graphConstructor = implementationClass.getConstructor(params);
            }
            catch (NoSuchMethodException ex) {
                throw new SchemaClassAccessException("Unable to locate constructor for graphclass " + implementationClass.getName(), ex);
            }
        } else {
            throw new SchemaException(implementationClass.getCanonicalName() + " does not implement " + originalClass.getCanonicalName());
        }
    }

    @Override
    public <G extends Graph> G createGraph(GraphClass gc, String id, int vMax, int eMax) {
        try {
            Graph graph = this.graphConstructor.newInstance(id, vMax, eMax);
            graph.setGraphFactory(this);
            this.graphCreated = true;
            return (G)graph;
        }
        catch (Exception ex) {
            throw new SchemaClassAccessException("Cannot create graph of class " + this.graphConstructor.getDeclaringClass().getCanonicalName(), ex);
        }
    }

    @Override
    public <E extends Edge> E createEdge(EdgeClass ec, int id, Graph g, Vertex alpha, Vertex omega) {
        try {
            if (!((InternalGraph)g).isLoading() && g.hasECARuleManager()) {
                g.getECARuleManager().fireBeforeCreateEdgeEvents(ec);
            }
            Edge newInstance = ec.equals(g.getGraphClass().getTemporaryEdgeClass()) ? g.createTemporaryEdge(alpha, omega) : (alpha.isTemporary() || omega.isTemporary() ? g.createTemporaryEdge(ec, alpha, omega) : this.edgeMap.get(ec).newInstance(id, g, alpha, omega));
            if (!((InternalGraph)g).isLoading() && g.hasECARuleManager()) {
                g.getECARuleManager().fireAfterCreateEdgeEvents(newInstance);
            }
            return (E)newInstance;
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof GraphException) {
                throw new GraphException(ex.getCause().getLocalizedMessage(), ex);
            }
            throw new SchemaClassAccessException("Cannot create edge of class " + ec.getQualifiedName(), ex);
        }
    }

    @Override
    public <V extends Vertex> V createVertex(VertexClass vc, int id, Graph g) {
        try {
            if (!((InternalGraph)g).isLoading() && g.hasECARuleManager()) {
                g.getECARuleManager().fireBeforeCreateVertexEvents(vc);
            }
            Vertex newInstance = vc.equals(g.getGraphClass().getTemporaryVertexClass()) ? g.createTemporaryVertex() : this.vertexMap.get(vc).newInstance(id, g);
            if (!((InternalGraph)g).isLoading() && g.hasECARuleManager()) {
                g.getECARuleManager().fireAfterCreateVertexEvents(newInstance);
            }
            return (V)newInstance;
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof GraphException) {
                throw new GraphException(ex.getCause().getLocalizedMessage(), ex);
            }
            throw new SchemaClassAccessException("Cannot create vertex of class " + vc.getQualifiedName(), ex);
        }
    }

    @Override
    public void setVertexImplementationClass(VertexClass vc, Class<? extends Vertex> implementationClass) {
        if (this.graphCreated) {
            throw new IllegalStateException("Can't change implementation class after a graph was created.");
        }
        Class originalClass = vc.getSchemaClass();
        if (this.isSuperclassOrEqual(originalClass, implementationClass)) {
            try {
                Class[] params = new Class[]{Integer.TYPE, Graph.class};
                this.vertexMap.put(vc, implementationClass.getConstructor(params));
            }
            catch (NoSuchMethodException ex) {
                throw new SchemaClassAccessException("Unable to locate default constructor for vertexclass" + implementationClass, ex);
            }
        } else {
            throw new SchemaException(implementationClass.getCanonicalName() + " does not implement " + originalClass.getCanonicalName());
        }
    }

    @Override
    public void setEdgeImplementationClass(EdgeClass ec, Class<? extends Edge> implementationClass) {
        if (this.graphCreated) {
            throw new IllegalStateException("Can't change implementation class after a graph was created.");
        }
        Class originalClass = ec.getSchemaClass();
        if (this.isSuperclassOrEqual(originalClass, implementationClass)) {
            try {
                Class[] params = new Class[]{Integer.TYPE, Graph.class, Vertex.class, Vertex.class};
                this.edgeMap.put(ec, implementationClass.getConstructor(params));
            }
            catch (NoSuchMethodException ex) {
                throw new SchemaClassAccessException("Unable to locate default constructor for edgeclass" + implementationClass, ex);
            }
        } else {
            throw new SchemaException(implementationClass.getCanonicalName() + " does not implement " + originalClass.getCanonicalName());
        }
    }

    protected boolean isSuperclassOrEqual(Class<?> a, Class<?> b) {
        if (a == b) {
            return true;
        }
        if (this.implementsInterface(b, a)) {
            return true;
        }
        while (b.getSuperclass() != null) {
            if (b.getSuperclass() == a) {
                return true;
            }
            if (this.implementsInterface(b, a)) {
                return true;
            }
            b = b.getSuperclass();
        }
        return false;
    }

    protected boolean implementsInterface(Class<?> a, Class<?> b) {
        Class<?>[] list;
        for (Class<?> c : list = a.getInterfaces()) {
            if (c != b) continue;
            return true;
        }
        return false;
    }
}

