/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl.templategraphparser;

import de.uni_koblenz.jgralab.gretl.templategraphparser.ComplexToken;
import de.uni_koblenz.jgralab.gretl.templategraphparser.SimpleToken;
import de.uni_koblenz.jgralab.gretl.templategraphparser.TemplateGraphParserException;
import de.uni_koblenz.jgralab.gretl.templategraphparser.Token;
import de.uni_koblenz.jgralab.gretl.templategraphparser.TokenType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TemplateGraphLexer {
    protected static Map<TokenType, String> fixedTokens = new HashMap<TokenType, String>();
    private String text;
    private int position = 0;

    public TemplateGraphLexer(String ics) {
        this.text = ics;
    }

    public static List<Token> scan(String query) {
        ArrayList<Token> list = new ArrayList<Token>();
        TemplateGraphLexer lexer = new TemplateGraphLexer(query);
        while (lexer.hasNextToken()) {
            Token nextToken = lexer.getNextToken();
            list.add(nextToken);
        }
        return list;
    }

    private Token getNextToken() {
        ComplexToken tok;
        TokenType recognizedTokenType = null;
        this.skipWhitespaces();
        for (Map.Entry<TokenType, String> currentEntry : fixedTokens.entrySet()) {
            int tokLen;
            String tokStr = currentEntry.getValue();
            if (!this.text.regionMatches(this.position, tokStr, 0, tokLen = tokStr.length())) continue;
            recognizedTokenType = currentEntry.getKey();
            SimpleToken tok2 = new SimpleToken(recognizedTokenType, this.position, tokLen);
            this.position += tokLen;
            return tok2;
        }
        if (this.text.charAt(this.position) == '\'') {
            recognizedTokenType = TokenType.STRING;
            ++this.position;
            int start = this.position;
            StringBuilder sb = new StringBuilder();
            while (this.position < this.text.length() && this.text.charAt(this.position) != '\'') {
                if (this.text.charAt(this.position) == '\\') {
                    if (this.position == this.text.length()) {
                        throw new TemplateGraphParserException("String started at position " + start + " but is not closed in query: '" + this.text.substring(start, this.position) + "'.");
                    }
                    if (this.text.charAt(this.position + 1) == '\'' || this.text.charAt(this.position + 1) == '\\') {
                        ++this.position;
                    }
                }
                sb.append(this.text.charAt(this.position));
                ++this.position;
            }
            if (this.position >= this.text.length() || this.text.charAt(this.position) != '\'') {
                throw new TemplateGraphParserException("String started at position " + start + " but is not closed in query: '" + sb.toString() + "'.");
            }
            tok = new ComplexToken(recognizedTokenType, start, this.position, sb.toString());
            ++this.position;
            return tok;
        }
        StringBuilder sb = new StringBuilder();
        int start = this.position;
        while (this.text.length() > this.position && !this.isSeparator(this.text.charAt(this.position))) {
            sb.append(this.text.charAt(this.position++));
        }
        if (start == this.position) {
            throw new TemplateGraphParserException("Zero-length IDENTIFIER at position " + this.position + ".");
        }
        tok = new ComplexToken(TokenType.IDENT, start, this.position - start, sb.toString());
        return tok;
    }

    private boolean isSeparator(char c) {
        return fixedTokens.values().contains(String.valueOf(c)) || TemplateGraphLexer.isWhitespace(c) || c == '-' || c == '<' || c == ';';
    }

    private boolean hasNextToken() {
        this.skipWhitespaces();
        return this.position < this.text.length();
    }

    private static final boolean isWhitespace(int c) {
        return c == 32 || c == 10 || c == 9 || c == 13;
    }

    private void skipWhitespaces() {
        while (this.position < this.text.length() && TemplateGraphLexer.isWhitespace(this.text.charAt(this.position))) {
            ++this.position;
        }
    }

    public static void main(String[] args) {
        System.out.println(TemplateGraphLexer.scan("v1(foo.bar.Bar 'tup(\"x\", $[1])' | x='\"foo\"', y= '$[0].y')-->{edge.Bar '$[17]'|e = '$[18].name'} v2(Baz '$[11]')"));
        System.out.println(TemplateGraphLexer.scan("v1(a.A 'tup($[1], \"aArch\")' | a1 = '\"A\"', a2='$[2] + 1') -->{a.E 'tup($[1], $[2])' | e1 = '$[17]'} v1"));
        System.out.println(TemplateGraphLexer.scan("v1(a.A 'tup($[1], \"aArch\")' | a1 = '\"A\"', a2='$[2] + 1') -->{a.E 'tup($[1], $[2])' | e1 = '$[17]'} v1<--{a.E2 '$[3]'} v3(a.B '$[4]'),v4('$[6]') <--{a.F '1'| e3='17'} v1"));
        System.out.println(TemplateGraphLexer.scan("v1(,'\"a.A\" ++ Foo' 'tup($[1], \"aArch\")' | a1 = '\"A\"', a2='$[2] + 1', ...) "));
    }

    static {
        fixedTokens.put(TokenType.L_CURLY, "{");
        fixedTokens.put(TokenType.R_CURLY, "}");
        fixedTokens.put(TokenType.PIPE, "|");
        fixedTokens.put(TokenType.ASSIGN, "=");
        fixedTokens.put(TokenType.L_ARROW, "<--");
        fixedTokens.put(TokenType.R_ARROW, "-->");
        fixedTokens.put(TokenType.L_PAREN, "(");
        fixedTokens.put(TokenType.R_PAREN, ")");
        fixedTokens.put(TokenType.COMMA, ",");
        fixedTokens.put(TokenType.TRIPLE_DOT, "...");
        fixedTokens.put(TokenType.HASH, "#");
    }
}

