/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.GReTLRunner;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.BooleanDomain;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.DoubleDomain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.IntegerDomain;
import de.uni_koblenz.jgralab.schema.LongDomain;
import de.uni_koblenz.jgralab.schema.StringDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizOutputFormat;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public abstract class Transformation<T> {
    public static boolean DEBUG_EXECUTION = Boolean.parseBoolean(System.getProperty("debugGReTLExecution", "false"));
    public static boolean DEBUG_REVERSE_EDGES = false;
    private static int EXECUTION_STEP = 1;
    protected Context context;
    protected static Logger logger = JGraLab.getLogger(Transformation.class);

    private final void invokeHooks(Class<? extends Annotation> annotationClass) {
        Class<?> cls = this.getClass();
        while (Transformation.class.isAssignableFrom(cls)) {
            for (Method method : cls.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(annotationClass)) continue;
                try {
                    method.setAccessible(true);
                    method.invoke((Object)this, new Object[0]);
                }
                catch (Exception e) {
                    logger.severe("Couldn't run @" + annotationClass.getSimpleName() + " method " + method.getName() + " of " + cls.getSimpleName() + ".");
                    e.printStackTrace();
                }
            }
            cls = cls.getSuperclass();
        }
    }

    protected Transformation(Context context) {
        this.context = context;
    }

    protected Transformation() {
    }

    public final void setContext(Context c) {
        this.context = c;
    }

    public final T execute() {
        long startTime = System.currentTimeMillis();
        if (this.context == null) {
            throw new GReTLException("No Context set for " + this);
        }
        this.invokeHooks(Before.class);
        T result = null;
        if (this.context.outermost) {
            EXECUTION_STEP = 1;
            this.context.phase = Context.TransformationPhase.SCHEMA;
            this.context.outermost = false;
            if (this.context.getTargetSchema() == null) {
                logger.info("Starting Schema creation phase...");
                this.context.createTargetSchema();
                this.transform();
            } else {
                logger.info("Target Schema exists. Skipping schema creation phase...");
            }
            this.context.ensureAllMappings();
            if (this.context.targetGraph == null) {
                logger.info("Creating a new target graph...");
                this.context.createTargetGraph();
            } else if (this.context.targetGraph.getSchema().getQualifiedName().equals(this.context.targetSchema.getQualifiedName())) {
                logger.info("Using a preset target graph...");
            } else {
                throw new GReTLException(this.context, "Preset target graph has wrong schema '" + this.context.targetGraph.getSchema().getQualifiedName() + "'. Expected was '" + this.context.targetSchema.getQualifiedName() + "'.");
            }
            logger.info("SCHEMA Phase took " + (System.currentTimeMillis() - startTime) + "ms.");
            startTime = System.currentTimeMillis();
            this.context.phase = Context.TransformationPhase.GRAPH;
            logger.info("Starting instance creation phase...");
            result = this.transform();
            if (DEBUG_EXECUTION) {
                this.context.validateMappings();
            }
            logger.info("GRAPH Phase took " + (System.currentTimeMillis() - startTime) + "ms.");
        } else {
            result = this.transform();
            Graph tg = this.context.targetGraph;
            if (DEBUG_EXECUTION && tg.getVCount() + tg.getECount() < GReTLRunner.MAX_VISUALIZATION_SIZE) {
                try {
                    String name = this.getClass().getSimpleName();
                    if (name.isEmpty()) {
                        name = "$anonymous$";
                    }
                    Tg2Dot.convertGraph(this.context.getTargetGraph(), "__debug_" + EXECUTION_STEP++ + "_" + name + ".pdf", DEBUG_REVERSE_EDGES, GraphVizOutputFormat.PDF);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.invokeHooks(After.class);
        return result;
    }

    protected abstract T transform();

    protected final BooleanDomain getBooleanDomain() {
        return this.context.targetSchema.getBooleanDomain();
    }

    protected final IntegerDomain getIntegerDomain() {
        return this.context.targetSchema.getIntegerDomain();
    }

    protected final LongDomain getLongDomain() {
        return this.context.targetSchema.getLongDomain();
    }

    protected final StringDomain getStringDomain() {
        return this.context.targetSchema.getStringDomain();
    }

    protected final DoubleDomain getDoubleDomain() {
        return this.context.targetSchema.getDoubleDomain();
    }

    protected final void setGReQLVariable(String name, Object val) {
        if (this.context.getPhase() != Context.TransformationPhase.GRAPH) {
            return;
        }
        this.context.setGReQLVariable(name, val);
    }

    protected final void setGReQLVariable(String name, String greqlExpression) {
        if (this.context.getPhase() != Context.TransformationPhase.GRAPH) {
            return;
        }
        this.context.setGReQLVariable(name, greqlExpression);
    }

    protected final void setGReQLHelper(String name, String greqlExpression) {
        if (this.context.getPhase() != Context.TransformationPhase.GRAPH) {
            return;
        }
        this.context.setGReQLHelper(name, greqlExpression);
    }

    protected final void addGReQLImport(String qualifiedName) {
        if (this.context.getPhase() != Context.TransformationPhase.GRAPH) {
            return;
        }
        this.context.addGReQLImport(qualifiedName);
    }

    protected final VertexClass vc(String qualifiedName) {
        VertexClass vc = this.context.targetSchema.getGraphClass().getVertexClass(qualifiedName);
        if (vc == null) {
            throw new GReTLException("There's no target VertexClass '" + qualifiedName + "'.");
        }
        return vc;
    }

    protected final EdgeClass ec(String qualifiedName) {
        EdgeClass ec = this.context.targetSchema.getGraphClass().getEdgeClass(qualifiedName);
        if (ec == null) {
            throw new GReTLException(this.context, "There's no target EdgeClass '" + qualifiedName + "'.");
        }
        return ec;
    }

    protected final AttributedElementClass<?, ?> aec(String qualifiedName) {
        Object aec = this.context.targetSchema.getAttributedElementClass(qualifiedName);
        if (aec == null) {
            throw new GReTLException(this.context, "There's no target AttributedElementClass '" + qualifiedName + "'.");
        }
        return aec;
    }

    protected final GraphElementClass<?, ?> gec(String qualifiedName) {
        GraphElementClass<?, ?> gec = this.context.targetSchema.getGraphClass().getGraphElementClass(qualifiedName);
        if (gec == null) {
            throw new GReTLException(this.context, "There's no target GraphElementClass '" + qualifiedName + "'.");
        }
        return gec;
    }

    protected final Attribute attr(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        String className = qualifiedName.substring(0, lastDot);
        Object aec = this.context.getTargetSchema().getAttributedElementClass(className);
        if (aec == null) {
            throw new GReTLException(this.context, "There's no target AttributedElementClass '" + className + "'.");
        }
        String attrName = qualifiedName.substring(lastDot + 1);
        Attribute attr = aec.getAttribute(attrName);
        if (attr == null) {
            throw new GReTLException(this.context, "There's no target Attribute '" + attrName + "' in AttributedElementClass '" + className + "'.");
        }
        return attr;
    }

    protected Domain domain(String domain) {
        Domain d = this.context.getTargetSchema().getDomain(domain);
        if (d == null) {
            throw new GReTLException(this.context, "There's no target Domain '" + domain + "'.");
        }
        return d;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface Before {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface After {
    }
}

