/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.greql.types.Undefined;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import org.pcollections.Empty;
import org.pcollections.PMap;

public class SetAttributes
extends Transformation<PMap<AttributedElement<?, ?>, Object>> {
    private Attribute attribute = null;
    private PMap<? extends Object, ? extends Object> archetype2valueMap = null;
    private String semanticExpression = null;

    public SetAttributes(Context c, Attribute attr, PMap<? extends Object, ? extends Object> archetypeValueMap) {
        super(c);
        this.attribute = attr;
        this.archetype2valueMap = archetypeValueMap;
    }

    public SetAttributes(Context c, Attribute attr, String semanticExpression) {
        super(c);
        this.attribute = attr;
        this.semanticExpression = semanticExpression;
    }

    public static SetAttributes parseAndCreate(ExecuteTransformation et) {
        Attribute attr = et.matchAttribute();
        et.matchTransformationArrow();
        String semExp = et.matchSemanticExpression();
        return new SetAttributes(et.context, attr, semExp);
    }

    @Override
    protected PMap<AttributedElement<?, ?>, Object> transform() {
        if (this.context.phase != Context.TransformationPhase.GRAPH) {
            return null;
        }
        if (this.archetype2valueMap == null) {
            this.archetype2valueMap = (PMap)this.context.evaluateGReQLQuery(this.semanticExpression);
        }
        PMap<AttributedElement<Object, Object>, Object> resultMap = Empty.orderedMap();
        for (Object archetype : this.archetype2valueMap.keySet()) {
            AttributedElement image = (AttributedElement)this.context.getImg(this.attribute.getAttributedElementClass()).get(archetype);
            if (image == null) {
                String qname = this.attribute.getAttributedElementClass().getQualifiedName();
                throw new GReTLException(this.context, "The source graph element '" + archetype + "' has no image in " + Context.toGReTLVarNotation(qname, Context.GReTLVariableType.IMG) + " yet, so no attribute '" + this.attribute.getName() + "' can be created!");
            }
            Object val = this.archetype2valueMap.get(archetype);
            resultMap = resultMap.plus(image, val);
            if (val == Undefined.UNDEFINED) continue;
            Object o = this.convertToAttributeValue(val);
            image.setAttribute(this.attribute.getName(), o);
        }
        return resultMap;
    }

    private Object convertToAttributeValue(Object val) {
        Object result = val;
        Domain dom = this.attribute.getDomain();
        if (dom instanceof RecordDomain) {
            return this.context.getTargetGraph().createRecord((RecordDomain)dom, ((Record)val).toPMap());
        }
        return result;
    }
}

