/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.VertexClass;
import org.pcollections.Empty;
import org.pcollections.PSet;

public class CreateVertices
extends Transformation<PSet<? extends Vertex>> {
    private PSet<? extends Object> archetypes = null;
    private String semanticExpression = null;
    private VertexClass vertexClass = null;

    public CreateVertices(Context c, VertexClass vertexClass, PSet<? extends Object> archetypes) {
        super(c);
        this.vertexClass = vertexClass;
        this.archetypes = archetypes;
    }

    public CreateVertices(Context c, VertexClass vertexClass, String semExp) {
        super(c);
        this.vertexClass = vertexClass;
        this.semanticExpression = semExp;
    }

    public static CreateVertices parseAndCreate(ExecuteTransformation et) {
        VertexClass vc = et.matchVertexClass();
        et.matchTransformationArrow();
        String semExp = et.matchSemanticExpression();
        return new CreateVertices(et.context, vc, semExp);
    }

    @Override
    protected PSet<? extends Vertex> transform() {
        if (this.context.phase != Context.TransformationPhase.GRAPH) {
            return null;
        }
        if (this.archetypes == null) {
            this.archetypes = (PSet)this.context.evaluateGReQLQuery(this.semanticExpression);
        }
        PSet result = Empty.set();
        for (Object e : this.archetypes) {
            Object img = this.context.targetGraph.createVertex(this.vertexClass);
            result = result.plus(img);
            this.context.addMapping(this.vertexClass, e, (AttributedElement<?, ?>)img);
        }
        return result;
    }
}

