/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CreateVertices;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.VertexClass;
import org.pcollections.PSet;

public class CreateVertexClass
extends Transformation<VertexClass> {
    protected String qualifiedName = null;
    private PSet<? extends Object> archetypes = null;
    private String semanticExpression = null;

    protected CreateVertexClass(Context c, String qualifiedName) {
        super(c);
        this.qualifiedName = qualifiedName;
    }

    public CreateVertexClass(Context c, String qualifiedName, PSet<? extends Object> archetypes) {
        this(c, qualifiedName);
        this.archetypes = archetypes;
    }

    public CreateVertexClass(Context c, String qualifiedName, String semanticExpression) {
        this(c, qualifiedName);
        this.semanticExpression = semanticExpression;
    }

    public static CreateVertexClass parseAndCreate(ExecuteTransformation et) {
        String qname = et.matchQualifiedName();
        et.matchTransformationArrow();
        String semExp = et.matchSemanticExpression();
        return new CreateVertexClass(et.context, qname, semExp);
    }

    @Override
    protected VertexClass transform() {
        switch (this.context.phase) {
            case SCHEMA: {
                VertexClass vc = this.context.targetSchema.getGraphClass().createVertexClass(this.qualifiedName);
                this.context.ensureMappings(vc);
                return vc;
            }
            case GRAPH: {
                VertexClass vertexClass = this.context.targetGraph.getGraphClass().getVertexClass(this.qualifiedName);
                assert (vertexClass != null) : "Couldn't get VertexClass '" + this.qualifiedName + "'.";
                if (this.archetypes != null) {
                    new CreateVertices(this.context, vertexClass, this.archetypes).execute();
                } else {
                    new CreateVertices(this.context, vertexClass, this.semanticExpression).execute();
                }
                return vertexClass;
            }
        }
        throw new GReTLException(this.context, "Unknown TransformationPhase " + (Object)((Object)this.context.phase) + "!");
    }
}

