/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CreateEdges;
import de.uni_koblenz.jgralab.gretl.CreateVertices;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.SetAttributes;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.gretl.parser.TokenTypes;
import de.uni_koblenz.jgralab.gretl.template.CreateEdge;
import de.uni_koblenz.jgralab.gretl.template.CreateVertex;
import de.uni_koblenz.jgralab.gretl.template.TemplateGraph;
import de.uni_koblenz.jgralab.gretl.templategraphparser.TemplateGraphParser;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.pcollections.Empty;
import org.pcollections.PMap;
import org.pcollections.PSet;

public class CreateSubgraph
extends Transformation<Void> {
    private TemplateGraph templateGraph = null;
    private Object match;
    private String matchText;
    private Set<GraphElement<?, ?>> createdElements = new HashSet();

    public CreateSubgraph(Context c, String subgraphCreationText, Object match) {
        super(c);
        this.templateGraph = TemplateGraphParser.parse(subgraphCreationText);
        this.match = match;
    }

    public CreateSubgraph(Context c, String subgraphCreationText, String greqlText) {
        super(c);
        this.templateGraph = TemplateGraphParser.parse(subgraphCreationText);
        this.matchText = greqlText;
    }

    public CreateSubgraph(Context c, TemplateGraph g, String greqlText) {
        super(c);
        this.templateGraph = g;
        this.matchText = greqlText;
    }

    public static CreateSubgraph parseAndCreate(ExecuteTransformation et) {
        TemplateGraph graph = TemplateGraphParser.parse(et.match((TokenTypes)TokenTypes.DOMAIN_SPECIFIC).value);
        et.matchTransformationArrow();
        String semExp = et.matchSemanticExpression();
        return new CreateSubgraph(et.context, graph, semExp);
    }

    private String getUniqueArchetype() {
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        sb.append(this.context.getUniqueString().toString());
        sb.append("'");
        return sb.toString();
    }

    @Override
    protected Void transform() {
        if (this.context.getPhase() == Context.TransformationPhase.SCHEMA) {
            return null;
        }
        if (this.context.getTargetSchema() == null) {
            throw new GReTLException(this.context, CreateSubgraph.class.getSimpleName() + " needs an existing target schema!");
        }
        for (CreateVertex cv : this.templateGraph.getCreateVertexVertices()) {
            if (cv.get_archetype() != null) continue;
            throw new GReTLException(this.context, "All vertices in the template graph need to have an archetype!");
        }
        if (this.match == null) {
            this.match = this.context.evaluateGReQLQuery(this.matchText);
        }
        PSet<Object> matchCollection = null;
        if (this.match instanceof Collection) {
            matchCollection = (PSet<Object>)this.match;
        } else {
            matchCollection = Empty.set();
            matchCollection = matchCollection.plus(this.match);
        }
        this.applyVertexCreations(matchCollection);
        this.applyEdgeCreations(matchCollection);
        this.applyAttributeSetting(matchCollection);
        return null;
    }

    private void applyVertexCreations(PSet<Object> matchCollection) {
        for (CreateVertex v : this.templateGraph.getCreateVertexVertices()) {
            String qName = CreateSubgraph.getVertexClassName(v, this.context);
            VertexClass vc = this.vc(qName);
            if (vc == null) {
                throw new GReTLException(this.context, "There's no vertex class '" + qName + "' in the target schema.");
            }
            PSet archSet = Empty.set();
            for (Object e : matchCollection) {
                this.context.setGReQLVariable("$", e);
                Object arch = this.context.evaluateGReQLQuery(v.get_archetype());
                if (this.context.getImg(vc).containsKey(arch)) {
                    logger.finer("There's already an image for '" + arch + "' in " + Context.toGReTLVarNotation(qName, Context.GReTLVariableType.IMG) + ", so we use that instead.");
                    continue;
                }
                archSet = archSet.plus(arch);
            }
            logger.finer("Instantiating " + archSet.size() + " '" + vc.getQualifiedName() + "' vertices.");
            this.createdElements.addAll((Collection)new CreateVertices(this.context, vc, archSet).execute());
        }
    }

    public static String getVertexClassName(CreateVertex v, Context context) {
        if (v.get_typeName() != null) {
            String type = v.get_typeName();
            if (v.is_typeNameIsQuery()) {
                return context.evaluateGReQLQuery(type).toString();
            }
            return v.get_typeName();
        }
        VertexClass mostSpecialVClass = context.getTargetSchema().getGraphClass().getDefaultVertexClass();
        for (CreateEdge e : v.getCreateEdgeIncidences()) {
            String eType = e.get_typeName();
            EdgeClass eClass = (EdgeClass)context.getTargetSchema().getAttributedElementClass(eType);
            VertexClass vClass = e.isNormal() ? eClass.getFrom().getVertexClass() : eClass.getTo().getVertexClass();
            if (!vClass.isSubClassOf(mostSpecialVClass)) continue;
            mostSpecialVClass = vClass;
        }
        if (mostSpecialVClass == context.getTargetSchema().getGraphClass().getDefaultVertexClass()) {
            throw new GReTLException(context, "Couldn't determine typeName for " + v + ".");
        }
        v.set_typeName(mostSpecialVClass.getQualifiedName());
        return v.get_typeName();
    }

    private void applyEdgeCreations(PSet<Object> matchCollection) {
        for (CreateEdge e : this.templateGraph.getCreateEdgeEdges()) {
            String qName = e.get_typeName();
            EdgeClass ec = null;
            if (e.is_typeNameIsQuery()) {
                this.ec(this.context.evaluateGReQLQuery(qName).toString());
            } else {
                ec = this.ec(qName);
            }
            if (ec == null) {
                throw new GReTLException(this.context, "There's no edge class '" + qName + "' in the target schema.");
            }
            PSet<Tuple> archTripleSet = Empty.set();
            for (Object e2 : matchCollection) {
                this.context.setGReQLVariable("$", e2);
                Tuple triple = Tuple.empty();
                Object arch = this.context.evaluateGReQLQuery(this.getArch(e.get_archetype()));
                triple = triple.plus(arch);
                triple = triple.plus(this.context.evaluateGReQLQuery(e.getAlpha().get_archetype()));
                triple = triple.plus(this.context.evaluateGReQLQuery(e.getOmega().get_archetype()));
                archTripleSet = archTripleSet.plus(triple);
            }
            logger.finer("Instantiating " + archTripleSet.size() + " '" + ec.getQualifiedName() + "' edges.");
            this.createdElements.addAll((Collection)new CreateEdges(this.context, ec, archTripleSet).execute());
        }
    }

    private String getArch(String archStr) {
        if (archStr == null) {
            return this.getUniqueArchetype();
        }
        return archStr;
    }

    private void applyAttributeSetting(PSet<Object> matchCollection) {
        LinkedList<Iterable<GraphElement<VertexClass, Vertex>>> iterables = new LinkedList<Iterable<GraphElement<VertexClass, Vertex>>>();
        iterables.add(this.templateGraph.getCreateVertexVertices());
        iterables.add(this.templateGraph.getCreateEdgeEdges());
        for (Iterable iterable : iterables) {
            for (GraphElement ge : iterable) {
                PMap<String, String> attrs;
                String archetype;
                AttributedElementClass<?, ?> aec;
                String qName;
                if (ge instanceof CreateVertex) {
                    CreateVertex cv = (CreateVertex)ge;
                    qName = CreateSubgraph.getVertexClassName(cv, this.context);
                    aec = this.aec(qName);
                    archetype = cv.get_archetype();
                    attrs = cv.get_attributes();
                } else {
                    CreateEdge ce = (CreateEdge)ge;
                    qName = ce.get_typeName();
                    aec = this.aec(qName);
                    archetype = ce.get_archetype();
                    attrs = ce.get_attributes();
                }
                if (aec == null) {
                    throw new GReTLException(this.context, "There's no attributed element class '" + qName + "' in the target schema.");
                }
                if (attrs == null) continue;
                for (Map.Entry e : attrs.entrySet()) {
                    Attribute attr = aec.getAttribute((String)e.getKey());
                    if (attr == null) {
                        throw new GReTLException(this.context, "There's no attribute '" + (String)e.getKey() + "' defined for '" + aec.getQualifiedName() + "' in the target schema.");
                    }
                    PMap archMap = Empty.orderedMap();
                    for (Object e2 : matchCollection) {
                        this.context.setGReQLVariable("$", e2);
                        archMap = archMap.plus(this.context.evaluateGReQLQuery(archetype), this.context.evaluateGReQLQuery((String)e.getValue()));
                    }
                    new SetAttributes(this.context, attr, archMap).execute();
                }
            }
        }
    }
}

