/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CopyDomain;
import de.uni_koblenz.jgralab.gretl.CreateAttribute;
import de.uni_koblenz.jgralab.gretl.CreateEdgeClass;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.EdgeClass;

public class CopyEdgeClass
extends Transformation<EdgeClass> {
    private EdgeClass originalSourceEC;
    private String sourceGraphAlias;
    private String sourceTargetArchExp;

    public CopyEdgeClass(Context c, EdgeClass sourceEC, String alias, String semExp) {
        super(c);
        this.originalSourceEC = sourceEC;
        this.sourceGraphAlias = alias;
        this.sourceTargetArchExp = semExp;
    }

    public static CopyEdgeClass parseAndCreate(ExecuteTransformation et) {
        String alias = "default";
        if (et.tryMatchGraphAlias()) {
            alias = et.matchGraphAlias();
        }
        String qname = et.matchQualifiedName();
        if (et.context.getSourceGraph(alias) == null) {
            throw new GReTLException(et.context, "There's no source graph with alias '" + alias + "'.");
        }
        EdgeClass sourceEC = et.context.getSourceGraph(alias).getSchema().getGraphClass().getEdgeClass(qname);
        if (sourceEC == null) {
            throw new GReTLException(et.context, "There's no EdgeClass '" + qname + "' in schema of graph with alias '" + alias + "'.");
        }
        et.matchTransformationArrow();
        String semExp = et.matchSemanticExpression();
        return new CopyEdgeClass(et.context, sourceEC, alias, semExp);
    }

    @Override
    protected EdgeClass transform() {
        String qname = this.originalSourceEC.getQualifiedName();
        CreateEdgeClass.IncidenceClassSpec from = new CreateEdgeClass.IncidenceClassSpec(this.vc(this.originalSourceEC.getFrom().getVertexClass().getQualifiedName()), this.originalSourceEC.getFrom());
        CreateEdgeClass.IncidenceClassSpec to = new CreateEdgeClass.IncidenceClassSpec(this.vc(this.originalSourceEC.getTo().getVertexClass().getQualifiedName()), this.originalSourceEC.getTo());
        EdgeClass copiedEC = (EdgeClass)new CreateEdgeClass(this.context, qname, from, to, "#" + this.sourceGraphAlias + "# from e: E{" + qname + "!} reportSet e, " + this.sourceTargetArchExp + " end").execute();
        for (Attribute oldAttr : this.originalSourceEC.getOwnAttributeList()) {
            new CreateAttribute(this.context, new CreateAttribute.AttributeSpec(copiedEC, oldAttr.getName(), (Domain)new CopyDomain(this.context, oldAttr.getDomain()).execute()), "from e: keySet(img_" + copiedEC.getQualifiedName() + ") reportMap e -> e." + oldAttr.getName() + " end").execute();
        }
        return copiedEC;
    }
}

