/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;

public class AddSubClass
extends Transformation<GraphElementClass<?, ?>> {
    private GraphElementClass<?, ?> superClass;
    private GraphElementClass<?, ?> subClass;

    public AddSubClass(Context c, VertexClass superClass, VertexClass subClass) {
        super(c);
        this.superClass = superClass;
        this.subClass = subClass;
    }

    public AddSubClass(Context c, EdgeClass superClass, EdgeClass subClass) {
        super(c);
        this.superClass = superClass;
        this.subClass = subClass;
    }

    public static AddSubClass parseAndCreate(ExecuteTransformation et) {
        GraphElementClass<?, ?> superGec = et.matchGraphElementClass();
        if (superGec instanceof VertexClass) {
            VertexClass subVC = et.matchVertexClass();
            return new AddSubClass(et.context, (VertexClass)superGec, subVC);
        }
        EdgeClass subEC = et.matchEdgeClass();
        return new AddSubClass(et.context, (EdgeClass)superGec, subEC);
    }

    @Override
    protected GraphElementClass<?, ?> transform() {
        if (this.context.phase != Context.TransformationPhase.SCHEMA) {
            return this.superClass;
        }
        if (this.superClass instanceof VertexClass) {
            ((VertexClass)this.subClass).addSuperClass((VertexClass)this.superClass);
        } else {
            ((EdgeClass)this.subClass).addSuperClass((EdgeClass)this.superClass);
        }
        return this.superClass;
    }
}

