/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.types;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.exception.UnknownTypeException;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.util.BitSet;
import org.pcollections.PSet;

public final class TypeCollection {
    private final PSet<TypeEntry> typeEntries;
    private PSet<TypeEntry> boundTypeEntries;
    private BitSet typeIdSet;
    private Schema schema;
    private int schemaVersion;
    private TcType tcType;
    private static TypeCollection empty = new TypeCollection(JGraLab.set());

    public static TypeCollection empty() {
        return empty;
    }

    public boolean isEmpty() {
        return this.typeEntries.isEmpty();
    }

    public TypeCollection with(String typeName, boolean exactType, boolean forbidden) {
        TypeEntry n = new TypeEntry(typeName, exactType, forbidden);
        if (this.typeEntries.contains(n)) {
            return this;
        }
        return new TypeCollection(this.typeEntries.plus(n));
    }

    public TypeCollection combine(TypeCollection other) {
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        return new TypeCollection(this.typeEntries.plusAll(other.typeEntries));
    }

    private TypeCollection(PSet<TypeEntry> types) {
        this.typeEntries = types;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TypeCollection o = (TypeCollection)obj;
        return this.typeEntries.equals(o.typeEntries);
    }

    public int hashCode() {
        return this.typeEntries.hashCode();
    }

    public boolean acceptsType(GraphElementClass<?, ?> type) {
        assert (this.isBound());
        return this.isEmpty() || this.typeIdSet.get(type.getGraphElementClassIdInSchema());
    }

    public boolean isBound() {
        return this.isEmpty() || this.schema != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String delim = "{";
        for (TypeEntry e : this.typeEntries) {
            sb.append(delim).append(e.toString());
            delim = ", ";
        }
        return sb.append("}").toString();
    }

    public double getFrequency(OptimizerInfo info) {
        if (this.isEmpty()) {
            return 1.0;
        }
        if (this.schema == null) {
            throw new IllegalStateException("TypeCollection isn't bound to a Schema");
        }
        double f = 0.0;
        double a = 0.0;
        boolean hasAllowedTypes = false;
        for (TypeEntry e : this.boundTypeEntries) {
            if (e.forbidden) {
                f += e.exactType ? info.getFrequencyOfGraphElementClassWithoutSubclasses(e.gec) : info.getFrequencyOfGraphElementClass(e.gec);
                continue;
            }
            a += e.exactType ? info.getFrequencyOfGraphElementClassWithoutSubclasses(e.gec) : info.getFrequencyOfGraphElementClass(e.gec);
            hasAllowedTypes = true;
        }
        f = Math.min(1.0, f);
        if (hasAllowedTypes) {
            a = Math.min(1.0, a);
            return Math.max(a - f, 0.0);
        }
        return 1.0 - f;
    }

    public long getEstimatedGraphElementCount(OptimizerInfo info) {
        if (!this.isEmpty() && this.schema == null) {
            throw new IllegalStateException("TypeCollection isn't bound to a Schema");
        }
        switch (this.tcType) {
            case VERTEX: {
                return (long)(this.getFrequency(info) * (double)info.getAverageVertexCount());
            }
            case EDGE: {
                return (long)(this.getFrequency(info) * (double)info.getAverageEdgeCount());
            }
        }
        return (long)(this.getFrequency(info) * (double)(info.getAverageVertexCount() + info.getAverageEdgeCount()));
    }

    public TypeCollection bindToSchema(InternalGreqlEvaluator evaluator) {
        Schema s = evaluator.getSchema();
        if (s == null) {
            throw new IllegalArgumentException("Evaluator doesn't contain a Schema");
        }
        if (!s.isFinished()) {
            throw new IllegalStateException("Schema is not finished");
        }
        if (this.schema == null && s != null) {
            return new TypeCollection(this.typeEntries, evaluator, evaluator.getSchema());
        }
        if (this.isEmpty()) {
            return this;
        }
        if (s == this.schema && s.getVersion() == this.schemaVersion) {
            return this;
        }
        return new TypeCollection(this.typeEntries, evaluator, evaluator.getSchema());
    }

    public TypeCollection bindToSchema(Schema s) {
        if (!s.isFinished()) {
            throw new IllegalStateException("Schema is not finished");
        }
        if (this.schema == null && s != null) {
            return new TypeCollection(this.typeEntries, null, s);
        }
        if (this.isEmpty()) {
            return this;
        }
        if (s == this.schema && s.getVersion() == this.schemaVersion) {
            return this;
        }
        return new TypeCollection(this.typeEntries, null, s);
    }

    private TypeCollection(PSet<TypeEntry> types, InternalGreqlEvaluator evaluator, Schema s) {
        this(types);
        this.schema = s;
        this.schemaVersion = s.getVersion();
        this.boundTypeEntries = JGraLab.set();
        for (TypeEntry unboundEntry : this.typeEntries) {
            TypeEntry boundEntry = new TypeEntry(unboundEntry.typeName, unboundEntry.exactType, unboundEntry.forbidden);
            if (evaluator != null) {
                boundEntry.gec = evaluator.getGraphElementClass(boundEntry.typeName);
            } else {
                boundEntry.gec = (GraphElementClass)this.schema.getAttributedElementClass(boundEntry.typeName);
                if (boundEntry.gec == null) {
                    throw new UnknownTypeException(boundEntry.typeName);
                }
            }
            if (this.boundTypeEntries.isEmpty()) {
                this.boundTypeEntries = this.boundTypeEntries.plus(boundEntry);
                continue;
            }
            PSet<TypeEntry> t = this.boundTypeEntries;
            boolean subsumed = false;
            for (TypeEntry e : this.boundTypeEntries) {
                if (e.subsumes(boundEntry)) {
                    subsumed = true;
                    continue;
                }
                if (!boundEntry.subsumes(e)) continue;
                t = t.minus(e);
            }
            if (!subsumed) {
                t = t.plus(boundEntry);
            }
            this.boundTypeEntries = t;
        }
        BitSet a = new BitSet(s.getGraphElementClassCount());
        BitSet f = new BitSet(s.getGraphElementClassCount());
        boolean hasAllowedTypes = false;
        for (TypeEntry e : this.boundTypeEntries) {
            TcType t;
            if (!e.forbidden) {
                hasAllowedTypes = true;
            }
            TcType tcType = t = e.gec instanceof VertexClass ? TcType.VERTEX : TcType.EDGE;
            this.tcType = this.tcType == null ? t : (t == this.tcType ? t : TcType.UNKNOWN);
            BitSet b = e.forbidden ? f : a;
            b.set(e.gec.getGraphElementClassIdInSchema());
            if (e.exactType) continue;
            for (GraphElementClass sub : e.gec.getAllSubClasses()) {
                b.set(sub.getGraphElementClassIdInSchema());
            }
        }
        if (!hasAllowedTypes) {
            this.typeIdSet = f;
            this.typeIdSet.flip(0, this.schema.getGraphElementClassCount());
        } else {
            this.typeIdSet = a;
            this.typeIdSet.andNot(f);
        }
        if (this.tcType == TcType.VERTEX) {
            for (EdgeClass ec : this.schema.getGraphClass().getEdgeClasses()) {
                this.typeIdSet.clear(ec.getGraphElementClassIdInSchema());
            }
        } else if (this.tcType == TcType.EDGE) {
            for (VertexClass vc : this.schema.getGraphClass().getVertexClasses()) {
                this.typeIdSet.clear(vc.getGraphElementClassIdInSchema());
            }
        }
        if (this.tcType == null) {
            this.tcType = TcType.UNKNOWN;
        }
    }

    public TcType getTcType() {
        if (this.schema == null) {
            throw new IllegalStateException("TypeCollection isn't bound to a Schema");
        }
        return this.tcType;
    }

    public BitSet getTypeIdSet() {
        if (this.schema == null) {
            throw new IllegalStateException("TypeCollection isn't bound to a Schema");
        }
        return this.typeIdSet;
    }

    static {
        TypeCollection.empty.tcType = TcType.UNKNOWN;
    }

    private static final class TypeEntry {
        String typeName;
        boolean exactType;
        boolean forbidden;
        GraphElementClass<?, ?> gec;

        public TypeEntry(String typeName, boolean exactType, boolean forbidden) {
            this.typeName = typeName;
            this.exactType = exactType;
            this.forbidden = forbidden;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            TypeEntry o = (TypeEntry)obj;
            return this.exactType == o.exactType && this.forbidden == o.forbidden && this.typeName.equals(o.typeName);
        }

        public int hashCode() {
            return this.typeName.hashCode();
        }

        public String toString() {
            return (this.forbidden ? "^" : "") + this.typeName + (this.exactType ? "!" : "");
        }

        private boolean subsumes(TypeEntry o) {
            assert (this.gec != null) : "TypeEntry is not bound to a schema";
            if (this.equals(o)) {
                return true;
            }
            if (this.exactType) {
                return false;
            }
            if (this.forbidden) {
                return this.gec.getAllSubClasses().contains(o.gec);
            }
            if (this.forbidden != o.forbidden) {
                return false;
            }
            return this.gec.getAllSubClasses().contains(o.gec);
        }
    }

    private static enum TcType {
        VERTEX,
        EDGE,
        UNKNOWN;

    }
}

