/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.serialising;

import de.uni_koblenz.ist.utilities.xml.XmlProcessor;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.exception.SerialisingException;
import de.uni_koblenz.jgralab.greql.serialising.XMLConstants;
import de.uni_koblenz.jgralab.greql.types.Path;
import de.uni_koblenz.jgralab.greql.types.PathSystem;
import de.uni_koblenz.jgralab.greql.types.Table;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import de.uni_koblenz.jgralab.greql.types.Undefined;
import de.uni_koblenz.jgralab.impl.RecordImpl;
import de.uni_koblenz.jgralab.schema.Schema;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import org.pcollections.PCollection;
import org.pcollections.PMap;
import org.pcollections.PVector;

public class XMLLoader
extends XmlProcessor
implements XMLConstants {
    private Graph defaultGraph;
    private PathSystem pathSystem;
    private Path path;
    private Map<String, Graph> id2GraphMap = null;
    private Map<String, Schema> schemaName2Schema = null;
    private final Stack<Object> stack = new Stack();

    public XMLLoader(Graph ... graphs) {
        this.id2GraphMap = new HashMap<String, Graph>(graphs.length);
        for (Graph g : graphs) {
            this.id2GraphMap.put(g.getId(), g);
        }
        this.schemaName2Schema = new HashMap<String, Schema>(graphs.length);
        for (Graph g : graphs) {
            Schema s = g.getSchema();
            this.schemaName2Schema.put(s.getQualifiedName(), s);
        }
    }

    public Object load(String fileName) throws FileNotFoundException, XMLStreamException {
        this.process(fileName);
        if (this.stack.size() != 1) {
            throw new SerialisingException("Something went wrong.  stack.size() = " + this.stack.size() + " != 1.  This must not happen!", (Object)null);
        }
        return this.stack.firstElement();
    }

    @Override
    protected void endDocument() throws XMLStreamException {
    }

    @Override
    protected void endElement(String name, StringBuilder content) throws XMLStreamException {
        if (name.equals("object")) {
            return;
        }
        Object endedElement = this.stack.pop();
        if (this.stack.isEmpty()) {
            this.stack.push(endedElement);
            return;
        }
        Object parentElement = this.stack.peek();
        if (parentElement instanceof PMap) {
            MapEntry jme = (MapEntry)endedElement;
            PMap map = (PMap)parentElement;
            parentElement = map.plus(jme.key, jme.value);
        } else {
            if (parentElement instanceof MapEntry) {
                MapEntry jme = (MapEntry)parentElement;
                if (jme.key == null) {
                    jme.key = endedElement;
                } else if (jme.value == null) {
                    jme.value = endedElement;
                }
                return;
            }
            if (parentElement instanceof RecordComponent) {
                RecordComponent rc = (RecordComponent)parentElement;
                rc.value = endedElement;
                return;
            }
            if (parentElement instanceof PCollection) {
                if (parentElement instanceof RecordImpl) {
                    RecordImpl rec = (RecordImpl)parentElement;
                    RecordComponent comp = (RecordComponent)endedElement;
                    parentElement = rec.plus(comp.componentName, comp.value);
                } else if (parentElement instanceof Table) {
                    Table tab = (Table)parentElement;
                    if (tab.getTitles().isEmpty()) {
                        PVector titles = (PVector)endedElement;
                        parentElement = tab.withTitles(titles);
                    } else {
                        PVector entries = (PVector)endedElement;
                        parentElement = tab.plusAll((Collection)entries);
                    }
                } else {
                    PCollection coll = (PCollection)parentElement;
                    parentElement = coll.plus(endedElement);
                }
                this.stack.pop();
                this.stack.push(parentElement);
            } else if (parentElement == Path.class) {
                assert (endedElement instanceof List);
                if (this.path == null) {
                    List vertices = (List)endedElement;
                    this.path = Path.start((Vertex)vertices.get(0));
                } else {
                    List edges = (List)endedElement;
                    for (Edge e : edges) {
                        this.path = this.path.append(e);
                    }
                    this.stack.pop();
                    this.stack.push(this.path);
                    this.path = null;
                }
            } else if (parentElement instanceof PathSystem) {
                PathSystemNodeEntry nodeEntry = (PathSystemNodeEntry)endedElement;
                PathSystem.PathSystemNode node = this.pathSystem.setRootVertex(nodeEntry.currentVertex, nodeEntry.state, nodeEntry.isLeaf);
                for (PathSystem.PathSystemNode child : nodeEntry.children) {
                    this.pathSystem.addEdge(child, node, child.edge2parent);
                }
                this.pathSystem.finish();
                this.pathSystem = null;
            } else if (parentElement instanceof PathSystemNodeEntry) {
                PathSystemNodeEntry parentNode = (PathSystemNodeEntry)parentElement;
                if (endedElement instanceof PathSystemNodeEntry) {
                    PathSystemNodeEntry nodeEntry = (PathSystemNodeEntry)endedElement;
                    PathSystem.PathSystemNode node = this.pathSystem.addVertex(nodeEntry.currentVertex, nodeEntry.state, nodeEntry.isLeaf);
                    node.edge2parent = nodeEntry.edge2Parent;
                    for (PathSystem.PathSystemNode child : nodeEntry.children) {
                        this.pathSystem.addEdge(child, node, child.edge2parent);
                    }
                    parentNode.children.add(node);
                } else if (endedElement instanceof Vertex) {
                    parentNode.currentVertex = (Vertex)endedElement;
                } else if (endedElement instanceof Edge) {
                    parentNode.edge2Parent = (Edge)endedElement;
                }
            } else {
                throw new SerialisingException("The element '" + endedElement + "' couldn't be added to its parent.", (Object)null);
            }
        }
    }

    @Override
    protected void startDocument() throws XMLStreamException {
        this.stack.clear();
    }

    @Override
    protected void startElement(String elem) throws XMLStreamException {
        Object val = null;
        if (elem.equals("undefined")) {
            val = Undefined.UNDEFINED;
        } else {
            if (elem.equals("graph") || elem.equals("object")) {
                String gid = this.getAttribute("graphId");
                if (gid != null) {
                    this.defaultGraph = this.id2GraphMap.get(gid);
                    if (this.defaultGraph == null) {
                        throw new SerialisingException("There's no graph with id '" + gid + "'.", (Object)null);
                    }
                }
                return;
            }
            if (elem.equals("attributedElementClass")) {
                String qName = this.getAttribute("name");
                String schemaName = this.getAttribute("schema");
                Schema schema = this.schemaName2Schema.get(schemaName);
                if (schema == null) {
                    throw new SerialisingException("Couldn't retrieve Schema '" + schemaName + "'", (Object)null);
                }
                Object aec = schema.getAttributedElementClass(qName);
                if (aec == null) {
                    throw new SerialisingException("Couldn't retrieve attributed element '" + qName + "' from schema '" + schemaName + "'.", (Object)null);
                }
                val = aec;
            } else if (elem.equals("boolean")) {
                val = Boolean.valueOf(this.getAttribute("value"));
            } else if (elem.equals("double")) {
                val = Double.valueOf(this.getAttribute("value"));
            } else if (elem.equals("edge")) {
                int id = Integer.valueOf(this.getAttribute("id"));
                Graph g = this.defaultGraph;
                String gid = this.getAttribute("graphId");
                if (gid != null && (g = this.id2GraphMap.get(gid)) == null) {
                    throw new SerialisingException("There's no graph with id '" + gid + "'.", (Object)null);
                }
                Edge e = g.getEdge(id);
                if (e == null) {
                    throw new SerialisingException("There's no edge with id '" + id + "' in graph '" + g.getId() + "'.", (Object)null);
                }
                val = e;
            } else if (elem.equals("enum")) {
                String litName = this.getAttribute("value");
                String enumTypeName = this.getAttribute("type");
                val = this.createEnum(litName, enumTypeName);
            } else if (elem.equals("graph")) {
                String gid = this.getAttribute("graphId");
                Graph g = this.id2GraphMap.get(gid);
                if (g == null) {
                    throw new SerialisingException("There's no graph with id '" + gid + "'.", (Object)null);
                }
                val = g;
            } else if (elem.equals("integer")) {
                val = Integer.valueOf(this.getAttribute("value"));
            } else if (elem.equals("list")) {
                val = JGraLab.vector();
            } else if (elem.equals("long")) {
                val = Long.valueOf(this.getAttribute("value"));
            } else if (elem.equals("map")) {
                val = JGraLab.map();
            } else if (elem.equals("entry")) {
                val = new MapEntry();
            } else if (elem.equals("record")) {
                val = RecordImpl.empty();
            } else if (elem.equals("comp")) {
                val = new RecordComponent(this.getAttribute("name"));
            } else if (elem.equals("set")) {
                val = JGraLab.set();
            } else if (elem.equals("string")) {
                val = this.getAttribute("value");
            } else if (elem.equals("table")) {
                Table tab = Table.empty();
                tab = tab.withTitles(null);
                val = tab;
            } else if (elem.equals("tup")) {
                val = Tuple.empty();
            } else if (elem.equals("vertex")) {
                int id = Integer.valueOf(this.getAttribute("id"));
                Graph g = this.defaultGraph;
                String gid = this.getAttribute("graphId");
                if (gid != null && (g = this.id2GraphMap.get(gid)) == null) {
                    throw new SerialisingException("There's no graph with id '" + gid + "'.", (Object)null);
                }
                Vertex v = g.getVertex(id);
                if (v == null) {
                    throw new SerialisingException("There's no vertex with id '" + id + "' in graph '" + g.getId() + "'.", (Object)null);
                }
                val = v;
            } else if (elem.equals("path")) {
                val = Path.class;
            } else if (elem.equals("pathSystem")) {
                this.pathSystem = new PathSystem();
                val = this.pathSystem;
            } else if (elem.equals("node")) {
                PathSystemNodeEntry nodeEntry = new PathSystemNodeEntry();
                nodeEntry.state = Integer.parseInt(this.getAttribute("state"));
                nodeEntry.isLeaf = this.getAttribute("isLeaf").equals("true");
                val = nodeEntry;
            } else {
                throw new SerialisingException("Unrecognized XML element '" + elem + "'.", (Object)null);
            }
        }
        if (val == null) {
            throw new SerialisingException("Couldn't read the value of element '" + elem + "'.", (Object)null);
        }
        this.stack.push(val);
    }

    private Object createEnum(String litName, String enumTypeName) {
        Object val = null;
        try {
            Class<?> e = Class.forName(enumTypeName);
            val = Enum.valueOf(e, litName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new SerialisingException("The Enum class '" + enumTypeName + "' could not be loaded.", (Object)e);
        }
        return val;
    }

    private static class PathSystemNodeEntry {
        Vertex currentVertex;
        int state;
        Edge edge2Parent;
        boolean isLeaf = true;
        List<PathSystem.PathSystemNode> children = new ArrayList<PathSystem.PathSystemNode>();

        private PathSystemNodeEntry() {
        }

        public String toString() {
            return "(currentVertex: " + this.currentVertex + " state: " + this.state + " edge2Parent: " + this.edge2Parent + " isLeaf: " + this.isLeaf + ")" + " children: " + this.children;
        }
    }

    private static class MapEntry {
        Object key = null;
        Object value = null;

        private MapEntry() {
        }
    }

    private static class RecordComponent {
        String componentName;
        Object value;

        RecordComponent(String compName) {
            this.componentName = compName;
        }
    }
}

