/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.greql.optimizer.DefaultOptimizerInfo;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.HashMap;

public class OptimizerInfoGenerator {
    private Schema schema;
    private HashMap<GraphElementClass<?, ?>, Long> gecCount;
    private HashMap<GraphElementClass<?, ?>, Long> gecWithSubclassCount;
    private long totalVertexCount;
    private long totalEdgeCount;
    private int graphCount;

    public OptimizerInfoGenerator(Schema schema) {
        if (schema == null) {
            throw new IllegalArgumentException("Schema must not be null");
        }
        this.schema = schema;
        this.gecCount = new HashMap();
        this.gecWithSubclassCount = new HashMap();
        for (GraphElementClass<?, ?> gec : schema.getGraphClass().getGraphElementClasses()) {
            this.gecCount.put(gec, 0L);
        }
    }

    public void scanGraph(Graph graph) {
        if (!this.schema.equals(graph.getSchema())) {
            throw new IllegalArgumentException("Graph has different schema, expected \"" + this.schema.getQualifiedName() + "\", found \"" + graph.getSchema().getQualifiedName() + "\"");
        }
        ++this.graphCount;
        this.totalVertexCount += (long)graph.getVCount();
        for (Vertex v : graph.vertices()) {
            this.gecCount.put(v.getAttributedElementClass(), this.gecCount.get(v.getAttributedElementClass()) + 1L);
        }
        this.totalEdgeCount += (long)graph.getECount();
        for (Edge e : graph.edges()) {
            this.gecCount.put(e.getAttributedElementClass(), this.gecCount.get(e.getAttributedElementClass()) + 1L);
        }
    }

    public void scanDirectory(String dirName, FilenameFilter filter, boolean recursive) throws GraphIOException {
        File graphDir = new File(dirName);
        System.out.println("Scanning directory \"" + graphDir.getPath() + "\" ...");
        for (File file : graphDir.listFiles()) {
            if (file.isFile() && file.canRead() && filter.accept(graphDir, file.getName())) {
                Graph graph = GraphIO.loadGraphFromFile(file.getPath(), ImplementationType.GENERIC, (ProgressFunction)new ConsoleProgressFunction(file.getName()));
                this.scanGraph(graph);
                continue;
            }
            if (!recursive || !file.isDirectory() || !file.canRead()) continue;
            this.scanDirectory(file.getPath(), filter, recursive);
        }
    }

    public void scanDirectory(String dirName) throws GraphIOException {
        this.scanDirectory(dirName, GraphIO.TGFilenameFilter.instance(), false);
    }

    public void scanDirectory(String dirName, boolean recursive) throws GraphIOException {
        this.scanDirectory(dirName, GraphIO.TGFilenameFilter.instance(), recursive);
    }

    public void storeOptimizerInfo(String propFilename) throws IOException {
        this.computeSubclassCounts();
        DefaultOptimizerInfo info = new DefaultOptimizerInfo(this.schema);
        info.setAvgVertexCount(this.totalVertexCount / (long)this.graphCount);
        info.setAvgEdgeCount(this.totalEdgeCount / (long)this.graphCount);
        for (GraphElementClass<?, ?> gec : this.schema.getGraphClass().getGraphElementClasses()) {
            info.setFrequencies(gec, this.getFrequency(gec, false), this.getFrequency(gec, true));
        }
        info.storePropertyFile(propFilename);
    }

    public long getCount(GraphElementClass<?, ?> gec, boolean withSubclasses) {
        this.assertGraphScanned();
        if (withSubclasses) {
            return this.gecWithSubclassCount.get(gec);
        }
        return this.gecCount.get(gec);
    }

    public double getFrequency(GraphElementClass<?, ?> gec, boolean withSubclasses) {
        this.assertGraphScanned();
        return (double)this.getCount(gec, withSubclasses) / (double)(gec instanceof VertexClass ? this.totalVertexCount : this.totalEdgeCount);
    }

    public void printStatistics(PrintStream out) {
        this.computeSubclassCounts();
        out.println("Schema\t" + this.schema.getQualifiedName());
        out.println("Graphs\t" + this.graphCount);
        out.println("Vertices\t" + this.totalVertexCount);
        out.println("Edges\t" + this.totalEdgeCount);
        out.println("V/E\tGraphElementClass\tcount\twith subclasses\tfreq\twith subclasses");
        NumberFormat fmt = NumberFormat.getInstance();
        fmt.setMaximumFractionDigits(16);
        for (GraphElementClass<?, ?> gec : this.schema.getGraphClass().getGraphElementClasses()) {
            out.println((gec instanceof VertexClass ? "V" : "E") + "\t" + gec.getQualifiedName() + "\t" + this.getCount(gec, false) + "\t" + this.getCount(gec, true) + "\t" + fmt.format(this.getFrequency(gec, false)) + "\t" + fmt.format(this.getFrequency(gec, true)));
        }
    }

    private void computeSubclassCounts() {
        this.assertGraphScanned();
        for (GraphElementClass<?, ?> gec : this.schema.getGraphClass().getGraphElementClasses()) {
            long cnt = this.gecCount.get(gec);
            for (GraphElementClass sub : gec.getAllSubClasses()) {
                cnt += this.gecCount.get(sub).longValue();
            }
            this.gecWithSubclassCount.put(gec, cnt);
        }
    }

    private void assertGraphScanned() {
        if (this.graphCount == 0) {
            throw new IllegalStateException("No graph scanned yet");
        }
    }
}

