/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.IsConstraintOf;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class MergeConstraintsOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(MergeConstraintsOptimizer.class);

    MergeConstraintsOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof MergeConstraintsOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery query) throws OptimizerException {
        GreqlGraph syntaxgraph = query.getQueryGraph();
        ArrayList<Declaration> declarations = new ArrayList<Declaration>();
        for (Declaration decl : syntaxgraph.getDeclarationVertices()) {
            declarations.add(decl);
        }
        boolean constraintsGotMerged = false;
        for (Declaration decl : declarations) {
            ArrayList<IsConstraintOf> constraintEdges = new ArrayList<IsConstraintOf>();
            for (IsConstraintOf constraint : decl.getIsConstraintOfIncidences(EdgeDirection.IN)) {
                constraintEdges.add(constraint);
                constraint = constraint.getNextIsConstraintOfIncidence();
            }
            if (constraintEdges.size() <= 1) continue;
            constraintsGotMerged = true;
            Expression singleConstraint = this.createConjunction(constraintEdges, syntaxgraph);
            logger.finer(this.optimizerHeaderString() + "Merging constraints on edges " + constraintEdges + " into conjunction " + singleConstraint + ".");
            for (IsConstraintOf e : constraintEdges) {
                e.delete();
            }
            syntaxgraph.createIsConstraintOf(singleConstraint, decl);
        }
        return constraintsGotMerged;
    }

    public Expression createConjunction(List<IsConstraintOf> constraintEdges, GreqlGraph syntaxgraph) {
        if (constraintEdges.size() == 1) {
            return constraintEdges.get(0).getAlpha();
        }
        FunctionApplication funApp = syntaxgraph.createFunctionApplication();
        FunctionId funId = OptimizerUtility.findOrCreateFunctionId("and", syntaxgraph);
        syntaxgraph.createIsFunctionIdOf(funId, funApp);
        syntaxgraph.createIsArgumentOf(constraintEdges.get(0).getAlpha(), funApp);
        syntaxgraph.createIsArgumentOf(this.createConjunction(constraintEdges.subList(1, constraintEdges.size()), syntaxgraph), funApp);
        return funApp;
    }
}

