/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.statistics;

import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import java.util.ArrayList;
import java.util.Collection;

public class Variance
extends Function {
    @Description(params={"l"}, description="Returns the variance of the given collection of numbers.\nIf the size of the collection is less than 2, the variance is undefined.", categories={Function.Category.STATISTICS})
    public Variance() {
    }

    public Double evaluate(Collection<Number> l) {
        if (l.size() < 1) {
            return null;
        }
        double sum = 0.0;
        for (Number n : l) {
            sum += n.doubleValue();
        }
        double mean = sum / (double)l.size();
        sum = 0.0;
        for (Number n : l) {
            double d = n.doubleValue() - mean;
            sum += d * d;
        }
        return sum / (double)(l.size() - 1);
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> inElements) {
        return inElements.get(0);
    }
}

