/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.collections;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class SubCollection
extends Function {
    @Description(params={"coll", "startIndex", "endIndex"}, description="Returns a sub PVector starting at the given start index (including),\nand ending at the given end index (excluding).", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> PVector<T> evaluate(PVector<T> coll, Integer startIndex, Integer endIndex) {
        if (startIndex < 0 || endIndex > coll.size() || startIndex > endIndex) {
            return null;
        }
        return coll.subList(startIndex, endIndex);
    }

    @Description(params={"coll", "startIndex"}, description="Returns a sub PVector starting at the given start index (including).", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> PVector<T> evaluate(PVector<T> coll, Integer startIndex) {
        return this.evaluate(coll, startIndex, (Integer)coll.size());
    }

    @Description(params={"coll", "startIndex", "endIndex"}, description="Returns a sub PSet starting at the given start index (including),\nand ending at the given end index (excluding).", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> PSet<T> evaluate(PSet<T> coll, Integer startIndex, Integer endIndex) {
        if (startIndex < 0 || endIndex > coll.size() || startIndex > endIndex) {
            return null;
        }
        PSet result = JGraLab.set();
        int idx = 0;
        for (Object item : coll) {
            if (idx == endIndex) break;
            if (idx >= startIndex && idx < endIndex) {
                result = result.plus(item);
            }
            ++idx;
        }
        return result;
    }

    @Description(params={"coll", "startIndex"}, description="Returns a sub PSet starting at the given start index (including).", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> PSet<T> evaluate(PSet<T> coll, Integer startIndex) {
        return this.evaluate(coll, startIndex, (Integer)coll.size());
    }
}

