/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.collections;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import org.pcollections.ArrayPVector;
import org.pcollections.PCollection;
import org.pcollections.PVector;

public class Sort
extends Function {
    @Description(params={"l"}, description="Sorts the given collection according to natural ordering.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public Sort() {
    }

    public PVector<?> evaluate(Tuple t) {
        return null;
    }

    public <T extends Comparable<? super T>> PVector<T> evaluate(PCollection<T> l) {
        if (l.isEmpty()) {
            if (l instanceof ArrayPVector) {
                return (PVector)l;
            }
            return JGraLab.vector();
        }
        Object[] sorted = new Object[l.size()];
        l.toArray(sorted);
        Arrays.sort(sorted);
        PVector<Object> result = JGraLab.vector();
        for (Object x : sorted) {
            result = result.plus((Comparable)x);
        }
        return result;
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> inElements) {
        long n = inElements.get(0);
        return (long)((double)n * Math.log(n));
    }

    @Override
    public long getEstimatedCardinality(int inElements) {
        return inElements;
    }
}

