/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.collections;

import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.types.Table;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import java.util.ArrayList;
import org.pcollections.PMap;
import org.pcollections.POrderedSet;
import org.pcollections.PVector;

public class Get
extends Function {
    public Get() {
        super(2L, 1L, 1.0);
    }

    @Description(params={"v", "i"}, description="Returns the value stored in v at index i. Short notation: v[i]", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> T evaluate(PVector<T> v, Integer i) {
        return i < 0 || i >= v.size() ? null : (T)v.get(i);
    }

    @Description(params={"s", "i"}, description="Returns the value stored in s at index i. Short notation: s[i].", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> T evaluate(POrderedSet<T> s, Integer i) {
        return i < 0 || i >= s.size() ? null : (T)s.get(i);
    }

    @Description(params={"t", "i"}, description="Returns the value stored in t at index i. Short notation: t[i]", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> T evaluate(Table<T> l, Integer i) {
        return i < 0 || i >= l.size() ? null : (T)l.get(i);
    }

    @Description(params={"t", "i"}, description="Returns the i-th of tuple t. Short notation: t[i]", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public Object evaluate(Tuple t, Integer i) {
        return i < 0 || i >= t.size() ? null : t.get(i);
    }

    @Description(params={"map", "key"}, description="Returns the map value associated with key. Short notation: map[key]", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <K, V> V evaluate(PMap<K, V> m, K key) {
        return m.get(key);
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> inElements) {
        return inElements.get(0);
    }

    @Override
    public long getEstimatedCardinality(int inElements) {
        return inElements;
    }
}

