/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.collections;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import java.util.ArrayList;
import org.pcollections.ArrayPMap;
import org.pcollections.ArrayPSet;
import org.pcollections.PMap;
import org.pcollections.PSet;

public class Difference
extends Function {
    @Description(params={"a", "b"}, description="Returns the set-difference a-b.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> PSet<T> evaluate(PSet<T> a, PSet<T> b) {
        if (b.isEmpty()) {
            if (a instanceof ArrayPSet) {
                return a;
            }
            return JGraLab.set().plusAll(a);
        }
        if (a instanceof ArrayPSet) {
            return a.minusAll(b);
        }
        return JGraLab.set().plusAll(a).minusAll(b);
    }

    @Description(params={"a", "b"}, description="Returns the map-difference a-b, w.r.t. the keyset of the maps.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <K, V> PMap<K, V> evaluate(PMap<K, V> a, PMap<K, V> b) {
        if (b.isEmpty()) {
            if (a instanceof ArrayPMap) {
                return a;
            }
            PMap<K, V> result = JGraLab.map();
            return result.plusAll(a);
        }
        if (a instanceof ArrayPMap) {
            return a.minusAll(b.keySet());
        }
        PMap<K, V> result = JGraLab.map();
        return result.plusAll(a).minusAll(b.keySet());
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> inElements) {
        return inElements.get(0) + inElements.get(1);
    }

    @Override
    public long getEstimatedCardinality(int inElements) {
        return inElements;
    }
}

