/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathDescriptionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathSearchEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.funlib.FunLib;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;
import de.uni_koblenz.jgralab.greql.schema.PathExistence;

public class PathExistenceEvaluator
extends PathSearchEvaluator<PathExistence> {
    private FunLib.FunctionInfo fi;

    public PathExistenceEvaluator(PathExistence vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public Object evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        PathDescription p = (PathDescription)((PathExistence)this.vertex).getFirstIsPathOfIncidence(EdgeDirection.IN).getAlpha();
        PathDescriptionEvaluator pathDescEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(p);
        Expression startExpression = ((PathExistence)this.vertex).getFirstIsStartExprOfIncidence(EdgeDirection.IN).getAlpha();
        VertexEvaluator<Expression> startEval = this.query.getVertexEvaluator(startExpression);
        Object res = startEval.getResult(evaluator);
        if (res == null) {
            return null;
        }
        Vertex startVertex = (Vertex)res;
        Expression targetExpression = ((PathExistence)this.vertex).getFirstIsTargetExprOfIncidence(EdgeDirection.IN).getAlpha();
        VertexEvaluator<Expression> targetEval = this.query.getVertexEvaluator(targetExpression);
        Vertex targetVertex = null;
        res = targetEval.getResult(evaluator);
        if (res == null) {
            return null;
        }
        targetVertex = (Vertex)res;
        DFA searchAutomaton = (DFA)evaluator.getLocalAutomaton(this.vertex);
        if (searchAutomaton == null) {
            searchAutomaton = pathDescEval.getNFA(evaluator).getDFA();
            evaluator.setLocalAutomaton(this.vertex, searchAutomaton);
        }
        Object[] arguments = new Object[]{evaluator, startVertex, targetVertex, searchAutomaton};
        if (this.fi == null) {
            this.fi = FunLib.getFunctionInfo("isReachable");
        }
        return FunLib.apply(this.fi, arguments);
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        long searchCosts;
        PathExistence existence = (PathExistence)this.getVertex();
        Expression startExpression = existence.getFirstIsStartExprOfIncidence().getAlpha();
        VertexEvaluator<Expression> vertexEval = this.query.getVertexEvaluator(startExpression);
        long startCosts = vertexEval.getCurrentSubtreeEvaluationCosts();
        Expression targetExpression = existence.getFirstIsTargetExprOfIncidence().getAlpha();
        vertexEval = this.query.getVertexEvaluator(targetExpression);
        long targetCosts = vertexEval.getCurrentSubtreeEvaluationCosts();
        PathDescription p = (PathDescription)existence.getFirstIsPathOfIncidence().getAlpha();
        PathDescriptionEvaluator pathDescEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(p);
        long pathDescCosts = pathDescEval.getCurrentSubtreeEvaluationCosts();
        long ownCosts = searchCosts = Math.round((double)(pathDescCosts * 20L) / 2.0 * Math.sqrt(this.query.getOptimizer().getOptimizerInfo().getAverageEdgeCount()));
        long iteratedCosts = ownCosts * this.getVariableCombinations();
        long subtreeCosts = targetCosts + pathDescCosts + iteratedCosts + startCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }

    @Override
    public double calculateEstimatedSelectivity() {
        return 0.1;
    }
}

